package com.cv.media.lib.model;

import com.cv.media.lib.model.Artwork;
import com.cv.media.lib.model.BaseMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VideoMeta extends BaseMeta {
    protected String language;
    protected String plot;
    protected String outline;
    protected String tagline;
    protected String tmdbId;
    protected String imdbId;
    protected String firstReleaseDate = "";
    protected String firstReleaseCountryShort = "";
    protected String firstReleaseCountry = "";
    protected String releaseCountryShort = "";
    protected String releaseCountry = "";
    protected String originalTitle = "";
    protected int publicationYear;
    protected long seriesId = -1L;
    protected long seasonId = -1L;
    protected int season = -1;
    protected int episode = -1;
    protected String uploader;
    protected Cast casts;
    protected List<Genre> genres = new ArrayList();
    protected List<Trailer> trailers = new ArrayList();
    protected List<Artwork> artworks = new ArrayList();
    protected List<Country> countries = new ArrayList();
    protected Map<String, Certificate> certificates = new HashMap();
    protected Map<String, TitleAKA> akas = new HashMap();
    private long publishLastModifyTime;//影片更新时间
    private long like = 0L;//点赞次数
    private long unlike = 0L;//点踩次数
    private long viewedAll = 0L;//播放次数
    private long viewedDay = 0L;
    private long viewedWeek = 0L;
    private long viewedMonth = 0L;
    private long viewedYear = 0L;
    private int likeStatus;//0-normal,1-like,2-unlike

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getPlot() {
        return plot;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    public String getOutline() {
        return outline;
    }

    public void setOutline(String outline) {
        this.outline = outline;
    }

    public String getTagline() {
        return tagline;
    }

    public void setTagline(String tagline) {
        this.tagline = tagline;
    }

    public String getTmdbId() {
        return tmdbId;
    }

    public void setTmdbId(String tmdbId) {
        this.tmdbId = tmdbId;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public String getFirstReleaseDate() {
        return firstReleaseDate;
    }

    public void setFirstReleaseDate(String firstReleaseDate) {
        this.firstReleaseDate = firstReleaseDate;
    }

    public String getFirstReleaseCountryShort() {
        return firstReleaseCountryShort;
    }

    public void setFirstReleaseCountryShort(String firstReleaseCountryShort) {
        this.firstReleaseCountryShort = firstReleaseCountryShort;
    }

    public String getFirstReleaseCountry() {
        return firstReleaseCountry;
    }

    public void setFirstReleaseCountry(String firstReleaseCountry) {
        this.firstReleaseCountry = firstReleaseCountry;
    }

    public String getReleaseCountryShort() {
        return releaseCountryShort;
    }

    public void setReleaseCountryShort(String releaseCountryShort) {
        this.releaseCountryShort = releaseCountryShort;
    }

    public String getReleaseCountry() {
        return releaseCountry;
    }

    public void setReleaseCountry(String releaseCountry) {
        this.releaseCountry = releaseCountry;
    }

    public String getOriginalTitle() {
        return originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }

    public int getPublicationYear() {
        return publicationYear;
    }

    public void setPublicationYear(int publicationYear) {
        this.publicationYear = publicationYear;
    }

    public long getRuntime() {
        return runtime;
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public long getSeriesId() {
        return seriesId;
    }

    public void setSeriesId(long seriesId) {
        this.seriesId = seriesId;
    }

    public long getSeasonId() {
        return seasonId;
    }

    public void setSeasonId(long seasonId) {
        this.seasonId = seasonId;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public Cast getCasts() {
        return casts;
    }

    public void setCasts(Cast casts) {
        this.casts = casts;
    }

    public List<Genre> getGenres() {
        return genres;
    }

    public void setGenres(List<Genre> genres) {
        this.genres = genres;
    }

    public List<Trailer> getTrailers() {
        return trailers;
    }

    public void setTrailers(List<Trailer> trailers) {
        this.trailers = trailers;
    }

    public List<Artwork> getArtworks() {
        return artworks;
    }

    public void setArtworks(List<Artwork> artworks) {
        this.artworks = artworks;
    }

    public List<Country> getCountries() {
        return countries;
    }

    public void setCountries(List<Country> countries) {
        this.countries = countries;
    }

    public Map<String, Certificate> getCertificates() {
        return certificates;
    }

    public void setCertificates(Map<String, Certificate> certificates) {
        this.certificates = certificates;
    }

    public Map<String, TitleAKA> getAkas() {
        return akas;
    }

    public void setAkas(Map<String, TitleAKA> akas) {
        this.akas = akas;
    }

    public String getUploader() {
        return uploader;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }

    public long getPublishLastModifyTime() {
        return publishLastModifyTime;
    }

    public void setPublishLastModifyTime(long publishLastModifyTime) {
        this.publishLastModifyTime = publishLastModifyTime;
    }

    public long getLike() {
        return like;
    }

    public void setLike(long like) {
        this.like = like;
    }

    public long getUnlike() {
        return unlike;
    }

    public void setUnlike(long unlike) {
        this.unlike = unlike;
    }

    public long getViewedDay() {
        return viewedDay;
    }

    public void setViewedDay(long viewedDay) {
        this.viewedDay = viewedDay;
    }

    public long getViewedWeek() {
        return viewedWeek;
    }

    public void setViewedWeek(long viewedWeek) {
        this.viewedWeek = viewedWeek;
    }

    public long getViewedMonth() {
        return viewedMonth;
    }

    public void setViewedMonth(long viewedMonth) {
        this.viewedMonth = viewedMonth;
    }

    public long getViewedYear() {
        return viewedYear;
    }

    public void setViewedYear(long viewedYear) {
        this.viewedYear = viewedYear;
    }

    public long getViewedAll() {
        return viewedAll;
    }

    public void setViewedAll(long viewedAll) {
        this.viewedAll = viewedAll;
    }

    public int getLikeStatus() {
        return likeStatus;
    }

    public void setLikeStatus(int likeStatus) {
        this.likeStatus = likeStatus;
    }
}
