package com.cv.media.lib.pct;

import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;

import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.common_utils.utils.JsonUtil;
import com.cv.media.lib.common_utils.utils.storage.DirectoryUtils;
import com.pct.core.PctEngine;
import com.pct.core.PctStrategy;
import com.pct.core.log.Logger;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by zhangyaoa on 2023/6/21.
 */
public class PctInitializer {
    private static final String PCT_WORK_PATH;
    private static final String PCT_LIB_PATH;


    static {
        PCT_WORK_PATH = DirectoryUtils.getExternalDir("pct") + File.separator + "work";
        PCT_LIB_PATH = DirectoryUtils.getExternalDir("pct") + File.separator + "lib";
    }


    public static void init(String configAssetsName) {
        if (TextUtils.isEmpty(configAssetsName)) {
            return;
        }

        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("you cant init in main thread!");
        }

        String configAssets = JsonUtil.getJsonFromAssets(configAssetsName, ContextProvider.getContext());

        if (TextUtils.isEmpty(configAssets)) {
            return;
        }

        Log.d("pct config json : ", configAssets);
        PctConfig pctConfig = JsonUtil.parseJsonToBean(configAssets,PctConfig.class);

        HashMap<String, String> engineParams = new HashMap<>();
        engineParams.put("PCT_REQ_NAV_URL", pctConfig.getCustom_app_pct_nav_url());
        engineParams.put("HARDWARE_TYPE", pctConfig.getCustom_app_pct_hard_type());

        PctStrategy strategy = new PctStrategy()
                .workPath(PCT_WORK_PATH)
                .appKey(pctConfig.getCustom_app_pct_key())
                .releaseId(pctConfig.getCustom_app_pct_release_id())
                .pctUrlMap(pctConfig.getCustom_app_pct_sid_servers())
                .navigatorDomains(pctConfig.getCustom_app_pct_navigators())
                .engineParams(engineParams)
                .libPath(PCT_LIB_PATH)
                .connectWaitTime(TimeUnit.SECONDS.toMillis(30))
                .failedAffectTime(TimeUnit.SECONDS.toMillis(60))
                .callTimeout(TimeUnit.SECONDS.toMillis(60))
                .readTimeout(TimeUnit.SECONDS.toMillis(30))
                .logLevel(Logger.DEBUG)
                .statisticPostInterval(TimeUnit.MINUTES.toMillis(5))
                .saveTaskMetric(true)
                .callback(new PctEngine.ICallback() {
                    @Override
                    public String[] resolveDNS(String s) {
                        return new String[0];
                    }

                    @Override
                    public void onMetric(String s, Map<String, Object> map) {

                    }

                    @Override
                    public int onEvent(int i, long l, long l1, String s) {
                        return 0;
                    }

                    @Override
                    public long onGetTrueTime() {
                        return 0;
                    }
                });
        PctEngine.init(strategy);
    }
}
