package com.cv.media.c.dao.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

import com.cv.media.lib.common_utils.obfuscation.KeepClassMember;
import com.valor.mfc.vms.api.AbstractPrintable;

/**
 * Created by Joyce.wang on 2024/1/3.
 */
@Entity(tableName = "OrderDo")
public class OrderDo extends AbstractPrintable implements KeepClassMember {

    private String uid;
    private long accountId;

    private long subAccountId;
    private long planId;//套餐id
    private String planName;//套餐名称
    @PrimaryKey
    @NonNull
    private long orderId;//订单id
    private String paymentStatus;//支付状态
    private String providerId;//支付机构
    private String paymentMethod;//支付方式
    private int renewable;//是否可续订
    private String transactionId;//交易id
    private String productId;//Google Play 应用内产品ID (INAPP)，非续订使用
    private String renewalProductId;//Google Play 订阅产品ID (SUBS)，续订使用
    private String googleOrderId;//google 订单id
    private String googlePurchaseToken;//google 购买token
    private int googlePurchaseStatus;//0:UNSPECIFIED_STATE(未知), 1:PURCHASED（已购买）, 2:PENDING（待办）
    private String packageName;
    private long updateTime;//更新时间

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public long getAccountId() {
        return accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public long getSubAccountId() {
        return subAccountId;
    }

    public void setSubAccountId(long subAccountId) {
        this.subAccountId = subAccountId;
    }

    public long getPlanId() {
        return planId;
    }

    public void setPlanId(long planId) {
        this.planId = planId;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public long getOrderId() {
        return orderId;
    }

    public void setOrderId(long orderId) {
        this.orderId = orderId;
    }

    public String getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public int getRenewable() {
        return renewable;
    }

    public void setRenewable(int renewable) {
        this.renewable = renewable;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getRenewalProductId() {
        return renewalProductId;
    }

    public void setRenewalProductId(String renewalProductId) {
        this.renewalProductId = renewalProductId;
    }

    public String getGoogleOrderId() {
        return googleOrderId;
    }

    public void setGoogleOrderId(String googleOrderId) {
        this.googleOrderId = googleOrderId;
    }

    public String getGooglePurchaseToken() {
        return googlePurchaseToken;
    }

    public void setGooglePurchaseToken(String googlePurchaseToken) {
        this.googlePurchaseToken = googlePurchaseToken;
    }

    public int getGooglePurchaseStatus() {
        return googlePurchaseStatus;
    }

    public void setGooglePurchaseStatus(int googlePurchaseStatus) {
        this.googlePurchaseStatus = googlePurchaseStatus;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }
}
