package com.cv.media.c.dao.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

import com.cv.media.c.server.model.CustomListItemDo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 用户自定义列表数据
 * <p>
 * 用户自定义列表名称由用户定义
 * 由于room无法动态创建表名，目前将所有的数据放在一起
 * <p>
 * listId + metaId当做主键进行查询数据
 */
@Entity
public class CustomListAlbum implements Serializable {

    /**
     * listId + metaId做主键
     */
    @PrimaryKey
    @NonNull
    private String id;

    private long accountId;

    private long subAccountId;

    private long listId;

    private String listName;

    private String title; //影片标题

    private long metaId;

    /**
     * 视频类型，MOVIE/SERIES
     * 主要用于后台定位问题用，可空
     */
    private String videoType;

    private String poster;

    private String backdrop;

    private int linked;

    private double rating;

    private long lastModifyTime;

    private int status = 1; //0下线，1正常

    private String releaseDate;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getAccountId() {
        return accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public long getSubAccountId() {
        return subAccountId;
    }

    public void setSubAccountId(long subAccountId) {
        this.subAccountId = subAccountId;
    }

    public long getListId() {
        return listId;
    }

    public void setListId(long listId) {
        this.listId = listId;
    }

    public String getListName() {
        return listName;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public long getMetaId() {
        return metaId;
    }

    public void setMetaId(long metaId) {
        this.metaId = metaId;
    }

    public String getVideoType() {
        return videoType;
    }

    public void setVideoType(String videoType) {
        this.videoType = videoType;
    }

    public String getPoster() {
        return poster;
    }

    public void setPoster(String poster) {
        this.poster = poster;
    }

    public String getBackdrop() {
        return backdrop;
    }

    public void setBackdrop(String backdrop) {
        this.backdrop = backdrop;
    }

    public int getLinked() {
        return linked;
    }

    public void setLinked(int linked) {
        this.linked = linked;
    }

    public double getRating() {
        return rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public long getLastModifyTime() {
        return lastModifyTime;
    }

    public void setLastModifyTime(long lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isOffline() {
        return status == 0;
    }

    public static String buildId(long listId, long metaId) {
        return listId + "_" + metaId;
    }

    public String getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public static List<CustomListAlbum> convertCustomListItemDo(List<CustomListItemDo> customListItemDoList, long accountId, long subAccountId) {
        if (customListItemDoList == null || customListItemDoList.isEmpty()) {
            return new ArrayList<>();
        }

        List<CustomListAlbum> result = new ArrayList<>();
        for (CustomListItemDo item : customListItemDoList) {
            CustomListAlbum album = new CustomListAlbum();
            album.setId(CustomListAlbum.buildId(item.getCustomListId(), item.getMetaId())); //item.getCustomListId() + "_" + item.getMetaId()
            album.setAccountId(accountId);
            album.setSubAccountId(subAccountId);
            album.setListId(item.getCustomListId());
//                    album.setListName(item.);
            album.setTitle(item.getTitle());
            album.setMetaId(item.getMetaId());
            album.setVideoType(item.getVideoType());
            album.setPoster(item.getPoster());
            album.setBackdrop(item.getBackdrop());
            album.setLinked(item.getLinked());
            album.setRating(item.getRating());
            album.setLastModifyTime(item.getLastModifyTime());
            album.setReleaseDate(item.getReleaseDate());
            result.add(album);
        }

        return result;
    }

    public static List<CustomListItemDo> convertCustomListAlbum(List<CustomListAlbum> customListAlbumList) {
        List<CustomListItemDo> result = new ArrayList<>();
        for (CustomListAlbum album : customListAlbumList) {
            CustomListItemDo itemDo = new CustomListItemDo();
            itemDo.setCustomListId(album.getListId());
            itemDo.setTitle(album.getTitle());
            itemDo.setMetaId(album.getMetaId());
            itemDo.setVideoType(album.getVideoType());
            itemDo.setPoster(album.getPoster());
            itemDo.setBackdrop(album.getBackdrop());
            itemDo.setLinked(album.getLinked());
            itemDo.setRating(album.getRating());
            itemDo.setLastModifyTime(album.getLastModifyTime());
            itemDo.setReleaseDate(album.getReleaseDate());
            result.add(itemDo);
        }

        return result;
    }
}
