package com.cv.media.c.dao.dao;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.cv.media.c.dao.model.CustomListAlbum;
import com.cv.media.c.dao.model.CustomListInfo;

import java.util.List;

@Dao
public abstract class CustomListAlbumDao {
    /**
     * 监听当前账户（子账户）中数据的变动
     */
    @Query("SELECT * FROM CustomListAlbum WHERE subAccountId == :subAccountId AND listId == :listId ORDER BY lastModifyTime DESC")
    public abstract LiveData<List<CustomListAlbum>> observeCustomListAlbum(long subAccountId, long listId);

    @Query("SELECT * FROM CustomListInfo WHERE subAccountId == :subAccountId ORDER BY lastModifyTime DESC")
    public abstract LiveData<List<CustomListInfo>> observeCustomInfoList(long subAccountId);

    @Query("SELECT * FROM CustomListInfo WHERE subAccountId == :subAccountId ORDER BY lastModifyTime DESC")
    public abstract List<CustomListInfo> fetchAllCustomListIds(long subAccountId);

    @Query(("DELETE FROM CustomListInfo WHERE subAccountId == :subAccountId"))
    public abstract void clearCustomListInfo(long subAccountId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertCustomListInfo(CustomListInfo... customListInfos);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertCustomListInfoList(List<CustomListInfo> customListInfoList);

    @Query("SELECT MAX(lastModifyTime) FROM CustomListInfo")
    public abstract int queryCustomListMaxSyncOrder();

    @Query("DELETE FROM CustomListInfo WHERE id in (:ids)")
    public abstract void deleteCustomLists(List<Long> ids);

    @Query("UPDATE CustomListInfo SET listName = :listName, lastModifyTime=:lastModifyTime WHERE subAccountId == :subAccountId AND id== :listId ")
    public abstract void updateCustomListName(long subAccountId, long listId, String listName, long lastModifyTime);

    @Query("UPDATE CustomListInfo SET lastModifyTime=:lastModifyTime WHERE subAccountId == :subAccountId AND id== :listId ")
    public abstract void updateCustomInfo(long subAccountId, long listId, long lastModifyTime);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertCustomListAlbums(CustomListAlbum... customListAlbums);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertCustomListAlbumList(List<CustomListAlbum> customListAlbums);

    @Query("SELECT * FROM CustomListAlbum WHERE subAccountId == :subAccountId AND listId == :listId ORDER BY lastModifyTime DESC LIMIT :size")
    public abstract List<CustomListAlbum> loadCustomListAlbumBySize(long subAccountId, long listId, int size);

    @Query("SELECT * FROM CustomListAlbum WHERE subAccountId == :subAccountId AND listId in (:ids) ORDER BY lastModifyTime")
    public abstract List<CustomListAlbum> batchLoadCustomListAlbum(long subAccountId, List<Long> ids);

    @Query("SELECT * FROM CustomListAlbum WHERE subAccountId == :subAccountId ORDER BY lastModifyTime")
    public abstract List<CustomListAlbum> fetchAllCustomLists(long subAccountId);

    @Delete
    public abstract void delete(CustomListAlbum... customListAlbums);

    /**
     * 删除某个自定义列表所有数据
     *
     * @param subAccountId subAccountId
     * @param listId       自定义列表id
     */
    @Query("DELETE FROM CustomListAlbum WHERE subAccountId == :subAccountId AND listId == :listId")
    public abstract void deleteAllByListId(long subAccountId, long listId);

    @Query("DELETE FROM CustomListAlbum WHERE subAccountId == :subAccountId")
    public abstract void clearAll(long subAccountId);

    @Query("DELETE FROM CustomListAlbum WHERE subAccountId == :subAccountId AND id == :id")
    public abstract void deleteById(long subAccountId, String id);
}
