package com.cv.media.c.dao.model;

import androidx.room.Entity;
import androidx.room.PrimaryKey;

import com.cv.media.c.server.model.CustomListDo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 只存储用户自定义列表名称
 */
@Entity
public class CustomListInfo implements Serializable {
    @PrimaryKey
    private long id; //服务器id唯一，可以作为主键

    private String listName;

    private String iconId;

    private long subAccountId;

    /**
     * 每次更新服务器返回数据有此字段就同步
     * 缓存更新时，手动更新此字段，保证缓存的排序也是根据最后一次改动刷新
     */
    private long lastModifyTime;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getListName() {
        return listName;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    public String getIconId() {
        return iconId;
    }

    public void setIconId(String iconId) {
        this.iconId = iconId;
    }

    public long getSubAccountId() {
        return subAccountId;
    }

    public void setSubAccountId(long subAccountId) {
        this.subAccountId = subAccountId;
    }

    public long getLastModifyTime() {
        return lastModifyTime;
    }

    public void setLastModifyTime(long lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public static List<CustomListInfo> convertCustomListDo(List<CustomListDo> customListDoList, long subAccountId) {
        List<CustomListInfo> result = new ArrayList<>();
        int size = customListDoList.size();
        for (int i = 0; i < size; i++) {
            CustomListDo item = customListDoList.get(i);
            CustomListInfo info = new CustomListInfo();
            info.setId(item.getId());
            info.setListName(item.getListName());
            info.setIconId(item.getIconId());
            info.setSubAccountId(subAccountId);
            info.setLastModifyTime(item.getLastModifyTime());
            result.add(info);
        }
        return result;
    }
}
