package com.cv.media.c.dao.download;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.cv.media.c.dao.model.DownloadInfo;

import java.util.List;

@Dao
public abstract class DownloadDao {
    @Query("SELECT * FROM DownloadInfo WHERE id is not null ORDER BY createDate ASC")
    public abstract List<DownloadInfo> getAllDownloadInfos();

    @Query("DELETE FROM DownloadInfo WHERE id == :id")
    public abstract void removeDownloadInfo(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void addDownloadInfo(DownloadInfo videoTorrentInfo);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    public abstract void updateDownloadInfo(DownloadInfo videoTorrentInfo);

    @Query("SELECT * FROM DownloadInfo WHERE id == :id")
    public abstract DownloadInfo getDownloadInfo(String id);

    @Query("SELECT * FROM DownloadInfo WHERE channelHash == :channelHash")
    public abstract DownloadInfo getDownloadInfoByChanHash(String channelHash);

    @Query("SELECT * FROM DownloadInfo WHERE ttid == :ttid")
    public abstract List<DownloadInfo> getDownloadInfoByTTid(String ttid);

    @Query("UPDATE DownloadInfo SET status = :downloadStatus,message = :message,failedDate = :failedDate,failedCount = :failedCount,updateDate = :updateDate WHERE id == :downloadInfoId")
    public abstract void updateDownloadStatus(String downloadInfoId, String downloadStatus, String message, long failedDate, int failedCount, long updateDate);

    @Query("UPDATE DownloadInfo SET downloadSpeed = :downloadSpeed,bytesReceived = :bytesReceived,downloadETA = :downloadETA,downloadProgress = :downloadProgress,updateDate = :updateDate WHERE id == :downloadInfoId")
    public abstract void updateCacheProgress(String downloadInfoId, long downloadSpeed, long bytesReceived, long downloadETA, int downloadProgress, long updateDate);

    @Query("UPDATE DownloadInfo SET downloadSpeed = :downloadSpeed,downloadProgress = :downloadProgress,updateDate = :updateDate WHERE id == :downloadInfoId")
    public abstract void updateCacheProgressFromCDN(String downloadInfoId, long downloadSpeed, int downloadProgress, long updateDate);

    @Query("UPDATE DownloadInfo SET bytesReceived = :bytesReceived,downloadProgress = :downloadProgress,updateDate = :updateDate WHERE id == :downloadInfoId")
    public abstract void updateCacheData(String downloadInfoId, long bytesReceived, int downloadProgress, long updateDate);

    @Query("UPDATE DownloadInfo SET channelHash = :channelHash,updateDate = :updateDate WHERE id == :downloadInfoId")
    public abstract void updateChannelHash(String downloadInfoId, String channelHash, long updateDate);

    @Query("UPDATE DownloadInfo SET decodeKey = :decodeKey,updateDate = :updateDate WHERE id == :downloadInfoId")
    public abstract void updateDecodeKey(String downloadInfoId, String decodeKey, long updateDate);

    @Query("UPDATE DownloadInfo SET mediaPlayType = :mediaPlayType,updateDate = :updateDate WHERE id == :downloadInfoId")
    public abstract void updateMediaPlayType(String downloadInfoId, String mediaPlayType, long updateDate);

    @Query("SELECT * FROM DownloadInfo WHERE albumId == :albumVideoId")
    public abstract List<DownloadInfo> getUserCacheDownloadInfoByAlbum(long albumVideoId);

    @Query("SELECT * FROM DownloadInfo WHERE albumId == :albumVideoId AND season == :season AND episode == :episode")
    public abstract List<DownloadInfo> getUserCacheDownloadInfoByAlbum(long albumVideoId, int season, int episode);

    @Query("SELECT * FROM DownloadInfo WHERE albumId == :albumVideoId AND season == :season")
    public abstract List<DownloadInfo> getUserCacheDownloadInfoByAlbumSeason(long albumVideoId, int season);

    @Query("SELECT * FROM DownloadInfo WHERE ttid == :ttid AND season == :season AND episode == :episode")
    public abstract DownloadInfo getDownloadInfoByTtidEpisode(String ttid, int season, int episode);

    @Query("SELECT COUNT(*) FROM DownloadInfo")
    public abstract int countInCaches();

    @Query("SELECT COUNT(*) FROM DownloadInfo WHERE albumId == :albumVideoId AND season == :season")
    public abstract int countInCaches(long albumVideoId, int season);

    @Query("SELECT COUNT(*) FROM DownloadInfo WHERE albumId == :albumVideoId AND season == :season AND (status IN ('FINISHED','FINISHED_INCONSISTENT'))")
    public abstract int countCached(long albumVideoId, int season);

    @Query("SELECT COUNT(*) FROM DownloadInfo WHERE albumId == :albumVideoId AND season == :season AND (status NOT IN ('FINISHED','FINISHED_INCONSISTENT'))")
    public abstract int countInCaching(long albumVideoId, int season);

    @Query("SELECT * FROM DownloadInfo WHERE site == :site AND acct == :account")
    public abstract List<DownloadInfo> getAccountDownloadInfos(String site, String account);

    @Query("DELETE FROM DownloadInfo WHERE site == :site AND acct == :account")
    public abstract void deleteAccountDownloadInfo(String site, String account);
}
