package com.cv.media.c.dao.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.cv.media.c.dao.model.OrderDo;

import java.util.List;

/**
 * Created by Joyce.wang on 2024/1/3.
 */
@Dao
public abstract class OrderDao {
    @Query("SELECT * FROM OrderDo WHERE uid == :uid ORDER BY updateTime DESC")
    public abstract List<OrderDo> getAllOrderDo(String uid);
    @Query("SELECT * FROM OrderDo WHERE uid == :uid AND orderId == :orderId ORDER BY updateTime DESC")
    public abstract OrderDo getOrderDo(String uid, long orderId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertOrderDo(OrderDo orderDo);

    @Query("DELETE FROM OrderDo WHERE uid == :uid AND orderId == :orderId")
    public abstract void deleteOrderDo(String uid, long orderId);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    public abstract void updateOrderDo(OrderDo orderDo);

    @Query("UPDATE OrderDo SET packageName = :packageName, googleOrderId = :googleOrderId, googlePurchaseStatus = :googlePurchaseStatus, googlePurchaseToken = :googlePurchaseToken, paymentStatus = :paymentStatus, updateTime = :updateTime WHERE uid == :uid AND orderId== :orderId ")
    public abstract void updateOrderDo(String uid, long orderId, String packageName, String googleOrderId, int googlePurchaseStatus,  String googlePurchaseToken, String paymentStatus, long updateTime);
}
