
package com.cv.media.c.server.model;

public enum EVideoType {
    /**
     * UNKNOWN, 0
     */
    UNKNOWN,

    /**
     * PLAYLIST 类型 1
     */
    PLAYLIST,

    /**
     * 搜索列表 2
     */
    SEARCH_LIST,

    /**
     * This is a movie 3
     */
    MOVIE,

    /**
     * This is a TV Series 4
     */
    SERIES,

    /**
     * This is a season of a TV series 5
     */
    SEASON,

    /**
     * This is an episode of a TV season 6
     */
    EPISODE,

    /**
     * 记录片 7
     */
    DOCUMENTARY,

    /**
     * 短片 8
     */
    SHORT,

    /**
     * 视频 9
     */
    VIDEO,

    /**
     * TV 特别节目 10
     */
    TV_SPECIAL,

    /**
     * 人物 11
     */
    PERSON,

    /**
     * 成人 12
     */
    ADULT,

    /**
     * 配置
     */
    CONFIG,

    /**
     * 自定义列表
     */
    CUSTOM_LIST,

    /**
     * 结束标识
     */
    VIDOE_TYPE_END;

    private EVideoType() {
    }

    public static EVideoType valueOf(int videoTypeInt) {
        switch (videoTypeInt) {
            case 1:
                return PLAYLIST;
            case 2:
                return SEARCH_LIST;
            case 3:
                return MOVIE;
            case 4:
                return SERIES;
            case 5:
                return SEASON;
            case 6:
                return EPISODE;
            case 7:
                return DOCUMENTARY;
            case 8:
                return SHORT;
            case 9:
                return VIDEO;
            case 10:
                return TV_SPECIAL;
            case 11:
                return PERSON;
            case 12:
                return ADULT;
            case 13:
                return CONFIG;
            case 14:
                return CUSTOM_LIST;
            default:
                return UNKNOWN;
        }
    }
}
