package com.cv.media.c.server;

public class ReportManager {
    private volatile static ReportManager instance;

    private ReportManager() {
    }

    public static ReportManager getInstance() {
        if (instance == null) {
            synchronized (ReportManager.class) {
                if (instance == null) {
                    instance = new ReportManager();
                }
            }
        }
        return instance;
    }

    public void handleReport(String api_name, String api_code, String api_http_code, String api_content, String api_host, String api_request) {
        if (null != callback) {
            callback.dataReport(api_name, api_code, api_http_code, api_content, api_host, api_request);
        }
    }

    public interface ICallback {
        void dataReport(String api_name, String api_code, String api_http_code, String api_content, String api_host, String api_request);
    }

    private ICallback callback;

    public void setCallback(ICallback cb) {
        this.callback = cb;
    }
}
