package com.cv.media.c.server.response;

import android.text.TextUtils;

public class ResponseStatus extends AbstractPrintable {
    private static final String SUCCESS_CODE = "00000";

    /**
     * 请求返回码
     */
    protected String code = "";

    /**
     * 请求返回信息
     */
    protected String msg;

    protected String riskUrl;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        //针对风控情况不弹toast，目前toast在各个页面不好处理，这里对message做一个置空处理
        if(!TextUtils.isEmpty(riskUrl)){
            return "";
        }
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isSuccess() {
        return SUCCESS_CODE.equals(code);
    }

    public String getRiskUrl() {
        return riskUrl;
    }

    public void setRiskUrl(String riskUrl) {
        this.riskUrl = riskUrl;
    }
}
