package com.cv.media.c.server.exception;

import android.content.Context;

import com.cv.media.c.server.R;
import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.google.gson.JsonParseException;

import org.json.JSONException;

import java.net.BindException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.ParseException;

/**
 * 常见错误 映射 字符串
 * 不一定所有项目都是同一个提示, 故不能放进Lib
 * @Author Damon
 */
public class ExceptionTranslator {
    public static String getErrorMessage(Throwable error) {
        return ExceptionTranslator.getErrorMessage(error, ContextProvider.getContext());
    }

    public static String getErrorMessage(Throwable error, Context context) {
        if (context == null) context = ContextProvider.getContext();
        if (error == null) return context.getString(R.string.toast_connect_unknown_host);
        while (error.getCause() != null) error = error.getCause();
        if (error instanceof ServerException) {
            ServerException serverError = (ServerException) error;
            return serverError.getResponseStatus().getCode() +
                    ((ServerException) error).getResponseStatus().getMsg();
        }
        if (error instanceof SocketTimeoutException || (error.getCause() != null && error.getCause() instanceof SocketTimeoutException)) {
            return context.getString(R.string.toast_connect_timeout) + ": " + error.getMessage();
        } else if (error instanceof UnknownHostException || (error.getCause() != null && error.getCause() instanceof UnknownHostException)) {
            return context.getString(R.string.toast_connect_unknown_host) + ": " + error.getMessage();
        } else if (error instanceof ConnectException || (error.getCause() != null && error.getCause() instanceof ConnectException)) {
            return context.getString(R.string.toast_connect_error) + ": " + error.getMessage();
        } else if (error instanceof BindException || (error.getCause() != null && error.getCause() instanceof ConnectException)) {
            return context.getString(R.string.toast_connect_error) + ": " + error.getMessage();
        } else if (error instanceof JsonParseException
                || error instanceof JSONException
                || error instanceof ParseException) {
            return context.getString(R.string.toast_system_error) + ": " + error.getMessage();
        }
        return error.getMessage();
    }

    public static String getServerErrorMessage(Throwable error){
        if (error == null){
            return "";
        }

        if (error instanceof ServerException) {
            return ((ServerException) error).getResponseStatus().getMsg();
        }

        return "";
    }

    public static String getServerErrorCode(Throwable error){
        if(error == null){
            return "";
        }

        if(error instanceof ServerException){
            ServerException serverError = (ServerException) error;
            return serverError.getResponseStatus().getCode();
        }

        return "";
    }
}
