package com.cv.media.c.server.model;

import com.cv.media.lib.common_utils.obfuscation.KeepClassMember;

import java.io.Serializable;

/**
 * Created by zhangyaoa on 2022/1/6.
 */
public class ProfileInfo implements KeepClassMember, Serializable {

    /**
     * 集
     */
    private Integer episodeNo;

    /**
     * 季
     */
    private Integer seasonNo;

    /**
     * 已播放时长，单位：ms
     */
    private Integer collectionTime;

    /**
     * 个人评分
     */
    private Double myRating = 0.0D;

    /**
     * 是否被收藏
     */
    private Boolean hasFavored = false;

    /**
     * 是否加入watchList
     */
    private Boolean hasWatchlisted = false;

    /**
     * 是否加入history
     */
    private Boolean hasHistoryed = false;

    public Integer getEpisodeNo() {
        return episodeNo;
    }

    public void setEpisodeNo(Integer episodeNo) {
        this.episodeNo = episodeNo;
    }

    public Integer getSeasonNo() {
        return seasonNo;
    }

    public void setSeasonNo(Integer seasonNo) {
        this.seasonNo = seasonNo;
    }

    public Integer getCollectionTime() {
        return collectionTime;
    }

    public void setCollectionTime(Integer collectionTime) {
        this.collectionTime = collectionTime;
    }

    public Double getMyRating() {
        return myRating;
    }

    public void setMyRating(Double myRating) {
        this.myRating = myRating;
    }

    public Boolean getHasFavored() {
        return hasFavored;
    }

    public void setHasFavored(Boolean hasFavored) {
        this.hasFavored = hasFavored;
    }

    public Boolean getHasWatchlisted() {
        return hasWatchlisted;
    }

    public void setHasWatchlisted(Boolean hasWatchlisted) {
        this.hasWatchlisted = hasWatchlisted;
    }

    public Boolean getHasHistoryed() {
        return hasHistoryed;
    }

    public void setHasHistoryed(Boolean hasHistoryed) {
        this.hasHistoryed = hasHistoryed;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("\n{");
        sb.append("\n").append("\"episodeNo\":")
                .append(episodeNo).append("\n");
        sb.append(",\"seasonNo\":")
                .append(seasonNo).append("\n");
        sb.append(",\"collectionTime\":")
                .append(collectionTime).append("\n");
        sb.append(",\"myRating\":")
                .append(myRating).append("\n");
        sb.append(",\"hasFavored\":")
                .append(hasFavored).append("\n");
        sb.append(",\"hasWatchlisted\":")
                .append(hasWatchlisted).append("\n");
        sb.append(",\"hasHistoryed\":")
                .append(hasHistoryed).append("\n");
        sb.append('}');
        return sb.toString();
    }
}
