package com.cv.media.c.server;

import android.text.TextUtils;

import com.cv.media.c.server.model.CommonDeviceInfo;
import com.cv.media.lib.api.SdkAdaptList;
import com.cv.media.lib.api.SdkAdaptObj;
import com.cv.media.lib.api.okhttp.BaseCryptoInterceptor;
import com.cv.media.lib.common_utils.crypto.SecurityUtil;
import com.cv.media.lib.common_utils.utils.GZipUtils;
import com.cv.media.lib.common_utils.utils.JsonUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

/**
 * 请求 加密解密 步骤
 *
 * @Author Damon
 */
public class ServerCryptoInterceptor extends BaseCryptoInterceptor {
    private Gson gson;
    private java.lang.reflect.Type type;

    protected static final String KEY_CRYPT_VERSION = "5";

    protected static final String KEY_CRYPT_ZIP_VERSION = "6";

    public ServerCryptoInterceptor() {
        gson = new GsonBuilder().serializeNulls()
                .setDateFormat("yyyy-MM-dd HH:mm:ss").create();
        type = new TypeToken<Map<String, String>>() {
        }.getType();
    }

    @Override
    public boolean isEncryptedCode(Response response) {
        return true;
    }

    protected boolean onEncrypt(Request request) {
        return !TextUtils.equals(request.method(), "POST") && isCipherRequest(request);
    }

    protected String cryptVersion(){
        //vod服务用version 6  其他服务用version 5
        return KEY_CRYPT_ZIP_VERSION;
    }

    protected final Request getCipherRequest(Request request) {
        HttpUrl httpUrl = request.url();
        Map<String, String> params = new HashMap<>(20);
        for (int i = 0; i < httpUrl.querySize(); i++) {
            params.put(httpUrl.queryParameterName(i), httpUrl.queryParameterValue(i));
        }

        Map<String, Object> newMap = adaptSdkParams(params, httpUrl);
        if (params.containsKey("deviceInfo")) {
            String deviceJson = params.get("deviceInfo");
            CommonDeviceInfo deviceParams = JsonUtil.parseJsonToBean(deviceJson, CommonDeviceInfo.class);
//            newMap.putAll(params);
            newMap.put("deviceInfo", deviceParams);
        } else {
//            newMap.putAll(params);
        }
        newMap.putAll(changeParams(params));

        String reqM;
        String reqS;
        try {
            if(KEY_CRYPT_ZIP_VERSION.equals(cryptVersion())){
                reqM = SecurityUtil.getInstance().encryptString(GZipUtils.compressWithBase64(gson.toJson(newMap)));
            }else {
                reqM = SecurityUtil.getInstance().encryptString(gson.toJson(newMap));
            }
            reqS = SecurityUtil.getInstance().sign(reqM);
        } catch (Exception e) {
            reqM = "";
            reqS = "";
        }

        String newUrl = new StringBuilder().append(httpUrl.scheme()).append("://").append(httpUrl.host()).append(":").append(httpUrl.port()).append(httpUrl.encodedPath()).toString();
        Request newRequest;
        RequestBody requestBody = new FormBody.Builder()
                .add("v", cryptVersion())
                .add("m", reqM)
                .add("s", reqS)
                .build();
        newRequest = request.newBuilder().url(newUrl).post(requestBody).build();


//        Map<String, Object> newMap = new HashMap<>();
//        if (params.containsKey("deviceInfo")) {
//            String devicejson = params.get("deviceInfo");
//            params.remove("deviceInfo");
//            DeviceInfo devicepParams = JsonUtil.parseJsonToBean(devicejson, DeviceInfo.class);
//            newMap.putAll(params);
//            newMap.put("deviceInfo", devicepParams);
//        }
//        String reqJson = gson.toJson(newMap);
//        RequestBody requestBody = FormBody.create(MediaType.parse("application/json; charset=utf-8")
//                , reqJson);
//        String newUrl = new StringBuilder().append(httpUrl.scheme()).append("://").append(httpUrl.host()).append(":").append(httpUrl.port()).append(httpUrl.encodedPath()).toString();
//        Request newRequest = request.newBuilder().url(newUrl).post(requestBody).build();

        return newRequest;
    }

    /**
     * 临时用于把原来params中是结构体（map、list、数据bean等）的转为具体的数据模型，放到obj的map中
     *
     * @param params 原始请求key-value的map
     * @return 返回一个新的只包含转化数据模型的map
     */
    protected Map<String, Object> changeParams(Map<String, String> params) {
        return new HashMap<>();
    }

    private Map<String, Object> adaptSdkParams(Map<String, String> params, HttpUrl httpUrl) {

        Map<String, Object> newParams = new HashMap<>();
        newParams.putAll(params);

        if (isSdkUrl(httpUrl)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (!TextUtils.isEmpty(entry.getValue()) && entry.getValue().startsWith("SdkAdapt:")) {
                    try {
                        SdkAdaptObj sdkAdaptObj = JsonUtil.parseJsonToBean(entry.getValue().replace("SdkAdapt:", ""), SdkAdaptObj.class);

                        String dataSingle = JsonUtil.getFieldValue(sdkAdaptObj.value, "sdkAdaptSingle");
                        if (!TextUtils.isEmpty(dataSingle)) {
                            newParams.put(entry.getKey(), JsonUtil.parseJsonToBean(dataSingle, Class.forName(sdkAdaptObj.type)));
                        } else {
                            newParams.put(entry.getKey(), JsonUtil.parseJsonToBean(sdkAdaptObj.value, SdkAdaptList.class).sdkAdaptList);
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        return newParams;
    }

    private boolean isSdkUrl(HttpUrl httpUrl) {
        try {
            return httpUrl.toString().contains("/sdk/");
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    protected final Response getDecryptResponse(Response response) {
        try {
            if (!isCipherResponse(response.request())) {
                return response;
            }
            ResponseBody responseBody = response.body();
            //响应状态码 200~300 || 555  ----> 对响应体解密
            String resStr = responseBody.string();
            try {
                Map<String, String> resData = gson.fromJson(resStr, type);
                String resM;
                if (!TextUtils.equals(resData.get("v"), "0")) { // 响应加密
                    if (KEY_CRYPT_ZIP_VERSION.equals(resData.get("v"))) {
                        resM = GZipUtils.decompressWithBase64(SecurityUtil.getInstance().decryptString(resData.get("m")));
                    } else {
                        resM = SecurityUtil.getInstance().decryptString(resData.get("m"));
                    }
                } else { // 响应未加密
                    resM = resData.get("m"); // 响应未加密
                }
                ResponseBody newResponseBody = ResponseBody.create(responseBody.contentType(), resM);
                return response.newBuilder().body(newResponseBody).build();
            } catch (Exception e) {
                //返回明文，或者抓包工具解密处理后
                ResponseBody newResponseBody = ResponseBody.create(responseBody.contentType(), resStr);
                return response.newBuilder().body(newResponseBody).build();
            }

        } catch (Exception e) {
            e.printStackTrace();
            return response;
        }
    }

    //对于字幕的下载，需要走解密流程，会对字幕再次进行utf-8编码导致字幕有乱码
    private boolean isCipherResponse(Request request) {
        String requestPath = request.url().encodedPath();
        return !StringUtils.contains(requestPath, "/api/st/get/v2");
    }

    private boolean isCipherRequest(Request request) {
        String requestPath = request.url().encodedPath();
        return !(StringUtils.contains(requestPath, "/api/st/adjust/v1") ||
                StringUtils.contains(requestPath, "/api/st/afferent/v1"));
    }
}
