package com.cv.media.c.server;

import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;

import com.cv.media.c.server.exception.ServerException;
import com.cv.media.c.server.response.HttpResponseStatus;
import com.cv.media.c.server.response.ResponseStatus;
import com.cv.media.lib.common_utils.crypto.SecurityUtil;
import com.cv.media.lib.common_utils.utils.GZipUtils;
import com.google.gson.Gson;

import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.net.URLDecoder;

import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ServerExceptionInterceptor implements Interceptor {

    private static final String KEY_CRYPT_ZIP_VERSION = "6";

    @NonNull
    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        ResponseStatus responseStatus = null;

        if (isGetSubtitlesRequest(response.request())) {//"/api/st/get/v2"
            Log.d("ServerException", "\n\n\n------>isGetSubtitlesRequest()");
            try {
                if (isSdkUrl(response.request().url())) {
                    String resBodyStr = response.body().string();
                    responseStatus = new Gson().fromJson(resBodyStr, ResponseStatus.class);
                    if (responseStatus != null && !responseStatus.isSuccess()) {
                        trackingVodApiRequestError(response.request().url().encodedPath(), responseStatus.getCode(), String.valueOf(response.code()), resBodyStr, response.request().url().host(), null != response.request().body() ? decryptString(((FormBody) response.request().body()).encodedValue(0), ((FormBody) response.request().body()).encodedValue(1)) : StringUtils.substringAfter(response.request().url().toString(), response.request().url().encodedPath()));
                    }
                }
            } catch (Throwable e) {
                e.printStackTrace();
            }

            if (responseStatus != null && !responseStatus.isSuccess()) {
                SGSEManager.getInstance().handleResponse(responseStatus);
                throw new ServerException(response.code(), responseStatus);
            }
            return response;
        } else {
            String resBodyStr = "";

            ResponseBody responseBody = response.body();

            try {
                resBodyStr = responseBody.string();
                handleResponse(response, resBodyStr);
            } catch (Throwable e) {
                Log.d("ServerException", "------>e = ", e);
            }

            try {
                if (isSdkUrl(response.request().url())) {
                    responseStatus = new Gson().fromJson(resBodyStr, ResponseStatus.class);
                }
            } catch (Throwable e) {
                e.printStackTrace();
            }

            if (responseStatus != null && !responseStatus.isSuccess()) {
                SGSEManager.getInstance().handleResponse(responseStatus);
                throw new ServerException(response.code(), responseStatus);
            }

            ResponseBody newResponseBody = ResponseBody.create(responseBody.contentType(), resBodyStr);
            return response.newBuilder().body(newResponseBody).build();
        }
    }

    private boolean isSdkUrl(HttpUrl httpUrl) {
        try {
            return httpUrl.toString().contains("/sdk/");
        } catch (Exception e) {
            return false;
        }
    }

    private void handleResponse(Response response, String resBodyStr) {
        if (null == response) {
            return;
        }
        if (response.code() == 200 && isSdkUrl(response.request().url())) {
            Log.d("ServerException", "\n\n\n************************************200\n------>url = " + response.request().url());
            ResponseStatus status = new Gson().fromJson(resBodyStr, ResponseStatus.class);
            if (null != status && !TextUtils.isEmpty(status.getCode()) && !status.isSuccess()) {
                trackingVodApiRequestError(response.request().url().encodedPath(), status.getCode(), String.valueOf(response.code()), resBodyStr, response.request().url().host(), null != response.request().body() ? decryptString(((FormBody) response.request().body()).encodedValue(0), ((FormBody) response.request().body()).encodedValue(1)) : StringUtils.substringAfter(response.request().url().toString(), response.request().url().encodedPath()));
            }
        } else {
            if (200 != response.code()) {
                Log.d("ServerException", "\n\n\n************************************!200\n------>url = " + response.request().url());
                Log.d("ServerException", "------>resBodyStr = " + resBodyStr);
                String api_code = "";
                if (502 == response.code()) {
                    api_code = "";
                } else {
                    HttpResponseStatus httpsStatus = new Gson().fromJson(resBodyStr, HttpResponseStatus.class);
                    ResponseStatus status = new Gson().fromJson(resBodyStr, ResponseStatus.class);
                    if (null != status && isSdkUrl(response.request().url())) {
                        api_code = status.getCode();
                    } else if (null != httpsStatus && httpsStatus.getStatus() > 0) {
                        api_code = String.valueOf(httpsStatus.getStatus());
                    } else {
                        api_code = "";
                    }
                }
                trackingVodApiRequestError(response.request().url().encodedPath(), api_code, String.valueOf(response.code()), resBodyStr, response.request().url().host(), null != response.request().body() ? decryptString(((FormBody) response.request().body()).encodedValue(0), ((FormBody) response.request().body()).encodedValue(1)) : StringUtils.substringAfter(response.request().url().toString(), response.request().url().encodedPath()));
            }
        }
    }

    private String decryptString(String v, String resStr) {
        try {
            if (KEY_CRYPT_ZIP_VERSION.equals(v)) {
                return GZipUtils.decompressWithBase64(SecurityUtil.getInstance().decryptString(URLDecoder.decode(resStr, "UTF-8")));
            } else {
                return SecurityUtil.getInstance().decryptString(URLDecoder.decode(resStr, "UTF-8"));
            }
        } catch (Exception e) {
            return "";
        }
    }

    private void trackingVodApiRequestError(String api_name, String api_code, String api_http_code, String api_content, String api_host, String api_request) {
        ReportManager.getInstance().handleReport(api_name, api_code, api_http_code, api_content, api_host, api_request);
    }

    //对于字幕的下载，需要走解密流程，会对字幕再次进行utf-8编码导致字幕有乱码
    private boolean isGetSubtitlesRequest(Request request) {
        String requestPath = request.url().encodedPath();
        return StringUtils.contains(requestPath, "/api/st/get/v2");
    }
}
