package com.ott.trans.jni;

import com.ott.trans.utils.RSAUtil;
import com.ott.trans.utils.TorrentUtils;

public class N2JRsa {

    private static byte[] sPubKey;
    private static byte[] sPriKey;

    public static void setPubKey(byte[] key) {
        sPubKey = key;
    }

    public static void setPriKey(byte[] key) {
        sPriKey = key;
    }

    public static void setPubKey(String key) {
        sPubKey = TorrentUtils.hexStringToByteArray(key);
    }

    public static void setPriKey(String key) {
        sPriKey = TorrentUtils.hexStringToByteArray(key);
    }

    public static byte[] getPubKey() {
        return sPubKey;
    }

    public static byte[] getPriKey() {
        return sPriKey;
    }

    public static byte[] encryptByPubKey(byte[] data) {
        return RSAUtil.doByPublicKey(data, sPubKey, true);
    }

    public static byte[] decryptByPubKey(byte[] data) {
        return RSAUtil.doByPublicKey(data, sPubKey, false);
    }

    public static byte[] encryptByPriKey(byte[] data) {
        return RSAUtil.doByPrivateKey(data, sPriKey, true);
    }

    public static byte[] decryptByPriKey(byte[] data) {
        return RSAUtil.doByPrivateKey(data, sPriKey, false);
    }
}
