package software.amazon.awscdk.services.applicationautoscaling;

/**
 * The service that supports Application AutoScaling.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Code code;
 * Function handler = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.PYTHON_3_7)
 *         .handler("index.handler")
 *         .code(code)
 *         .reservedConcurrentExecutions(2)
 *         .build();
 * Version fnVer = handler.getCurrentVersion();
 * ScalableTarget target = ScalableTarget.Builder.create(this, "ScalableTarget")
 *         .serviceNamespace(ServiceNamespace.LAMBDA)
 *         .maxCapacity(100)
 *         .minCapacity(10)
 *         .resourceId(String.format("function:%s:%s", handler.getFunctionName(), fnVer.getVersion()))
 *         .scalableDimension("lambda:function:ProvisionedConcurrency")
 *         .build();
 * target.scaleToTrackMetric("PceTracking", BasicTargetTrackingScalingPolicyProps.builder()
 *         .targetValue(0.9)
 *         .predefinedMetric(PredefinedMetric.LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:01.850Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.ServiceNamespace")
public enum ServiceNamespace {
    /**
     * Elastic Container Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECS,
    /**
     * Elastic Map Reduce.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTIC_MAP_REDUCE,
    /**
     * Elastic Compute Cloud.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2,
    /**
     * App Stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPSTREAM,
    /**
     * Dynamo DB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DYNAMODB,
    /**
     * Relational Database Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RDS,
    /**
     * SageMaker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SAGEMAKER,
    /**
     * Custom Resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CUSTOM_RESOURCE,
    /**
     * Lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA,
    /**
     * Comprehend.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPREHEND,
    /**
     * Kafka.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KAFKA,
    /**
     * ElastiCache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTICACHE,
}
