package software.amazon.awscdk.services.cloudwatch;

/**
 * Enumeration indicates state of Alarm used in building Alarm Rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * Alarm errorAlarm;
 * dashboard.addWidgets(AlarmStatusWidget.Builder.create()
 *         .title("Errors")
 *         .alarms(List.of(errorAlarm))
 *         .sortBy(AlarmStatusWidgetSortBy.STATE_UPDATED_TIMESTAMP)
 *         .states(List.of(AlarmState.ALARM))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:01.361Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.AlarmState")
public enum AlarmState {
    /**
     * State indicates resource is in ALARM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALARM,
    /**
     * State indicates resource is not in ALARM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OK,
    /**
     * State indicates there is not enough data to determine is resource is in ALARM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INSUFFICIENT_DATA,
}
