package software.amazon.awscdk.core;

/**
 * Synthesizer that reuses bootstrap roles from a different region.
 * <p>
 * A special synthesizer that behaves similarly to <code>DefaultStackSynthesizer</code>,
 * but doesn't require bootstrapping the environment it operates in. Instead,
 * it will re-use the Roles that were created for a different region (which
 * is possible because IAM is a global service).
 * <p>
 * However, it will not assume asset buckets or repositories have been created,
 * and therefore does not support assets.
 * <p>
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets. App builders do not need to use this
 * synthesizer directly.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * BootstraplessSynthesizer bootstraplessSynthesizer = BootstraplessSynthesizer.Builder.create()
 *         .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *         .deployRoleArn("deployRoleArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:30:56.838Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.BootstraplessSynthesizer")
public class BootstraplessSynthesizer extends software.amazon.awscdk.core.DefaultStackSynthesizer {

    protected BootstraplessSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BootstraplessSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BootstraplessSynthesizer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.BootstraplessSynthesizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param _asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetSource _asset) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(_asset, "_asset is required") });
    }

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param _asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetSource _asset) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(_asset, "_asset is required") });
    }

    /**
     * Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.BootstraplessSynthesizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.BootstraplessSynthesizer> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.core.BootstraplessSynthesizerProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.core.BootstraplessSynthesizerProps.Builder();
        }

        /**
         * The CFN execution Role ARN to use.
         * <p>
         * Default: - No CloudFormation role (use CLI credentials)
         * <p>
         * @return {@code this}
         * @param cloudFormationExecutionRoleArn The CFN execution Role ARN to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRoleArn(final java.lang.String cloudFormationExecutionRoleArn) {
            this.props.cloudFormationExecutionRoleArn(cloudFormationExecutionRoleArn);
            return this;
        }

        /**
         * The deploy Role ARN to use.
         * <p>
         * Default: - No deploy role (use CLI credentials)
         * <p>
         * @return {@code this}
         * @param deployRoleArn The deploy Role ARN to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleArn(final java.lang.String deployRoleArn) {
            this.props.deployRoleArn(deployRoleArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.BootstraplessSynthesizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.BootstraplessSynthesizer build() {
            return new software.amazon.awscdk.core.BootstraplessSynthesizer(
                this.props.build()
            );
        }
    }
}
