package software.amazon.awscdk.core;

/**
 * A CloudFormation nested stack.
 * <p>
 * When you apply template changes to update a top-level stack, CloudFormation
 * updates the top-level stack and initiates an update to its nested stacks.
 * CloudFormation updates the resources of modified nested stacks, but does not
 * update the resources of unmodified nested stacks.
 * <p>
 * Furthermore, this stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 * <p>
 * Cross references of resource attributes between the parent stack and the
 * nested stack will automatically be translated to stack parameters and
 * outputs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.App;
 * import software.amazon.awscdk.core.CfnOutput;
 * import software.amazon.awscdk.core.NestedStack;
 * import software.amazon.awscdk.core.NestedStackProps;
 * import software.amazon.awscdk.core.Stack;
 * import software.constructs.Construct;
 * import software.amazon.awscdk.services.apigateway.Deployment;
 * import software.amazon.awscdk.services.apigateway.Method;
 * import software.amazon.awscdk.services.apigateway.MockIntegration;
 * import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
 * import software.amazon.awscdk.services.apigateway.RestApi;
 * import software.amazon.awscdk.services.apigateway.Stage;
 * /**
 *  * This file showcases how to split up a RestApi's Resources and Methods across nested stacks.
 *  *
 *  * The root stack 'RootStack' first defines a RestApi.
 *  * Two nested stacks BooksStack and PetsStack, create corresponding Resources '/books' and '/pets'.
 *  * They are then deployed to a 'prod' Stage via a third nested stack - DeployStack.
 *  *
 *  * To verify this worked, go to the APIGateway
 *  *&#47;
 * public class RootStack extends Stack {
 *     public RootStack(Construct scope) {
 *         super(scope, "integ-restapi-import-RootStack");
 *         RestApi restApi = RestApi.Builder.create(this, "RestApi")
 *                 .deploy(false)
 *                 .build();
 *         restApi.root.addMethod("ANY");
 *         PetsStack petsStack = new PetsStack(this, new ResourceNestedStackProps()
 *                 .restApiId(restApi.getRestApiId())
 *                 .rootResourceId(restApi.getRestApiRootResourceId())
 *                 );
 *         BooksStack booksStack = new BooksStack(this, new ResourceNestedStackProps()
 *                 .restApiId(restApi.getRestApiId())
 *                 .rootResourceId(restApi.getRestApiRootResourceId())
 *                 );
 *         new DeployStack(this, new DeployStackProps()
 *                 .restApiId(restApi.getRestApiId())
 *                 .methods(petsStack.methods.concat(booksStack.getMethods()))
 *                 );
 *         CfnOutput.Builder.create(this, "PetsURL")
 *                 .value(String.format("https://%s.execute-api.%s.amazonaws.com/prod/pets", restApi.getRestApiId(), this.region))
 *                 .build();
 *         CfnOutput.Builder.create(this, "BooksURL")
 *                 .value(String.format("https://%s.execute-api.%s.amazonaws.com/prod/books", restApi.getRestApiId(), this.region))
 *                 .build();
 *     }
 * }
 * public class ResourceNestedStackProps extends NestedStackProps {
 *     private String restApiId;
 *     public String getRestApiId() {
 *         return this.restApiId;
 *     }
 *     public ResourceNestedStackProps restApiId(String restApiId) {
 *         this.restApiId = restApiId;
 *         return this;
 *     }
 *     private String rootResourceId;
 *     public String getRootResourceId() {
 *         return this.rootResourceId;
 *     }
 *     public ResourceNestedStackProps rootResourceId(String rootResourceId) {
 *         this.rootResourceId = rootResourceId;
 *         return this;
 *     }
 * }
 * public class PetsStack extends NestedStack {
 *     public final Method[] methods;
 *     public PetsStack(Construct scope, ResourceNestedStackProps props) {
 *         super(scope, "integ-restapi-import-PetsStack", props);
 *         IRestApi api = RestApi.fromRestApiAttributes(this, "RestApi", RestApiAttributes.builder()
 *                 .restApiId(props.getRestApiId())
 *                 .rootResourceId(props.getRootResourceId())
 *                 .build());
 *         Method method = api.root.addResource("pets").addMethod("GET", MockIntegration.Builder.create()
 *                 .integrationResponses(List.of(IntegrationResponse.builder()
 *                         .statusCode("200")
 *                         .build()))
 *                 .passthroughBehavior(PassthroughBehavior.NEVER)
 *                 .requestTemplates(Map.of(
 *                         "application/json", "{ \"statusCode\": 200 }"))
 *                 .build(), MethodOptions.builder()
 *                 .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *                 .build());
 *         this.methods.push(method);
 *     }
 * }
 * public class BooksStack extends NestedStack {
 *     public final Method[] methods;
 *     public BooksStack(Construct scope, ResourceNestedStackProps props) {
 *         super(scope, "integ-restapi-import-BooksStack", props);
 *         IRestApi api = RestApi.fromRestApiAttributes(this, "RestApi", RestApiAttributes.builder()
 *                 .restApiId(props.getRestApiId())
 *                 .rootResourceId(props.getRootResourceId())
 *                 .build());
 *         Method method = api.root.addResource("books").addMethod("GET", MockIntegration.Builder.create()
 *                 .integrationResponses(List.of(IntegrationResponse.builder()
 *                         .statusCode("200")
 *                         .build()))
 *                 .passthroughBehavior(PassthroughBehavior.NEVER)
 *                 .requestTemplates(Map.of(
 *                         "application/json", "{ \"statusCode\": 200 }"))
 *                 .build(), MethodOptions.builder()
 *                 .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *                 .build());
 *         this.methods.push(method);
 *     }
 * }
 * public class DeployStackProps extends NestedStackProps {
 *     private String restApiId;
 *     public String getRestApiId() {
 *         return this.restApiId;
 *     }
 *     public DeployStackProps restApiId(String restApiId) {
 *         this.restApiId = restApiId;
 *         return this;
 *     }
 *     private Method[] methods;
 *     public Method[] getMethods() {
 *         return this.methods;
 *     }
 *     public DeployStackProps methods(Method[] methods) {
 *         this.methods = methods;
 *         return this;
 *     }
 * }
 * public class DeployStack extends NestedStack {
 *     public DeployStack(Construct scope, DeployStackProps props) {
 *         super(scope, "integ-restapi-import-DeployStack", props);
 *         Deployment deployment = Deployment.Builder.create(this, "Deployment")
 *                 .api(RestApi.fromRestApiId(this, "RestApi", props.getRestApiId()))
 *                 .build();
 *         if (props.getMethods()) {
 *             for (Object method : props.getMethods()) {
 *                 deployment.node.addDependency(method);
 *             }
 *         }
 *         Stage.Builder.create(this, "Stage").deployment(deployment).build();
 *     }
 * }
 * new RootStack(new App());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:30:57.062Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.NestedStack")
public class NestedStack extends software.amazon.awscdk.core.Stack {

    protected NestedStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NestedStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NestedStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.NestedStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NestedStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Checks if `x` is an object of type `NestedStack`.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isNestedStack(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.NestedStack.class, "isNestedStack", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Assign a value to one of the nested stack parameters.
     * <p>
     * @param name The parameter name (ID). This parameter is required.
     * @param value The value to assign. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameter(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "setParameter", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * An attribute that represents the ID of the stack.
     * <p>
     * This is a context aware attribute:
     * <p>
     * <ul>
     * <li>If this is referenced from the parent stack, it will return <code>{ "Ref": "LogicalIdOfNestedStackResource" }</code>.</li>
     * <li>If this is referenced from the context of the nested stack, it will return <code>{ "Ref": "AWS::StackId" }</code></li>
     * </ul>
     * <p>
     * Example value: <code>arn:aws:cloudformation:us-east-2:123456789012:stack/mystack-mynestedstack-sggfrhxhum7w/f449b250-b969-11e0-a185-5081d0136786</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackId() {
        return software.amazon.jsii.Kernel.get(this, "stackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An attribute that represents the name of the nested stack.
     * <p>
     * This is a context aware attribute:
     * <p>
     * <ul>
     * <li>If this is referenced from the parent stack, it will return a token that parses the name from the stack ID.</li>
     * <li>If this is referenced from the context of the nested stack, it will return <code>{ "Ref": "AWS::StackName" }</code></li>
     * </ul>
     * <p>
     * Example value: <code>mystack-mynestedstack-sggfrhxhum7w</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackName() {
        return software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the CloudFormation template file emitted to the output directory during synthesis.
     * <p>
     * Example value: <code>MyStack.template.json</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile() {
        return software.amazon.jsii.Kernel.get(this, "templateFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If this is a nested stack, this represents its `AWS::CloudFormation::Stack` resource.
     * <p>
     * <code>undefined</code> for top-level (non-nested) stacks.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnResource getNestedStackResource() {
        return software.amazon.jsii.Kernel.get(this, "nestedStackResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnResource.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.NestedStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.NestedStack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.core.NestedStackProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The Simple Notification Service (SNS) topics to publish stack related events.
         * <p>
         * Default: - notifications are not sent for this stack.
         * <p>
         * @return {@code this}
         * @param notificationArns The Simple Notification Service (SNS) topics to publish stack related events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(final java.util.List<java.lang.String> notificationArns) {
            this.props().notificationArns(notificationArns);
            return this;
        }

        /**
         * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         * <p>
         * Each parameter has a name corresponding
         * to a parameter defined in the embedded template and a value representing
         * the value that you want to set for the parameter.
         * <p>
         * The nested stack construct will automatically synthesize parameters in order
         * to bind references from the parent stack(s) into the nested stack.
         * <p>
         * Default: - no user-defined parameters are passed to the nested stack
         * <p>
         * @return {@code this}
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * Policy to apply when the nested stack is removed.
         * <p>
         * The default is <code>Destroy</code>, because all Removal Policies of resources inside the
         * Nested Stack should already have been set correctly. You normally should
         * not need to set this value.
         * <p>
         * Default: RemovalPolicy.DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the nested stack is removed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state.
         * <p>
         * When CloudFormation detects that the nested stack has reached the
         * CREATE_COMPLETE state, it marks the nested stack resource as
         * CREATE_COMPLETE in the parent stack and resumes creating the parent stack.
         * If the timeout period expires before the nested stack reaches
         * CREATE_COMPLETE, CloudFormation marks the nested stack as failed and rolls
         * back both the nested stack and parent stack.
         * <p>
         * Default: - no timeout
         * <p>
         * @return {@code this}
         * @param timeout The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.NestedStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.NestedStack build() {
            return new software.amazon.awscdk.core.NestedStack(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.NestedStackProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.NestedStackProps.Builder();
            }
            return this.props;
        }
    }
}
