package software.amazon.awscdk.services.ecr;

/**
 * A CloudFormation `AWS::ECR::PublicRepository`.
 * <p>
 * The <code>AWS::ECR::PublicRepository</code> resource specifies an Amazon Elastic Container Registry Public (Amazon ECR Public) repository, where users can push and pull Docker images, Open Container Initiative (OCI) images, and OCI compatible artifacts. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repositories.html">Amazon ECR public repositories</a> in the <em>Amazon ECR Public User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecr.*;
 * Object repositoryCatalogData;
 * Object repositoryPolicyText;
 * CfnPublicRepository cfnPublicRepository = CfnPublicRepository.Builder.create(this, "MyCfnPublicRepository")
 *         .repositoryCatalogData(repositoryCatalogData)
 *         .repositoryName("repositoryName")
 *         .repositoryPolicyText(repositoryPolicyText)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:01.867Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecr.$Module.class, fqn = "@aws-cdk/aws-ecr.CfnPublicRepository")
public class CfnPublicRepository extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnPublicRepository(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPublicRepository(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.CfnPublicRepository.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ECR::PublicRepository`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPublicRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.CfnPublicRepositoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ECR::PublicRepository`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPublicRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) for the specified `AWS::ECR::PublicRepository` resource.
     * <p>
     * For example, <code>arn:aws:ecr-public:: *123456789012* :repository/ *test-repository*</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-catalog-data.html">Amazon ECR Public repository catalog data</a> in the <em>Amazon ECR Public User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRepositoryCatalogData() {
        return software.amazon.jsii.Kernel.get(this, "repositoryCatalogData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-catalog-data.html">Amazon ECR Public repository catalog data</a> in the <em>Amazon ECR Public User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRepositoryCatalogData(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "repositoryCatalogData", java.util.Objects.requireNonNull(value, "repositoryCatalogData is required"));
    }

    /**
     * The JSON repository policy text to apply to the public repository.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-policies.html">Amazon ECR Public repository policies</a> in the <em>Amazon ECR Public User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRepositoryPolicyText() {
        return software.amazon.jsii.Kernel.get(this, "repositoryPolicyText", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The JSON repository policy text to apply to the public repository.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-policies.html">Amazon ECR Public repository policies</a> in the <em>Amazon ECR Public User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRepositoryPolicyText(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "repositoryPolicyText", java.util.Objects.requireNonNull(value, "repositoryPolicyText is required"));
    }

    /**
     * The name to use for the public repository.
     * <p>
     * The repository name may be specified on its own (such as <code>nginx-web-app</code> ) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code> ). If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the repository name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRepositoryName() {
        return software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name to use for the public repository.
     * <p>
     * The repository name may be specified on its own (such as <code>nginx-web-app</code> ) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code> ). If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the repository name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRepositoryName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "repositoryName", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecr.CfnPublicRepository}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecr.CfnPublicRepository> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecr.CfnPublicRepositoryProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-catalog-data.html">Amazon ECR Public repository catalog data</a> in the <em>Amazon ECR Public User Guide</em> .
         * <p>
         * @return {@code this}
         * @param repositoryCatalogData The details about the repository that are publicly visible in the Amazon ECR Public Gallery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryCatalogData(final java.lang.Object repositoryCatalogData) {
            this.props().repositoryCatalogData(repositoryCatalogData);
            return this;
        }

        /**
         * The name to use for the public repository.
         * <p>
         * The repository name may be specified on its own (such as <code>nginx-web-app</code> ) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code> ). If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the repository name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param repositoryName The name to use for the public repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props().repositoryName(repositoryName);
            return this;
        }

        /**
         * The JSON repository policy text to apply to the public repository.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-policies.html">Amazon ECR Public repository policies</a> in the <em>Amazon ECR Public User Guide</em> .
         * <p>
         * @return {@code this}
         * @param repositoryPolicyText The JSON repository policy text to apply to the public repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryPolicyText(final java.lang.Object repositoryPolicyText) {
            this.props().repositoryPolicyText(repositoryPolicyText);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecr.CfnPublicRepository}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecr.CfnPublicRepository build() {
            return new software.amazon.awscdk.services.ecr.CfnPublicRepository(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecr.CfnPublicRepositoryProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecr.CfnPublicRepositoryProps.Builder();
            }
            return this.props;
        }
    }
}
