package software.amazon.awscdk.services.ecr;

/**
 * Properties for defining a `CfnPullThroughCacheRule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecr.*;
 * CfnPullThroughCacheRuleProps cfnPullThroughCacheRuleProps = CfnPullThroughCacheRuleProps.builder()
 *         .ecrRepositoryPrefix("ecrRepositoryPrefix")
 *         .upstreamRegistryUrl("upstreamRegistryUrl")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:01.871Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecr.$Module.class, fqn = "@aws-cdk/aws-ecr.CfnPullThroughCacheRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnPullThroughCacheRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPullThroughCacheRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon ECR repository prefix associated with the pull through cache rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEcrRepositoryPrefix() {
        return null;
    }

    /**
     * The upstream registry URL associated with the pull through cache rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUpstreamRegistryUrl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPullThroughCacheRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPullThroughCacheRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPullThroughCacheRuleProps> {
        java.lang.String ecrRepositoryPrefix;
        java.lang.String upstreamRegistryUrl;

        /**
         * Sets the value of {@link CfnPullThroughCacheRuleProps#getEcrRepositoryPrefix}
         * @param ecrRepositoryPrefix The Amazon ECR repository prefix associated with the pull through cache rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecrRepositoryPrefix(java.lang.String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnPullThroughCacheRuleProps#getUpstreamRegistryUrl}
         * @param upstreamRegistryUrl The upstream registry URL associated with the pull through cache rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder upstreamRegistryUrl(java.lang.String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPullThroughCacheRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPullThroughCacheRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPullThroughCacheRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPullThroughCacheRuleProps {
        private final java.lang.String ecrRepositoryPrefix;
        private final java.lang.String upstreamRegistryUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ecrRepositoryPrefix = software.amazon.jsii.Kernel.get(this, "ecrRepositoryPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.upstreamRegistryUrl = software.amazon.jsii.Kernel.get(this, "upstreamRegistryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
            this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        }

        @Override
        public final java.lang.String getEcrRepositoryPrefix() {
            return this.ecrRepositoryPrefix;
        }

        @Override
        public final java.lang.String getUpstreamRegistryUrl() {
            return this.upstreamRegistryUrl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEcrRepositoryPrefix() != null) {
                data.set("ecrRepositoryPrefix", om.valueToTree(this.getEcrRepositoryPrefix()));
            }
            if (this.getUpstreamRegistryUrl() != null) {
                data.set("upstreamRegistryUrl", om.valueToTree(this.getUpstreamRegistryUrl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecr.CfnPullThroughCacheRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPullThroughCacheRuleProps.Jsii$Proxy that = (CfnPullThroughCacheRuleProps.Jsii$Proxy) o;

            if (this.ecrRepositoryPrefix != null ? !this.ecrRepositoryPrefix.equals(that.ecrRepositoryPrefix) : that.ecrRepositoryPrefix != null) return false;
            return this.upstreamRegistryUrl != null ? this.upstreamRegistryUrl.equals(that.upstreamRegistryUrl) : that.upstreamRegistryUrl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ecrRepositoryPrefix != null ? this.ecrRepositoryPrefix.hashCode() : 0;
            result = 31 * result + (this.upstreamRegistryUrl != null ? this.upstreamRegistryUrl.hashCode() : 0);
            return result;
        }
    }
}
