package software.amazon.awscdk.services.ecr;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Repository.Builder.create(this, "Repo").imageTagMutability(TagMutability.IMMUTABLE).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:01.906Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecr.$Module.class, fqn = "@aws-cdk/aws-ecr.RepositoryProps")
@software.amazon.jsii.Jsii.Proxy(RepositoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RepositoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The kind of server-side encryption to apply to this repository.
     * <p>
     * If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
     * encryptionKey is not specified, an AWS managed KMS key is used.
     * <p>
     * Default: - `KMS` if `encryptionKey` is specified, or `AES256` otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.RepositoryEncryption getEncryption() {
        return null;
    }

    /**
     * External KMS key to use for repository encryption.
     * <p>
     * The 'encryption' property must be either not specified or set to "KMS".
     * An error will be emitted if encryption is set to "AES256".
     * <p>
     * Default: - If encryption is set to `KMS` and this property is undefined,
     * an AWS managed KMS key is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Enable the scan on push when creating the repository.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getImageScanOnPush() {
        return null;
    }

    /**
     * The tag mutability setting for the repository.
     * <p>
     * If this parameter is omitted, the default setting of MUTABLE will be used which will allow image tags to be overwritten.
     * <p>
     * Default: TagMutability.MUTABLE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.TagMutability getImageTagMutability() {
        return null;
    }

    /**
     * The AWS account ID associated with the registry that contains the repository.
     * <p>
     * Default: The default registry is assumed.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_PutLifecyclePolicy.html">https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_PutLifecyclePolicy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLifecycleRegistryId() {
        return null;
    }

    /**
     * Life cycle rules to apply to this registry.
     * <p>
     * Default: No life cycle rules
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecr.LifecycleRule> getLifecycleRules() {
        return null;
    }

    /**
     * Determine what happens to the repository when the resource/stack is deleted.
     * <p>
     * Default: RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Name for this repository.
     * <p>
     * Default: Automatically generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RepositoryProps> {
        software.amazon.awscdk.services.ecr.RepositoryEncryption encryption;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.Boolean imageScanOnPush;
        software.amazon.awscdk.services.ecr.TagMutability imageTagMutability;
        java.lang.String lifecycleRegistryId;
        java.util.List<software.amazon.awscdk.services.ecr.LifecycleRule> lifecycleRules;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.lang.String repositoryName;

        /**
         * Sets the value of {@link RepositoryProps#getEncryption}
         * @param encryption The kind of server-side encryption to apply to this repository.
         *                   If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         *                   encryptionKey is not specified, an AWS managed KMS key is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.ecr.RepositoryEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryProps#getEncryptionKey}
         * @param encryptionKey External KMS key to use for repository encryption.
         *                      The 'encryption' property must be either not specified or set to "KMS".
         *                      An error will be emitted if encryption is set to "AES256".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryProps#getImageScanOnPush}
         * @param imageScanOnPush Enable the scan on push when creating the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageScanOnPush(java.lang.Boolean imageScanOnPush) {
            this.imageScanOnPush = imageScanOnPush;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryProps#getImageTagMutability}
         * @param imageTagMutability The tag mutability setting for the repository.
         *                           If this parameter is omitted, the default setting of MUTABLE will be used which will allow image tags to be overwritten.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTagMutability(software.amazon.awscdk.services.ecr.TagMutability imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryProps#getLifecycleRegistryId}
         * @param lifecycleRegistryId The AWS account ID associated with the registry that contains the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleRegistryId(java.lang.String lifecycleRegistryId) {
            this.lifecycleRegistryId = lifecycleRegistryId;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryProps#getLifecycleRules}
         * @param lifecycleRules Life cycle rules to apply to this registry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder lifecycleRules(java.util.List<? extends software.amazon.awscdk.services.ecr.LifecycleRule> lifecycleRules) {
            this.lifecycleRules = (java.util.List<software.amazon.awscdk.services.ecr.LifecycleRule>)lifecycleRules;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryProps#getRemovalPolicy}
         * @param removalPolicy Determine what happens to the repository when the resource/stack is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryProps#getRepositoryName}
         * @param repositoryName Name for this repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RepositoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RepositoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepositoryProps {
        private final software.amazon.awscdk.services.ecr.RepositoryEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.Boolean imageScanOnPush;
        private final software.amazon.awscdk.services.ecr.TagMutability imageTagMutability;
        private final java.lang.String lifecycleRegistryId;
        private final java.util.List<software.amazon.awscdk.services.ecr.LifecycleRule> lifecycleRules;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.lang.String repositoryName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.RepositoryEncryption.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.imageScanOnPush = software.amazon.jsii.Kernel.get(this, "imageScanOnPush", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.imageTagMutability = software.amazon.jsii.Kernel.get(this, "imageTagMutability", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.TagMutability.class));
            this.lifecycleRegistryId = software.amazon.jsii.Kernel.get(this, "lifecycleRegistryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lifecycleRules = software.amazon.jsii.Kernel.get(this, "lifecycleRules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.LifecycleRule.class)));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryption = builder.encryption;
            this.encryptionKey = builder.encryptionKey;
            this.imageScanOnPush = builder.imageScanOnPush;
            this.imageTagMutability = builder.imageTagMutability;
            this.lifecycleRegistryId = builder.lifecycleRegistryId;
            this.lifecycleRules = (java.util.List<software.amazon.awscdk.services.ecr.LifecycleRule>)builder.lifecycleRules;
            this.removalPolicy = builder.removalPolicy;
            this.repositoryName = builder.repositoryName;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.RepositoryEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.Boolean getImageScanOnPush() {
            return this.imageScanOnPush;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.TagMutability getImageTagMutability() {
            return this.imageTagMutability;
        }

        @Override
        public final java.lang.String getLifecycleRegistryId() {
            return this.lifecycleRegistryId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecr.LifecycleRule> getLifecycleRules() {
            return this.lifecycleRules;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getImageScanOnPush() != null) {
                data.set("imageScanOnPush", om.valueToTree(this.getImageScanOnPush()));
            }
            if (this.getImageTagMutability() != null) {
                data.set("imageTagMutability", om.valueToTree(this.getImageTagMutability()));
            }
            if (this.getLifecycleRegistryId() != null) {
                data.set("lifecycleRegistryId", om.valueToTree(this.getLifecycleRegistryId()));
            }
            if (this.getLifecycleRules() != null) {
                data.set("lifecycleRules", om.valueToTree(this.getLifecycleRules()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecr.RepositoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RepositoryProps.Jsii$Proxy that = (RepositoryProps.Jsii$Proxy) o;

            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.imageScanOnPush != null ? !this.imageScanOnPush.equals(that.imageScanOnPush) : that.imageScanOnPush != null) return false;
            if (this.imageTagMutability != null ? !this.imageTagMutability.equals(that.imageTagMutability) : that.imageTagMutability != null) return false;
            if (this.lifecycleRegistryId != null ? !this.lifecycleRegistryId.equals(that.lifecycleRegistryId) : that.lifecycleRegistryId != null) return false;
            if (this.lifecycleRules != null ? !this.lifecycleRules.equals(that.lifecycleRules) : that.lifecycleRules != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.repositoryName != null ? this.repositoryName.equals(that.repositoryName) : that.repositoryName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryption != null ? this.encryption.hashCode() : 0;
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.imageScanOnPush != null ? this.imageScanOnPush.hashCode() : 0);
            result = 31 * result + (this.imageTagMutability != null ? this.imageTagMutability.hashCode() : 0);
            result = 31 * result + (this.lifecycleRegistryId != null ? this.lifecycleRegistryId.hashCode() : 0);
            result = 31 * result + (this.lifecycleRules != null ? this.lifecycleRules.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            return result;
        }
    }
}
