package software.amazon.awscdk.services.kms;

/**
 * Construction properties for a KMS Key object.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IRole myTrustedAdminRole = Role.fromRoleArn(this, "TrustedRole", "arn:aws:iam:....");
 * // Creates a limited admin policy and assigns to the account root.
 * PolicyDocument myCustomPolicy = PolicyDocument.Builder.create()
 *         .statements(List.of(PolicyStatement.Builder.create()
 *                 .actions(List.of("kms:Create*", "kms:Describe*", "kms:Enable*", "kms:List*", "kms:Put*"))
 *                 .principals(List.of(new AccountRootPrincipal()))
 *                 .resources(List.of("*"))
 *                 .build()))
 *         .build();
 * Key key = Key.Builder.create(this, "MyKey")
 *         .policy(myCustomPolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:01.792Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kms.$Module.class, fqn = "@aws-cdk/aws-kms.KeyProps")
@software.amazon.jsii.Jsii.Proxy(KeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of principals to add as key administrators to the key policy.
     * <p>
     * Key administrators have permissions to manage the key (e.g., change permissions, revoke), but do not have permissions
     * to use the key in cryptographic operations (e.g., encrypt, decrypt).
     * <p>
     * These principals will be added to the default key policy (if none specified), or to the specified policy (if provided).
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getAdmins() {
        return null;
    }

    /**
     * Initial alias to add to the key.
     * <p>
     * More aliases can be added later by calling <code>addAlias</code>.
     * <p>
     * Default: - No alias is added for the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
        return null;
    }

    /**
     * A description of the key.
     * <p>
     * Use a description that helps your users decide
     * whether the key is appropriate for a particular task.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Indicates whether the key is available for use.
     * <p>
     * Default: - Key is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Indicates whether AWS KMS rotates the key.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableKeyRotation() {
        return null;
    }

    /**
     * The cryptographic configuration of the key. The valid value depends on usage of the key.
     * <p>
     * IMPORTANT: If you change this property of an existing key, the existing key is scheduled for deletion
     * and a new key is created with the specified value.
     * <p>
     * Default: KeySpec.SYMMETRIC_DEFAULT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.KeySpec getKeySpec() {
        return null;
    }

    /**
     * The cryptographic operations for which the key can be used.
     * <p>
     * IMPORTANT: If you change this property of an existing key, the existing key is scheduled for deletion
     * and a new key is created with the specified value.
     * <p>
     * Default: KeyUsage.ENCRYPT_DECRYPT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.KeyUsage getKeyUsage() {
        return null;
    }

    /**
     * Specifies the number of days in the waiting period before AWS KMS deletes a CMK that has been removed from a CloudFormation stack.
     * <p>
     * When you remove a customer master key (CMK) from a CloudFormation stack, AWS KMS schedules the CMK for deletion
     * and starts the mandatory waiting period. The PendingWindowInDays property determines the length of waiting period.
     * During the waiting period, the key state of CMK is Pending Deletion, which prevents the CMK from being used in
     * cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the CMK.
     * <p>
     * Enter a value between 7 and 30 days.
     * <p>
     * Default: - 30 days
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-pendingwindowindays">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-pendingwindowindays</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getPendingWindow() {
        return null;
    }

    /**
     * Custom policy document to attach to the KMS key.
     * <p>
     * NOTE - If the <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> feature flag is set (the default for new projects),
     * this policy will <em>override</em> the default key policy and become the only key policy for the key. If the
     * feature flag is not set, this policy will be appended to the default key policy.
     * <p>
     * Default: - A policy document with permissions for the account root to
     * administer the key will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
        return null;
    }

    /**
     * Whether the encryption key should be retained when it is removed from the Stack.
     * <p>
     * This is useful when one wants to
     * retain access to data that was encrypted with a key that is being retired.
     * <p>
     * Default: RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (deprecated) Whether the key usage can be granted by IAM policies.
     * <p>
     * Setting this to true adds a default statement which delegates key
     * access control completely to the identity's IAM policy (similar
     * to how it works for other AWS resources). This matches the default behavior
     * when creating KMS keys via the API or console.
     * <p>
     * If the <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> feature flag is set (the default for new projects),
     * this flag will always be treated as 'true' and does not need to be explicitly set.
     * <p>
     * Default: - false, unless the `@aws-cdk/aws-kms:defaultKeyPolicies` feature flag is set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam</a>
     * @deprecated redundant with the `@aws-cdk/aws-kms:defaultKeyPolicies` feature flag
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTrustAccountIdentities() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeyProps> {
        java.util.List<software.amazon.awscdk.services.iam.IPrincipal> admins;
        java.lang.String alias;
        java.lang.String description;
        java.lang.Boolean enabled;
        java.lang.Boolean enableKeyRotation;
        software.amazon.awscdk.services.kms.KeySpec keySpec;
        software.amazon.awscdk.services.kms.KeyUsage keyUsage;
        software.amazon.awscdk.core.Duration pendingWindow;
        software.amazon.awscdk.services.iam.PolicyDocument policy;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.lang.Boolean trustAccountIdentities;

        /**
         * Sets the value of {@link KeyProps#getAdmins}
         * @param admins A list of principals to add as key administrators to the key policy.
         *               Key administrators have permissions to manage the key (e.g., change permissions, revoke), but do not have permissions
         *               to use the key in cryptographic operations (e.g., encrypt, decrypt).
         *               <p>
         *               These principals will be added to the default key policy (if none specified), or to the specified policy (if provided).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder admins(java.util.List<? extends software.amazon.awscdk.services.iam.IPrincipal> admins) {
            this.admins = (java.util.List<software.amazon.awscdk.services.iam.IPrincipal>)admins;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getAlias}
         * @param alias Initial alias to add to the key.
         *              More aliases can be added later by calling <code>addAlias</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(java.lang.String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getDescription}
         * @param description A description of the key.
         *                    Use a description that helps your users decide
         *                    whether the key is appropriate for a particular task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getEnabled}
         * @param enabled Indicates whether the key is available for use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getEnableKeyRotation}
         * @param enableKeyRotation Indicates whether AWS KMS rotates the key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(java.lang.Boolean enableKeyRotation) {
            this.enableKeyRotation = enableKeyRotation;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getKeySpec}
         * @param keySpec The cryptographic configuration of the key. The valid value depends on usage of the key.
         *                IMPORTANT: If you change this property of an existing key, the existing key is scheduled for deletion
         *                and a new key is created with the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySpec(software.amazon.awscdk.services.kms.KeySpec keySpec) {
            this.keySpec = keySpec;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getKeyUsage}
         * @param keyUsage The cryptographic operations for which the key can be used.
         *                 IMPORTANT: If you change this property of an existing key, the existing key is scheduled for deletion
         *                 and a new key is created with the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyUsage(software.amazon.awscdk.services.kms.KeyUsage keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getPendingWindow}
         * @param pendingWindow Specifies the number of days in the waiting period before AWS KMS deletes a CMK that has been removed from a CloudFormation stack.
         *                      When you remove a customer master key (CMK) from a CloudFormation stack, AWS KMS schedules the CMK for deletion
         *                      and starts the mandatory waiting period. The PendingWindowInDays property determines the length of waiting period.
         *                      During the waiting period, the key state of CMK is Pending Deletion, which prevents the CMK from being used in
         *                      cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the CMK.
         *                      <p>
         *                      Enter a value between 7 and 30 days.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pendingWindow(software.amazon.awscdk.core.Duration pendingWindow) {
            this.pendingWindow = pendingWindow;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getPolicy}
         * @param policy Custom policy document to attach to the KMS key.
         *               NOTE - If the <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> feature flag is set (the default for new projects),
         *               this policy will <em>override</em> the default key policy and become the only key policy for the key. If the
         *               feature flag is not set, this policy will be appended to the default key policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getRemovalPolicy}
         * @param removalPolicy Whether the encryption key should be retained when it is removed from the Stack.
         *                      This is useful when one wants to
         *                      retain access to data that was encrypted with a key that is being retired.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getTrustAccountIdentities}
         * @param trustAccountIdentities Whether the key usage can be granted by IAM policies.
         *                               Setting this to true adds a default statement which delegates key
         *                               access control completely to the identity's IAM policy (similar
         *                               to how it works for other AWS resources). This matches the default behavior
         *                               when creating KMS keys via the API or console.
         *                               <p>
         *                               If the <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> feature flag is set (the default for new projects),
         *                               this flag will always be treated as 'true' and does not need to be explicitly set.
         * @return {@code this}
         * @deprecated redundant with the `@aws-cdk/aws-kms:defaultKeyPolicies` feature flag
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder trustAccountIdentities(java.lang.Boolean trustAccountIdentities) {
            this.trustAccountIdentities = trustAccountIdentities;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyProps {
        private final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> admins;
        private final java.lang.String alias;
        private final java.lang.String description;
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean enableKeyRotation;
        private final software.amazon.awscdk.services.kms.KeySpec keySpec;
        private final software.amazon.awscdk.services.kms.KeyUsage keyUsage;
        private final software.amazon.awscdk.core.Duration pendingWindow;
        private final software.amazon.awscdk.services.iam.PolicyDocument policy;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.lang.Boolean trustAccountIdentities;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.admins = software.amazon.jsii.Kernel.get(this, "admins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class)));
            this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableKeyRotation = software.amazon.jsii.Kernel.get(this, "enableKeyRotation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.keySpec = software.amazon.jsii.Kernel.get(this, "keySpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.KeySpec.class));
            this.keyUsage = software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.KeyUsage.class));
            this.pendingWindow = software.amazon.jsii.Kernel.get(this, "pendingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.trustAccountIdentities = software.amazon.jsii.Kernel.get(this, "trustAccountIdentities", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.admins = (java.util.List<software.amazon.awscdk.services.iam.IPrincipal>)builder.admins;
            this.alias = builder.alias;
            this.description = builder.description;
            this.enabled = builder.enabled;
            this.enableKeyRotation = builder.enableKeyRotation;
            this.keySpec = builder.keySpec;
            this.keyUsage = builder.keyUsage;
            this.pendingWindow = builder.pendingWindow;
            this.policy = builder.policy;
            this.removalPolicy = builder.removalPolicy;
            this.trustAccountIdentities = builder.trustAccountIdentities;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getAdmins() {
            return this.admins;
        }

        @Override
        public final java.lang.String getAlias() {
            return this.alias;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Boolean getEnableKeyRotation() {
            return this.enableKeyRotation;
        }

        @Override
        public final software.amazon.awscdk.services.kms.KeySpec getKeySpec() {
            return this.keySpec;
        }

        @Override
        public final software.amazon.awscdk.services.kms.KeyUsage getKeyUsage() {
            return this.keyUsage;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getPendingWindow() {
            return this.pendingWindow;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
            return this.policy;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.lang.Boolean getTrustAccountIdentities() {
            return this.trustAccountIdentities;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdmins() != null) {
                data.set("admins", om.valueToTree(this.getAdmins()));
            }
            if (this.getAlias() != null) {
                data.set("alias", om.valueToTree(this.getAlias()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEnableKeyRotation() != null) {
                data.set("enableKeyRotation", om.valueToTree(this.getEnableKeyRotation()));
            }
            if (this.getKeySpec() != null) {
                data.set("keySpec", om.valueToTree(this.getKeySpec()));
            }
            if (this.getKeyUsage() != null) {
                data.set("keyUsage", om.valueToTree(this.getKeyUsage()));
            }
            if (this.getPendingWindow() != null) {
                data.set("pendingWindow", om.valueToTree(this.getPendingWindow()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getTrustAccountIdentities() != null) {
                data.set("trustAccountIdentities", om.valueToTree(this.getTrustAccountIdentities()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kms.KeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeyProps.Jsii$Proxy that = (KeyProps.Jsii$Proxy) o;

            if (this.admins != null ? !this.admins.equals(that.admins) : that.admins != null) return false;
            if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.enableKeyRotation != null ? !this.enableKeyRotation.equals(that.enableKeyRotation) : that.enableKeyRotation != null) return false;
            if (this.keySpec != null ? !this.keySpec.equals(that.keySpec) : that.keySpec != null) return false;
            if (this.keyUsage != null ? !this.keyUsage.equals(that.keyUsage) : that.keyUsage != null) return false;
            if (this.pendingWindow != null ? !this.pendingWindow.equals(that.pendingWindow) : that.pendingWindow != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.trustAccountIdentities != null ? this.trustAccountIdentities.equals(that.trustAccountIdentities) : that.trustAccountIdentities == null;
        }

        @Override
        public final int hashCode() {
            int result = this.admins != null ? this.admins.hashCode() : 0;
            result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.enableKeyRotation != null ? this.enableKeyRotation.hashCode() : 0);
            result = 31 * result + (this.keySpec != null ? this.keySpec.hashCode() : 0);
            result = 31 * result + (this.keyUsage != null ? this.keyUsage.hashCode() : 0);
            result = 31 * result + (this.pendingWindow != null ? this.pendingWindow.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.trustAccountIdentities != null ? this.trustAccountIdentities.hashCode() : 0);
            return result;
        }
    }
}
