package software.amazon.awscdk.services.kms;

/**
 * The key usage, represents the cryptographic operations of keys.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Key key = Key.Builder.create(this, "MyKey")
 *         .keySpec(KeySpec.ECC_SECG_P256K1) // Default to SYMMETRIC_DEFAULT
 *         .keyUsage(KeyUsage.SIGN_VERIFY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:01.794Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kms.$Module.class, fqn = "@aws-cdk/aws-kms.KeyUsage")
public enum KeyUsage {
    /**
     * Encryption and decryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ENCRYPT_DECRYPT,
    /**
     * Signing and verification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SIGN_VERIFY,
}
