package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a `CfnAlias`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnAliasProps cfnAliasProps = CfnAliasProps.builder()
 *         .functionName("functionName")
 *         .functionVersion("functionVersion")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .provisionedConcurrencyConfig(ProvisionedConcurrencyConfigurationProperty.builder()
 *                 .provisionedConcurrentExecutions(123)
 *                 .build())
 *         .routingConfig(AliasRoutingConfigurationProperty.builder()
 *                 .additionalVersionWeights(List.of(VersionWeightProperty.builder()
 *                         .functionVersion("functionVersion")
 *                         .functionWeight(123)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:04.287Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnAliasProps")
@software.amazon.jsii.Jsii.Proxy(CfnAliasProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAliasProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Lambda function.
     * <p>
     * <strong>Name formats</strong> - <em>Function name</em> - <code>MyFunction</code> .
     * <p>
     * <ul>
     * <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code> .</li>
     * <li><em>Partial ARN</em> - <code>123456789012:function:MyFunction</code> .</li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

    /**
     * The function version that the alias invokes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionVersion();

    /**
     * The name of the alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A description of the alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies a [provisioned concurrency](https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html) configuration for a function's alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedConcurrencyConfig() {
        return null;
    }

    /**
     * The [routing configuration](https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html) of the alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRoutingConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAliasProps> {
        java.lang.String functionName;
        java.lang.String functionVersion;
        java.lang.String name;
        java.lang.String description;
        java.lang.Object provisionedConcurrencyConfig;
        java.lang.Object routingConfig;

        /**
         * Sets the value of {@link CfnAliasProps#getFunctionName}
         * @param functionName The name of the Lambda function. This parameter is required.
         *                     <strong>Name formats</strong> - <em>Function name</em> - <code>MyFunction</code> .
         *                     <p>
         *                     <ul>
         *                     <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code> .</li>
         *                     <li><em>Partial ARN</em> - <code>123456789012:function:MyFunction</code> .</li>
         *                     </ul>
         *                     <p>
         *                     The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAliasProps#getFunctionVersion}
         * @param functionVersion The function version that the alias invokes. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionVersion(java.lang.String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnAliasProps#getName}
         * @param name The name of the alias. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAliasProps#getDescription}
         * @param description A description of the alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAliasProps#getProvisionedConcurrencyConfig}
         * @param provisionedConcurrencyConfig Specifies a [provisioned concurrency](https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html) configuration for a function's alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(software.amazon.awscdk.services.lambda.CfnAlias.ProvisionedConcurrencyConfigurationProperty provisionedConcurrencyConfig) {
            this.provisionedConcurrencyConfig = provisionedConcurrencyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAliasProps#getProvisionedConcurrencyConfig}
         * @param provisionedConcurrencyConfig Specifies a [provisioned concurrency](https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html) configuration for a function's alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(software.amazon.awscdk.core.IResolvable provisionedConcurrencyConfig) {
            this.provisionedConcurrencyConfig = provisionedConcurrencyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAliasProps#getRoutingConfig}
         * @param routingConfig The [routing configuration](https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html) of the alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfig(software.amazon.awscdk.core.IResolvable routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAliasProps#getRoutingConfig}
         * @param routingConfig The [routing configuration](https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html) of the alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfig(software.amazon.awscdk.services.lambda.CfnAlias.AliasRoutingConfigurationProperty routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAliasProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAliasProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAliasProps {
        private final java.lang.String functionName;
        private final java.lang.String functionVersion;
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.lang.Object provisionedConcurrencyConfig;
        private final java.lang.Object routingConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionVersion = software.amazon.jsii.Kernel.get(this, "functionVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisionedConcurrencyConfig = software.amazon.jsii.Kernel.get(this, "provisionedConcurrencyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.routingConfig = software.amazon.jsii.Kernel.get(this, "routingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            this.functionVersion = java.util.Objects.requireNonNull(builder.functionVersion, "functionVersion is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.provisionedConcurrencyConfig = builder.provisionedConcurrencyConfig;
            this.routingConfig = builder.routingConfig;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.String getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getProvisionedConcurrencyConfig() {
            return this.provisionedConcurrencyConfig;
        }

        @Override
        public final java.lang.Object getRoutingConfig() {
            return this.routingConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionName", om.valueToTree(this.getFunctionName()));
            data.set("functionVersion", om.valueToTree(this.getFunctionVersion()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getProvisionedConcurrencyConfig() != null) {
                data.set("provisionedConcurrencyConfig", om.valueToTree(this.getProvisionedConcurrencyConfig()));
            }
            if (this.getRoutingConfig() != null) {
                data.set("routingConfig", om.valueToTree(this.getRoutingConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CfnAliasProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAliasProps.Jsii$Proxy that = (CfnAliasProps.Jsii$Proxy) o;

            if (!functionName.equals(that.functionName)) return false;
            if (!functionVersion.equals(that.functionVersion)) return false;
            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.provisionedConcurrencyConfig != null ? !this.provisionedConcurrencyConfig.equals(that.provisionedConcurrencyConfig) : that.provisionedConcurrencyConfig != null) return false;
            return this.routingConfig != null ? this.routingConfig.equals(that.routingConfig) : that.routingConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionName.hashCode();
            result = 31 * result + (this.functionVersion.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.provisionedConcurrencyConfig != null ? this.provisionedConcurrencyConfig.hashCode() : 0);
            result = 31 * result + (this.routingConfig != null ? this.routingConfig.hashCode() : 0);
            return result;
        }
    }
}
