package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a `CfnUrl`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnUrlProps cfnUrlProps = CfnUrlProps.builder()
 *         .authType("authType")
 *         .targetFunctionArn("targetFunctionArn")
 *         // the properties below are optional
 *         .cors(CorsProperty.builder()
 *                 .allowCredentials(false)
 *                 .allowHeaders(List.of("allowHeaders"))
 *                 .allowMethods(List.of("allowMethods"))
 *                 .allowOrigins(List.of("allowOrigins"))
 *                 .exposeHeaders(List.of("exposeHeaders"))
 *                 .maxAge(123)
 *                 .build())
 *         .invokeMode("invokeMode")
 *         .qualifier("qualifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:04.361Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnUrlProps")
@software.amazon.jsii.Jsii.Proxy(CfnUrlProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUrlProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of authentication that your function URL uses.
     * <p>
     * Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthType();

    /**
     * The name of the Lambda function.
     * <p>
     * <strong>Name formats</strong> - <em>Function name</em> - <code>my-function</code> .
     * <p>
     * <ul>
     * <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code> .</li>
     * <li><em>Partial ARN</em> - <code>123456789012:function:my-function</code> .</li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetFunctionArn();

    /**
     * The [Cross-Origin Resource Sharing (CORS)](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your function URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCors() {
        return null;
    }

    /**
     * `AWS::Lambda::Url.InvokeMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInvokeMode() {
        return null;
    }

    /**
     * The alias name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQualifier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUrlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUrlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUrlProps> {
        java.lang.String authType;
        java.lang.String targetFunctionArn;
        java.lang.Object cors;
        java.lang.String invokeMode;
        java.lang.String qualifier;

        /**
         * Sets the value of {@link CfnUrlProps#getAuthType}
         * @param authType The type of authentication that your function URL uses. This parameter is required.
         *                 Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(java.lang.String authType) {
            this.authType = authType;
            return this;
        }

        /**
         * Sets the value of {@link CfnUrlProps#getTargetFunctionArn}
         * @param targetFunctionArn The name of the Lambda function. This parameter is required.
         *                          <strong>Name formats</strong> - <em>Function name</em> - <code>my-function</code> .
         *                          <p>
         *                          <ul>
         *                          <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code> .</li>
         *                          <li><em>Partial ARN</em> - <code>123456789012:function:my-function</code> .</li>
         *                          </ul>
         *                          <p>
         *                          The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetFunctionArn(java.lang.String targetFunctionArn) {
            this.targetFunctionArn = targetFunctionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnUrlProps#getCors}
         * @param cors The [Cross-Origin Resource Sharing (CORS)](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your function URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(software.amazon.awscdk.core.IResolvable cors) {
            this.cors = cors;
            return this;
        }

        /**
         * Sets the value of {@link CfnUrlProps#getCors}
         * @param cors The [Cross-Origin Resource Sharing (CORS)](https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for your function URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(software.amazon.awscdk.services.lambda.CfnUrl.CorsProperty cors) {
            this.cors = cors;
            return this;
        }

        /**
         * Sets the value of {@link CfnUrlProps#getInvokeMode}
         * @param invokeMode `AWS::Lambda::Url.InvokeMode`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invokeMode(java.lang.String invokeMode) {
            this.invokeMode = invokeMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnUrlProps#getQualifier}
         * @param qualifier The alias name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(java.lang.String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUrlProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUrlProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUrlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUrlProps {
        private final java.lang.String authType;
        private final java.lang.String targetFunctionArn;
        private final java.lang.Object cors;
        private final java.lang.String invokeMode;
        private final java.lang.String qualifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetFunctionArn = software.amazon.jsii.Kernel.get(this, "targetFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cors = software.amazon.jsii.Kernel.get(this, "cors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.invokeMode = software.amazon.jsii.Kernel.get(this, "invokeMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.qualifier = software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authType = java.util.Objects.requireNonNull(builder.authType, "authType is required");
            this.targetFunctionArn = java.util.Objects.requireNonNull(builder.targetFunctionArn, "targetFunctionArn is required");
            this.cors = builder.cors;
            this.invokeMode = builder.invokeMode;
            this.qualifier = builder.qualifier;
        }

        @Override
        public final java.lang.String getAuthType() {
            return this.authType;
        }

        @Override
        public final java.lang.String getTargetFunctionArn() {
            return this.targetFunctionArn;
        }

        @Override
        public final java.lang.Object getCors() {
            return this.cors;
        }

        @Override
        public final java.lang.String getInvokeMode() {
            return this.invokeMode;
        }

        @Override
        public final java.lang.String getQualifier() {
            return this.qualifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authType", om.valueToTree(this.getAuthType()));
            data.set("targetFunctionArn", om.valueToTree(this.getTargetFunctionArn()));
            if (this.getCors() != null) {
                data.set("cors", om.valueToTree(this.getCors()));
            }
            if (this.getInvokeMode() != null) {
                data.set("invokeMode", om.valueToTree(this.getInvokeMode()));
            }
            if (this.getQualifier() != null) {
                data.set("qualifier", om.valueToTree(this.getQualifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CfnUrlProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUrlProps.Jsii$Proxy that = (CfnUrlProps.Jsii$Proxy) o;

            if (!authType.equals(that.authType)) return false;
            if (!targetFunctionArn.equals(that.targetFunctionArn)) return false;
            if (this.cors != null ? !this.cors.equals(that.cors) : that.cors != null) return false;
            if (this.invokeMode != null ? !this.invokeMode.equals(that.invokeMode) : that.invokeMode != null) return false;
            return this.qualifier != null ? this.qualifier.equals(that.qualifier) : that.qualifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authType.hashCode();
            result = 31 * result + (this.targetFunctionArn.hashCode());
            result = 31 * result + (this.cors != null ? this.cors.hashCode() : 0);
            result = 31 * result + (this.invokeMode != null ? this.invokeMode.hashCode() : 0);
            result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
            return result;
        }
    }
}
