package software.amazon.awscdk.services.logs;

/**
 * Properties for a SubscriptionFilter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.destinations.*;
 * Function fn;
 * LogGroup logGroup;
 * SubscriptionFilter.Builder.create(this, "Subscription")
 *         .logGroup(logGroup)
 *         .destination(new LambdaDestination(fn))
 *         .filterPattern(FilterPattern.allTerms("ERROR", "MainThread"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:02.449Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.$Module.class, fqn = "@aws-cdk/aws-logs.SubscriptionFilterProps")
@software.amazon.jsii.Jsii.Proxy(SubscriptionFilterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubscriptionFilterProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.logs.SubscriptionFilterOptions {

    /**
     * The log group to create the subscription on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup getLogGroup();

    /**
     * @return a {@link Builder} of {@link SubscriptionFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubscriptionFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubscriptionFilterProps> {
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination;
        software.amazon.awscdk.services.logs.IFilterPattern filterPattern;

        /**
         * Sets the value of {@link SubscriptionFilterProps#getLogGroup}
         * @param logGroup The log group to create the subscription on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionFilterProps#getDestination}
         * @param destination The destination to send the filtered events to. This parameter is required.
         *                    For example, a Kinesis stream or a Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionFilterProps#getFilterPattern}
         * @param filterPattern Log events matching this pattern will be sent to the destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(software.amazon.awscdk.services.logs.IFilterPattern filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubscriptionFilterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubscriptionFilterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubscriptionFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriptionFilterProps {
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination;
        private final software.amazon.awscdk.services.logs.IFilterPattern filterPattern;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogSubscriptionDestination.class));
            this.filterPattern = software.amazon.jsii.Kernel.get(this, "filterPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.IFilterPattern.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logGroup = java.util.Objects.requireNonNull(builder.logGroup, "logGroup is required");
            this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
            this.filterPattern = java.util.Objects.requireNonNull(builder.filterPattern, "filterPattern is required");
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogSubscriptionDestination getDestination() {
            return this.destination;
        }

        @Override
        public final software.amazon.awscdk.services.logs.IFilterPattern getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logGroup", om.valueToTree(this.getLogGroup()));
            data.set("destination", om.valueToTree(this.getDestination()));
            data.set("filterPattern", om.valueToTree(this.getFilterPattern()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-logs.SubscriptionFilterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubscriptionFilterProps.Jsii$Proxy that = (SubscriptionFilterProps.Jsii$Proxy) o;

            if (!logGroup.equals(that.logGroup)) return false;
            if (!destination.equals(that.destination)) return false;
            return this.filterPattern.equals(that.filterPattern);
        }

        @Override
        public final int hashCode() {
            int result = this.logGroup.hashCode();
            result = 31 * result + (this.destination.hashCode());
            result = 31 * result + (this.filterPattern.hashCode());
            return result;
        }
    }
}
