/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sqs;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.sqs.$Module;
import software.amazon.awscdk.services.sqs.DeadLetterQueue;
import software.amazon.awscdk.services.sqs.DeduplicationScope;
import software.amazon.awscdk.services.sqs.FifoThroughputLimit;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.awscdk.services.sqs.QueueAttributes;
import software.amazon.awscdk.services.sqs.QueueBase;
import software.amazon.awscdk.services.sqs.QueueEncryption;
import software.amazon.awscdk.services.sqs.QueueProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-sqs.Queue")
public class Queue
extends QueueBase {
    protected Queue(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Queue(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Queue(@NotNull Construct scope, @NotNull String id, @Nullable QueueProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Queue(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IQueue fromQueueArn(@NotNull Construct scope, @NotNull String id, @NotNull String queueArn) {
        return (IQueue)JsiiObject.jsiiStaticCall(Queue.class, (String)"fromQueueArn", (NativeType)NativeType.forClass(IQueue.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(queueArn, "queueArn is required")});
    }

    @NotNull
    public static IQueue fromQueueAttributes(@NotNull Construct scope, @NotNull String id, @NotNull QueueAttributes attrs) {
        return (IQueue)JsiiObject.jsiiStaticCall(Queue.class, (String)"fromQueueAttributes", (NativeType)NativeType.forClass(IQueue.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    protected Boolean getAutoCreatePolicy() {
        return (Boolean)Kernel.get((Object)this, (String)"autoCreatePolicy", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public Boolean getFifo() {
        return (Boolean)Kernel.get((Object)this, (String)"fifo", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public String getQueueArn() {
        return (String)Kernel.get((Object)this, (String)"queueArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getQueueName() {
        return (String)Kernel.get((Object)this, (String)"queueName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getQueueUrl() {
        return (String)Kernel.get((Object)this, (String)"queueUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public DeadLetterQueue getDeadLetterQueue() {
        return (DeadLetterQueue)Kernel.get((Object)this, (String)"deadLetterQueue", (NativeType)NativeType.forClass(DeadLetterQueue.class));
    }

    @Override
    @Nullable
    public IKey getEncryptionMasterKey() {
        return (IKey)Kernel.get((Object)this, (String)"encryptionMasterKey", (NativeType)NativeType.forClass(IKey.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Queue> {
        private final Construct scope;
        private final String id;
        private QueueProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder contentBasedDeduplication(Boolean contentBasedDeduplication) {
            this.props().contentBasedDeduplication(contentBasedDeduplication);
            return this;
        }

        public Builder dataKeyReuse(Duration dataKeyReuse) {
            this.props().dataKeyReuse(dataKeyReuse);
            return this;
        }

        public Builder deadLetterQueue(DeadLetterQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder deduplicationScope(DeduplicationScope deduplicationScope) {
            this.props().deduplicationScope(deduplicationScope);
            return this;
        }

        public Builder deliveryDelay(Duration deliveryDelay) {
            this.props().deliveryDelay(deliveryDelay);
            return this;
        }

        public Builder encryption(QueueEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        public Builder encryptionMasterKey(IKey encryptionMasterKey) {
            this.props().encryptionMasterKey(encryptionMasterKey);
            return this;
        }

        public Builder fifo(Boolean fifo) {
            this.props().fifo(fifo);
            return this;
        }

        public Builder fifoThroughputLimit(FifoThroughputLimit fifoThroughputLimit) {
            this.props().fifoThroughputLimit(fifoThroughputLimit);
            return this;
        }

        public Builder maxMessageSizeBytes(Number maxMessageSizeBytes) {
            this.props().maxMessageSizeBytes(maxMessageSizeBytes);
            return this;
        }

        public Builder queueName(String queueName) {
            this.props().queueName(queueName);
            return this;
        }

        public Builder receiveMessageWaitTime(Duration receiveMessageWaitTime) {
            this.props().receiveMessageWaitTime(receiveMessageWaitTime);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder retentionPeriod(Duration retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        public Builder visibilityTimeout(Duration visibilityTimeout) {
            this.props().visibilityTimeout(visibilityTimeout);
            return this;
        }

        public Queue build() {
            return new Queue(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private QueueProps.Builder props() {
            if (this.props == null) {
                this.props = new QueueProps.Builder();
            }
            return this.props;
        }
    }
}

