/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A finding in a policy. Each finding is an actionable recommendation that can be used to improve the policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidatePolicyFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidatePolicyFinding.Builder, ValidatePolicyFinding> {
    private static final SdkField<String> FINDING_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingDetails").getter(getter(ValidatePolicyFinding::findingDetails))
            .setter(setter(Builder::findingDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingDetails").build()).build();

    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingType").getter(getter(ValidatePolicyFinding::findingTypeAsString))
            .setter(setter(Builder::findingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()).build();

    private static final SdkField<String> ISSUE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("issueCode").getter(getter(ValidatePolicyFinding::issueCode)).setter(setter(Builder::issueCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issueCode").build()).build();

    private static final SdkField<String> LEARN_MORE_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("learnMoreLink").getter(getter(ValidatePolicyFinding::learnMoreLink))
            .setter(setter(Builder::learnMoreLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("learnMoreLink").build()).build();

    private static final SdkField<List<Location>> LOCATIONS_FIELD = SdkField
            .<List<Location>> builder(MarshallingType.LIST)
            .memberName("locations")
            .getter(getter(ValidatePolicyFinding::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Location> builder(MarshallingType.SDK_POJO)
                                            .constructor(Location::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_DETAILS_FIELD,
            FINDING_TYPE_FIELD, ISSUE_CODE_FIELD, LEARN_MORE_LINK_FIELD, LOCATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String findingDetails;

    private final String findingType;

    private final String issueCode;

    private final String learnMoreLink;

    private final List<Location> locations;

    private ValidatePolicyFinding(BuilderImpl builder) {
        this.findingDetails = builder.findingDetails;
        this.findingType = builder.findingType;
        this.issueCode = builder.issueCode;
        this.learnMoreLink = builder.learnMoreLink;
        this.locations = builder.locations;
    }

    /**
     * <p>
     * A localized message that explains the finding and provides guidance on how to address it.
     * </p>
     * 
     * @return A localized message that explains the finding and provides guidance on how to address it.
     */
    public final String findingDetails() {
        return findingDetails;
    }

    /**
     * <p>
     * The impact of the finding.
     * </p>
     * <p>
     * Security warnings report when the policy allows access that we consider overly permissive.
     * </p>
     * <p>
     * Errors report when a part of the policy is not functional.
     * </p>
     * <p>
     * Warnings report non-security issues when a policy does not conform to policy writing best practices.
     * </p>
     * <p>
     * Suggestions recommend stylistic improvements in the policy that do not impact access.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link ValidatePolicyFindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The impact of the finding.</p>
     *         <p>
     *         Security warnings report when the policy allows access that we consider overly permissive.
     *         </p>
     *         <p>
     *         Errors report when a part of the policy is not functional.
     *         </p>
     *         <p>
     *         Warnings report non-security issues when a policy does not conform to policy writing best practices.
     *         </p>
     *         <p>
     *         Suggestions recommend stylistic improvements in the policy that do not impact access.
     * @see ValidatePolicyFindingType
     */
    public final ValidatePolicyFindingType findingType() {
        return ValidatePolicyFindingType.fromValue(findingType);
    }

    /**
     * <p>
     * The impact of the finding.
     * </p>
     * <p>
     * Security warnings report when the policy allows access that we consider overly permissive.
     * </p>
     * <p>
     * Errors report when a part of the policy is not functional.
     * </p>
     * <p>
     * Warnings report non-security issues when a policy does not conform to policy writing best practices.
     * </p>
     * <p>
     * Suggestions recommend stylistic improvements in the policy that do not impact access.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link ValidatePolicyFindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The impact of the finding.</p>
     *         <p>
     *         Security warnings report when the policy allows access that we consider overly permissive.
     *         </p>
     *         <p>
     *         Errors report when a part of the policy is not functional.
     *         </p>
     *         <p>
     *         Warnings report non-security issues when a policy does not conform to policy writing best practices.
     *         </p>
     *         <p>
     *         Suggestions recommend stylistic improvements in the policy that do not impact access.
     * @see ValidatePolicyFindingType
     */
    public final String findingTypeAsString() {
        return findingType;
    }

    /**
     * <p>
     * The issue code provides an identifier of the issue associated with this finding.
     * </p>
     * 
     * @return The issue code provides an identifier of the issue associated with this finding.
     */
    public final String issueCode() {
        return issueCode;
    }

    /**
     * <p>
     * A link to additional documentation about the type of finding.
     * </p>
     * 
     * @return A link to additional documentation about the type of finding.
     */
    public final String learnMoreLink() {
        return learnMoreLink;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of locations in the policy document that are related to the finding. The issue code provides a summary
     * of an issue identified by the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocations} method.
     * </p>
     * 
     * @return The list of locations in the policy document that are related to the finding. The issue code provides a
     *         summary of an issue identified by the finding.
     */
    public final List<Location> locations() {
        return locations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(findingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(issueCode());
        hashCode = 31 * hashCode + Objects.hashCode(learnMoreLink());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocations() ? locations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePolicyFinding)) {
            return false;
        }
        ValidatePolicyFinding other = (ValidatePolicyFinding) obj;
        return Objects.equals(findingDetails(), other.findingDetails())
                && Objects.equals(findingTypeAsString(), other.findingTypeAsString())
                && Objects.equals(issueCode(), other.issueCode()) && Objects.equals(learnMoreLink(), other.learnMoreLink())
                && hasLocations() == other.hasLocations() && Objects.equals(locations(), other.locations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidatePolicyFinding").add("FindingDetails", findingDetails())
                .add("FindingType", findingTypeAsString()).add("IssueCode", issueCode()).add("LearnMoreLink", learnMoreLink())
                .add("Locations", hasLocations() ? locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingDetails":
            return Optional.ofNullable(clazz.cast(findingDetails()));
        case "findingType":
            return Optional.ofNullable(clazz.cast(findingTypeAsString()));
        case "issueCode":
            return Optional.ofNullable(clazz.cast(issueCode()));
        case "learnMoreLink":
            return Optional.ofNullable(clazz.cast(learnMoreLink()));
        case "locations":
            return Optional.ofNullable(clazz.cast(locations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidatePolicyFinding, T> g) {
        return obj -> g.apply((ValidatePolicyFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidatePolicyFinding> {
        /**
         * <p>
         * A localized message that explains the finding and provides guidance on how to address it.
         * </p>
         * 
         * @param findingDetails
         *        A localized message that explains the finding and provides guidance on how to address it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingDetails(String findingDetails);

        /**
         * <p>
         * The impact of the finding.
         * </p>
         * <p>
         * Security warnings report when the policy allows access that we consider overly permissive.
         * </p>
         * <p>
         * Errors report when a part of the policy is not functional.
         * </p>
         * <p>
         * Warnings report non-security issues when a policy does not conform to policy writing best practices.
         * </p>
         * <p>
         * Suggestions recommend stylistic improvements in the policy that do not impact access.
         * </p>
         * 
         * @param findingType
         *        The impact of the finding.</p>
         *        <p>
         *        Security warnings report when the policy allows access that we consider overly permissive.
         *        </p>
         *        <p>
         *        Errors report when a part of the policy is not functional.
         *        </p>
         *        <p>
         *        Warnings report non-security issues when a policy does not conform to policy writing best practices.
         *        </p>
         *        <p>
         *        Suggestions recommend stylistic improvements in the policy that do not impact access.
         * @see ValidatePolicyFindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidatePolicyFindingType
         */
        Builder findingType(String findingType);

        /**
         * <p>
         * The impact of the finding.
         * </p>
         * <p>
         * Security warnings report when the policy allows access that we consider overly permissive.
         * </p>
         * <p>
         * Errors report when a part of the policy is not functional.
         * </p>
         * <p>
         * Warnings report non-security issues when a policy does not conform to policy writing best practices.
         * </p>
         * <p>
         * Suggestions recommend stylistic improvements in the policy that do not impact access.
         * </p>
         * 
         * @param findingType
         *        The impact of the finding.</p>
         *        <p>
         *        Security warnings report when the policy allows access that we consider overly permissive.
         *        </p>
         *        <p>
         *        Errors report when a part of the policy is not functional.
         *        </p>
         *        <p>
         *        Warnings report non-security issues when a policy does not conform to policy writing best practices.
         *        </p>
         *        <p>
         *        Suggestions recommend stylistic improvements in the policy that do not impact access.
         * @see ValidatePolicyFindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidatePolicyFindingType
         */
        Builder findingType(ValidatePolicyFindingType findingType);

        /**
         * <p>
         * The issue code provides an identifier of the issue associated with this finding.
         * </p>
         * 
         * @param issueCode
         *        The issue code provides an identifier of the issue associated with this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueCode(String issueCode);

        /**
         * <p>
         * A link to additional documentation about the type of finding.
         * </p>
         * 
         * @param learnMoreLink
         *        A link to additional documentation about the type of finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder learnMoreLink(String learnMoreLink);

        /**
         * <p>
         * The list of locations in the policy document that are related to the finding. The issue code provides a
         * summary of an issue identified by the finding.
         * </p>
         * 
         * @param locations
         *        The list of locations in the policy document that are related to the finding. The issue code provides
         *        a summary of an issue identified by the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<Location> locations);

        /**
         * <p>
         * The list of locations in the policy document that are related to the finding. The issue code provides a
         * summary of an issue identified by the finding.
         * </p>
         * 
         * @param locations
         *        The list of locations in the policy document that are related to the finding. The issue code provides
         *        a summary of an issue identified by the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Location... locations);

        /**
         * <p>
         * The list of locations in the policy document that are related to the finding. The issue code provides a
         * summary of an issue identified by the finding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.Location.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.accessanalyzer.model.Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.Location.Builder#build()} is called immediately
         * and its result is passed to {@link #locations(List<Location>)}.
         * 
         * @param locations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locations(java.util.Collection<Location>)
         */
        Builder locations(Consumer<Location.Builder>... locations);
    }

    static final class BuilderImpl implements Builder {
        private String findingDetails;

        private String findingType;

        private String issueCode;

        private String learnMoreLink;

        private List<Location> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePolicyFinding model) {
            findingDetails(model.findingDetails);
            findingType(model.findingType);
            issueCode(model.issueCode);
            learnMoreLink(model.learnMoreLink);
            locations(model.locations);
        }

        public final String getFindingDetails() {
            return findingDetails;
        }

        public final void setFindingDetails(String findingDetails) {
            this.findingDetails = findingDetails;
        }

        @Override
        public final Builder findingDetails(String findingDetails) {
            this.findingDetails = findingDetails;
            return this;
        }

        public final String getFindingType() {
            return findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        @Override
        public final Builder findingType(ValidatePolicyFindingType findingType) {
            this.findingType(findingType == null ? null : findingType.toString());
            return this;
        }

        public final String getIssueCode() {
            return issueCode;
        }

        public final void setIssueCode(String issueCode) {
            this.issueCode = issueCode;
        }

        @Override
        public final Builder issueCode(String issueCode) {
            this.issueCode = issueCode;
            return this;
        }

        public final String getLearnMoreLink() {
            return learnMoreLink;
        }

        public final void setLearnMoreLink(String learnMoreLink) {
            this.learnMoreLink = learnMoreLink;
        }

        @Override
        public final Builder learnMoreLink(String learnMoreLink) {
            this.learnMoreLink = learnMoreLink;
            return this;
        }

        public final List<Location.Builder> getLocations() {
            List<Location.Builder> result = LocationListCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<Location.BuilderImpl> locations) {
            this.locations = LocationListCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<Location> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Location... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<Location.Builder>... locations) {
            locations(Stream.of(locations).map(c -> Location.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ValidatePolicyFinding build() {
            return new ValidatePolicyFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
