/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an external access finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalAccessDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalAccessDetails.Builder, ExternalAccessDetails> {
    private static final SdkField<List<String>> ACTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("action")
            .getter(getter(ExternalAccessDetails::action))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CONDITION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("condition")
            .getter(getter(ExternalAccessDetails::condition))
            .setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPublic").getter(getter(ExternalAccessDetails::isPublic)).setter(setter(Builder::isPublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()).build();

    private static final SdkField<Map<String, String>> PRINCIPAL_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("principal")
            .getter(getter(ExternalAccessDetails::principal))
            .setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<FindingSource>> SOURCES_FIELD = SdkField
            .<List<FindingSource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(ExternalAccessDetails::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, CONDITION_FIELD,
            IS_PUBLIC_FIELD, PRINCIPAL_FIELD, SOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> action;

    private final Map<String, String> condition;

    private final Boolean isPublic;

    private final Map<String, String> principal;

    private final List<FindingSource> sources;

    private ExternalAccessDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.condition = builder.condition;
        this.isPublic = builder.isPublic;
        this.principal = builder.principal;
        this.sources = builder.sources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Action property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAction() {
        return action != null && !(action instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action in the analyzed policy statement that an external principal has permission to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAction} method.
     * </p>
     * 
     * @return The action in the analyzed policy statement that an external principal has permission to use.
     */
    public final List<String> action() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the Condition property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCondition() {
        return condition != null && !(condition instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The condition in the analyzed policy statement that resulted in an external access finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCondition} method.
     * </p>
     * 
     * @return The condition in the analyzed policy statement that resulted in an external access finding.
     */
    public final Map<String, String> condition() {
        return condition;
    }

    /**
     * <p>
     * Specifies whether the external access finding is public.
     * </p>
     * 
     * @return Specifies whether the external access finding is public.
     */
    public final Boolean isPublic() {
        return isPublic;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principal property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipal() {
        return principal != null && !(principal instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The external principal that has access to a resource within the zone of trust.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipal} method.
     * </p>
     * 
     * @return The external principal that has access to a resource within the zone of trust.
     */
    public final Map<String, String> principal() {
        return principal;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources of the external access finding. This indicates how the access that generated the finding is granted.
     * It is populated for Amazon S3 bucket findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The sources of the external access finding. This indicates how the access that generated the finding is
     *         granted. It is populated for Amazon S3 bucket findings.
     */
    public final List<FindingSource> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAction() ? action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCondition() ? condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipal() ? principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalAccessDetails)) {
            return false;
        }
        ExternalAccessDetails other = (ExternalAccessDetails) obj;
        return hasAction() == other.hasAction() && Objects.equals(action(), other.action())
                && hasCondition() == other.hasCondition() && Objects.equals(condition(), other.condition())
                && Objects.equals(isPublic(), other.isPublic()) && hasPrincipal() == other.hasPrincipal()
                && Objects.equals(principal(), other.principal()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalAccessDetails").add("Action", hasAction() ? action() : null)
                .add("Condition", hasCondition() ? condition() : null).add("IsPublic", isPublic())
                .add("Principal", hasPrincipal() ? principal() : null).add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "isPublic":
            return Optional.ofNullable(clazz.cast(isPublic()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalAccessDetails, T> g) {
        return obj -> g.apply((ExternalAccessDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalAccessDetails> {
        /**
         * <p>
         * The action in the analyzed policy statement that an external principal has permission to use.
         * </p>
         * 
         * @param action
         *        The action in the analyzed policy statement that an external principal has permission to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Collection<String> action);

        /**
         * <p>
         * The action in the analyzed policy statement that an external principal has permission to use.
         * </p>
         * 
         * @param action
         *        The action in the analyzed policy statement that an external principal has permission to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String... action);

        /**
         * <p>
         * The condition in the analyzed policy statement that resulted in an external access finding.
         * </p>
         * 
         * @param condition
         *        The condition in the analyzed policy statement that resulted in an external access finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Map<String, String> condition);

        /**
         * <p>
         * Specifies whether the external access finding is public.
         * </p>
         * 
         * @param isPublic
         *        Specifies whether the external access finding is public.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPublic(Boolean isPublic);

        /**
         * <p>
         * The external principal that has access to a resource within the zone of trust.
         * </p>
         * 
         * @param principal
         *        The external principal that has access to a resource within the zone of trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(Map<String, String> principal);

        /**
         * <p>
         * The sources of the external access finding. This indicates how the access that generated the finding is
         * granted. It is populated for Amazon S3 bucket findings.
         * </p>
         * 
         * @param sources
         *        The sources of the external access finding. This indicates how the access that generated the finding
         *        is granted. It is populated for Amazon S3 bucket findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<FindingSource> sources);

        /**
         * <p>
         * The sources of the external access finding. This indicates how the access that generated the finding is
         * granted. It is populated for Amazon S3 bucket findings.
         * </p>
         * 
         * @param sources
         *        The sources of the external access finding. This indicates how the access that generated the finding
         *        is granted. It is populated for Amazon S3 bucket findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(FindingSource... sources);

        /**
         * <p>
         * The sources of the external access finding. This indicates how the access that generated the finding is
         * granted. It is populated for Amazon S3 bucket findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.FindingSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.accessanalyzer.model.FindingSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.FindingSource.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<FindingSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.FindingSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<FindingSource>)
         */
        Builder sources(Consumer<FindingSource.Builder>... sources);
    }

    static final class BuilderImpl implements Builder {
        private List<String> action = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> condition = DefaultSdkAutoConstructMap.getInstance();

        private Boolean isPublic;

        private Map<String, String> principal = DefaultSdkAutoConstructMap.getInstance();

        private List<FindingSource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalAccessDetails model) {
            action(model.action);
            condition(model.condition);
            isPublic(model.isPublic);
            principal(model.principal);
            sources(model.sources);
        }

        public final Collection<String> getAction() {
            if (action instanceof SdkAutoConstructList) {
                return null;
            }
            return action;
        }

        public final void setAction(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String... action) {
            action(Arrays.asList(action));
            return this;
        }

        public final Map<String, String> getCondition() {
            if (condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return condition;
        }

        public final void setCondition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
        }

        @Override
        public final Builder condition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
            return this;
        }

        public final Boolean getIsPublic() {
            return isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final Map<String, String> getPrincipal() {
            if (principal instanceof SdkAutoConstructMap) {
                return null;
            }
            return principal;
        }

        public final void setPrincipal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
        }

        @Override
        public final Builder principal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
            return this;
        }

        public final List<FindingSource.Builder> getSources() {
            List<FindingSource.Builder> result = FindingSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<FindingSource.BuilderImpl> sources) {
            this.sources = FindingSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<FindingSource> sources) {
            this.sources = FindingSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(FindingSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<FindingSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> FindingSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExternalAccessDetails build() {
            return new ExternalAccessDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
