/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a structure that expresses the Region for a given account, consisting of a name and opt-in status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Region implements SdkPojo, Serializable, ToCopyableBuilder<Region.Builder, Region> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(Region::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> REGION_OPT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionOptStatus").getter(getter(Region::regionOptStatusAsString))
            .setter(setter(Builder::regionOptStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionOptStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            REGION_OPT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final String regionOptStatus;

    private Region(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.regionOptStatus = builder.regionOptStatus;
    }

    /**
     * <p>
     * The Region code of a given Region (for example, <code>us-east-1</code>).
     * </p>
     * 
     * @return The Region code of a given Region (for example, <code>us-east-1</code>).
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * One of potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling, Enabled_By_Default).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #regionOptStatus}
     * will return {@link RegionOptStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #regionOptStatusAsString}.
     * </p>
     * 
     * @return One of potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling,
     *         Enabled_By_Default).
     * @see RegionOptStatus
     */
    public final RegionOptStatus regionOptStatus() {
        return RegionOptStatus.fromValue(regionOptStatus);
    }

    /**
     * <p>
     * One of potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling, Enabled_By_Default).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #regionOptStatus}
     * will return {@link RegionOptStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #regionOptStatusAsString}.
     * </p>
     * 
     * @return One of potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling,
     *         Enabled_By_Default).
     * @see RegionOptStatus
     */
    public final String regionOptStatusAsString() {
        return regionOptStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(regionOptStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region) obj;
        return Objects.equals(regionName(), other.regionName())
                && Objects.equals(regionOptStatusAsString(), other.regionOptStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Region").add("RegionName", regionName()).add("RegionOptStatus", regionOptStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "RegionOptStatus":
            return Optional.ofNullable(clazz.cast(regionOptStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Region, T> g) {
        return obj -> g.apply((Region) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Region> {
        /**
         * <p>
         * The Region code of a given Region (for example, <code>us-east-1</code>).
         * </p>
         * 
         * @param regionName
         *        The Region code of a given Region (for example, <code>us-east-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * One of potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling, Enabled_By_Default).
         * </p>
         * 
         * @param regionOptStatus
         *        One of potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling,
         *        Enabled_By_Default).
         * @see RegionOptStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionOptStatus
         */
        Builder regionOptStatus(String regionOptStatus);

        /**
         * <p>
         * One of potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling, Enabled_By_Default).
         * </p>
         * 
         * @param regionOptStatus
         *        One of potential statuses a Region can undergo (Enabled, Enabling, Disabled, Disabling,
         *        Enabled_By_Default).
         * @see RegionOptStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionOptStatus
         */
        Builder regionOptStatus(RegionOptStatus regionOptStatus);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private String regionOptStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            regionName(model.regionName);
            regionOptStatus(model.regionOptStatus);
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getRegionOptStatus() {
            return regionOptStatus;
        }

        public final void setRegionOptStatus(String regionOptStatus) {
            this.regionOptStatus = regionOptStatus;
        }

        @Override
        public final Builder regionOptStatus(String regionOptStatus) {
            this.regionOptStatus = regionOptStatus;
            return this;
        }

        @Override
        public final Builder regionOptStatus(RegionOptStatus regionOptStatus) {
            this.regionOptStatus(regionOptStatus == null ? null : regionOptStatus.toString());
            return this;
        }

        @Override
        public Region build() {
            return new Region(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
