/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the certificate extensions to be added to the certificate signing request (CSR).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CsrExtensions implements SdkPojo, Serializable, ToCopyableBuilder<CsrExtensions.Builder, CsrExtensions> {
    private static final SdkField<KeyUsage> KEY_USAGE_FIELD = SdkField.<KeyUsage> builder(MarshallingType.SDK_POJO)
            .memberName("KeyUsage").getter(getter(CsrExtensions::keyUsage)).setter(setter(Builder::keyUsage))
            .constructor(KeyUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()).build();

    private static final SdkField<List<AccessDescription>> SUBJECT_INFORMATION_ACCESS_FIELD = SdkField
            .<List<AccessDescription>> builder(MarshallingType.LIST)
            .memberName("SubjectInformationAccess")
            .getter(getter(CsrExtensions::subjectInformationAccess))
            .setter(setter(Builder::subjectInformationAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectInformationAccess").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_USAGE_FIELD,
            SUBJECT_INFORMATION_ACCESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final KeyUsage keyUsage;

    private final List<AccessDescription> subjectInformationAccess;

    private CsrExtensions(BuilderImpl builder) {
        this.keyUsage = builder.keyUsage;
        this.subjectInformationAccess = builder.subjectInformationAccess;
    }

    /**
     * <p>
     * Indicates the purpose of the certificate and of the key contained in the certificate.
     * </p>
     * 
     * @return Indicates the purpose of the certificate and of the key contained in the certificate.
     */
    public final KeyUsage keyUsage() {
        return keyUsage;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubjectInformationAccess property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSubjectInformationAccess() {
        return subjectInformationAccess != null && !(subjectInformationAccess instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and
     * policy. For more information, see <a href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject
     * Information Access</a> in RFC 5280.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubjectInformationAccess} method.
     * </p>
     * 
     * @return For CA certificates, provides a path to additional information pertaining to the CA, such as revocation
     *         and policy. For more information, see <a
     *         href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in
     *         RFC 5280.
     */
    public final List<AccessDescription> subjectInformationAccess() {
        return subjectInformationAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyUsage());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubjectInformationAccess() ? subjectInformationAccess() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsrExtensions)) {
            return false;
        }
        CsrExtensions other = (CsrExtensions) obj;
        return Objects.equals(keyUsage(), other.keyUsage())
                && hasSubjectInformationAccess() == other.hasSubjectInformationAccess()
                && Objects.equals(subjectInformationAccess(), other.subjectInformationAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CsrExtensions").add("KeyUsage", keyUsage())
                .add("SubjectInformationAccess", hasSubjectInformationAccess() ? subjectInformationAccess() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyUsage":
            return Optional.ofNullable(clazz.cast(keyUsage()));
        case "SubjectInformationAccess":
            return Optional.ofNullable(clazz.cast(subjectInformationAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CsrExtensions, T> g) {
        return obj -> g.apply((CsrExtensions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CsrExtensions> {
        /**
         * <p>
         * Indicates the purpose of the certificate and of the key contained in the certificate.
         * </p>
         * 
         * @param keyUsage
         *        Indicates the purpose of the certificate and of the key contained in the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyUsage(KeyUsage keyUsage);

        /**
         * <p>
         * Indicates the purpose of the certificate and of the key contained in the certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyUsage.Builder} avoiding the need to
         * create one manually via {@link KeyUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyUsage.Builder#build()} is called immediately and its result is
         * passed to {@link #keyUsage(KeyUsage)}.
         * 
         * @param keyUsage
         *        a consumer that will call methods on {@link KeyUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyUsage(KeyUsage)
         */
        default Builder keyUsage(Consumer<KeyUsage.Builder> keyUsage) {
            return keyUsage(KeyUsage.builder().applyMutation(keyUsage).build());
        }

        /**
         * <p>
         * For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and
         * policy. For more information, see <a
         * href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in RFC
         * 5280.
         * </p>
         * 
         * @param subjectInformationAccess
         *        For CA certificates, provides a path to additional information pertaining to the CA, such as
         *        revocation and policy. For more information, see <a
         *        href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in
         *        RFC 5280.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectInformationAccess(Collection<AccessDescription> subjectInformationAccess);

        /**
         * <p>
         * For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and
         * policy. For more information, see <a
         * href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in RFC
         * 5280.
         * </p>
         * 
         * @param subjectInformationAccess
         *        For CA certificates, provides a path to additional information pertaining to the CA, such as
         *        revocation and policy. For more information, see <a
         *        href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in
         *        RFC 5280.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectInformationAccess(AccessDescription... subjectInformationAccess);

        /**
         * <p>
         * For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and
         * policy. For more information, see <a
         * href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in RFC
         * 5280.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.acmpca.model.AccessDescription.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.acmpca.model.AccessDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.acmpca.model.AccessDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #subjectInformationAccess(List<AccessDescription>)}.
         * 
         * @param subjectInformationAccess
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.acmpca.model.AccessDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subjectInformationAccess(java.util.Collection<AccessDescription>)
         */
        Builder subjectInformationAccess(Consumer<AccessDescription.Builder>... subjectInformationAccess);
    }

    static final class BuilderImpl implements Builder {
        private KeyUsage keyUsage;

        private List<AccessDescription> subjectInformationAccess = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CsrExtensions model) {
            keyUsage(model.keyUsage);
            subjectInformationAccess(model.subjectInformationAccess);
        }

        public final KeyUsage.Builder getKeyUsage() {
            return keyUsage != null ? keyUsage.toBuilder() : null;
        }

        public final void setKeyUsage(KeyUsage.BuilderImpl keyUsage) {
            this.keyUsage = keyUsage != null ? keyUsage.build() : null;
        }

        @Override
        public final Builder keyUsage(KeyUsage keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        public final List<AccessDescription.Builder> getSubjectInformationAccess() {
            List<AccessDescription.Builder> result = AccessDescriptionListCopier.copyToBuilder(this.subjectInformationAccess);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubjectInformationAccess(Collection<AccessDescription.BuilderImpl> subjectInformationAccess) {
            this.subjectInformationAccess = AccessDescriptionListCopier.copyFromBuilder(subjectInformationAccess);
        }

        @Override
        public final Builder subjectInformationAccess(Collection<AccessDescription> subjectInformationAccess) {
            this.subjectInformationAccess = AccessDescriptionListCopier.copy(subjectInformationAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectInformationAccess(AccessDescription... subjectInformationAccess) {
            subjectInformationAccess(Arrays.asList(subjectInformationAccess));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectInformationAccess(Consumer<AccessDescription.Builder>... subjectInformationAccess) {
            subjectInformationAccess(Stream.of(subjectInformationAccess)
                    .map(c -> AccessDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CsrExtensions build() {
            return new CsrExtensions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
