/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a summary of the properties of a scraper.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScraperSummary implements SdkPojo, Serializable, ToCopyableBuilder<ScraperSummary.Builder, ScraperSummary> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(ScraperSummary::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scraperId").getter(getter(ScraperSummary::scraperId)).setter(setter(Builder::scraperId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ScraperSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ScraperSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<ScraperStatus> STATUS_FIELD = SdkField.<ScraperStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(ScraperSummary::status)).setter(setter(Builder::status))
            .constructor(ScraperStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ScraperSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(ScraperSummary::lastModifiedAt)).setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ScraperSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(ScraperSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(ScraperSummary::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("destination").getter(getter(ScraperSummary::destination)).setter(setter(Builder::destination))
            .constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SCRAPER_ID_FIELD,
            ARN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD, TAGS_FIELD, STATUS_REASON_FIELD,
            SOURCE_FIELD, DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final String scraperId;

    private final String arn;

    private final String roleArn;

    private final ScraperStatus status;

    private final Instant createdAt;

    private final Instant lastModifiedAt;

    private final Map<String, String> tags;

    private final String statusReason;

    private final Source source;

    private final Destination destination;

    private ScraperSummary(BuilderImpl builder) {
        this.alias = builder.alias;
        this.scraperId = builder.scraperId;
        this.arn = builder.arn;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.tags = builder.tags;
        this.statusReason = builder.statusReason;
        this.source = builder.source;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * Alias of this scraper.
     * </p>
     * 
     * @return Alias of this scraper.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * Unique string identifying this scraper.
     * </p>
     * 
     * @return Unique string identifying this scraper.
     */
    public final String scraperId() {
        return scraperId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this scraper.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this scraper.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to dsicover, collect,
     * and produce metrics on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to dsicover,
     *         collect, and produce metrics on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of this scraper.
     * </p>
     * 
     * @return The status of this scraper.
     */
    public final ScraperStatus status() {
        return status;
    }

    /**
     * <p>
     * The time when the scraper was created.
     * </p>
     * 
     * @return The time when the scraper was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time when the scraper was last modified.
     * </p>
     * 
     * @return The time when the scraper was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of this scraper.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of this scraper.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The reason for failure if any.
     * </p>
     * 
     * @return The reason for failure if any.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The source that the scraper is discovering and collecting metrics from.
     * </p>
     * 
     * @return The source that the scraper is discovering and collecting metrics from.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * The destination that the scraper is producing metrics to.
     * </p>
     * 
     * @return The destination that the scraper is producing metrics to.
     */
    public final Destination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(scraperId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScraperSummary)) {
            return false;
        }
        ScraperSummary other = (ScraperSummary) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(scraperId(), other.scraperId())
                && Objects.equals(arn(), other.arn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(status(), other.status()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScraperSummary").add("Alias", alias()).add("ScraperId", scraperId()).add("Arn", arn())
                .add("RoleArn", roleArn()).add("Status", status()).add("CreatedAt", createdAt())
                .add("LastModifiedAt", lastModifiedAt()).add("Tags", hasTags() ? tags() : null)
                .add("StatusReason", statusReason()).add("Source", source()).add("Destination", destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "scraperId":
            return Optional.ofNullable(clazz.cast(scraperId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScraperSummary, T> g) {
        return obj -> g.apply((ScraperSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScraperSummary> {
        /**
         * <p>
         * Alias of this scraper.
         * </p>
         * 
         * @param alias
         *        Alias of this scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * Unique string identifying this scraper.
         * </p>
         * 
         * @param scraperId
         *        Unique string identifying this scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraperId(String scraperId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of this scraper.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of this scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to dsicover,
         * collect, and produce metrics on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to dsicover,
         *        collect, and produce metrics on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of this scraper.
         * </p>
         * 
         * @param status
         *        The status of this scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ScraperStatus status);

        /**
         * <p>
         * The status of this scraper.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScraperStatus.Builder} avoiding the need
         * to create one manually via {@link ScraperStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScraperStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ScraperStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ScraperStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ScraperStatus)
         */
        default Builder status(Consumer<ScraperStatus.Builder> status) {
            return status(ScraperStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The time when the scraper was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the scraper was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time when the scraper was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The time when the scraper was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The tags of this scraper.
         * </p>
         * 
         * @param tags
         *        The tags of this scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The reason for failure if any.
         * </p>
         * 
         * @param statusReason
         *        The reason for failure if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The source that the scraper is discovering and collecting metrics from.
         * </p>
         * 
         * @param source
         *        The source that the scraper is discovering and collecting metrics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The source that the scraper is discovering and collecting metrics from.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The destination that the scraper is producing metrics to.
         * </p>
         * 
         * @param destination
         *        The destination that the scraper is producing metrics to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The destination that the scraper is producing metrics to.
         * </p>
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private String scraperId;

        private String arn;

        private String roleArn;

        private ScraperStatus status;

        private Instant createdAt;

        private Instant lastModifiedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String statusReason;

        private Source source;

        private Destination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ScraperSummary model) {
            alias(model.alias);
            scraperId(model.scraperId);
            arn(model.arn);
            roleArn(model.roleArn);
            status(model.status);
            createdAt(model.createdAt);
            lastModifiedAt(model.lastModifiedAt);
            tags(model.tags);
            statusReason(model.statusReason);
            source(model.source);
            destination(model.destination);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getScraperId() {
            return scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ScraperStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ScraperStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ScraperStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public ScraperSummary build() {
            return new ScraperSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
