/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A nested UI configuration within a parent <code>Component</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentChild implements SdkPojo, Serializable, ToCopyableBuilder<ComponentChild.Builder, ComponentChild> {
    private static final SdkField<List<ComponentChild>> CHILDREN_FIELD = SdkField
            .<List<ComponentChild>> builder(MarshallingType.LIST)
            .memberName("children")
            .getter(getter(ComponentChild::children))
            .setter(setter(Builder::children))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("children").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentChild> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentChild::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentType").getter(getter(ComponentChild::componentType)).setter(setter(Builder::componentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build()).build();

    private static final SdkField<Map<String, ComponentEvent>> EVENTS_FIELD = SdkField
            .<Map<String, ComponentEvent>> builder(MarshallingType.MAP)
            .memberName("events")
            .getter(getter(ComponentChild::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ComponentChild::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, ComponentProperty>> PROPERTIES_FIELD = SdkField
            .<Map<String, ComponentProperty>> builder(MarshallingType.MAP)
            .memberName("properties")
            .getter(getter(ComponentChild::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceId").getter(getter(ComponentChild::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHILDREN_FIELD,
            COMPONENT_TYPE_FIELD, EVENTS_FIELD, NAME_FIELD, PROPERTIES_FIELD, SOURCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ComponentChild> children;

    private final String componentType;

    private final Map<String, ComponentEvent> events;

    private final String name;

    private final Map<String, ComponentProperty> properties;

    private final String sourceId;

    private ComponentChild(BuilderImpl builder) {
        this.children = builder.children;
        this.componentType = builder.componentType;
        this.events = builder.events;
        this.name = builder.name;
        this.properties = builder.properties;
        this.sourceId = builder.sourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Children property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChildren() {
        return children != null && !(children instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>ComponentChild</code> instances for this component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChildren} method.
     * </p>
     * 
     * @return The list of <code>ComponentChild</code> instances for this component.
     */
    public final List<ComponentChild> children() {
        return children;
    }

    /**
     * <p>
     * The type of the child component.
     * </p>
     * 
     * @return The type of the child component.
     */
    public final String componentType() {
        return componentType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Describes the events that can be raised on the child component. Use for the workflow feature in Amplify Studio
     * that allows you to bind events and actions to components.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return Describes the events that can be raised on the child component. Use for the workflow feature in Amplify
     *         Studio that allows you to bind events and actions to components.
     */
    public final Map<String, ComponentEvent> events() {
        return events;
    }

    /**
     * <p>
     * The name of the child component.
     * </p>
     * 
     * @return The name of the child component.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Describes the properties of the child component. You can't specify <code>tags</code> as a valid property for
     * <code>properties</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return Describes the properties of the child component. You can't specify <code>tags</code> as a valid property
     *         for <code>properties</code>.
     */
    public final Map<String, ComponentProperty> properties() {
        return properties;
    }

    /**
     * <p>
     * The unique ID of the child component in its original source system, such as Figma.
     * </p>
     * 
     * @return The unique ID of the child component in its original source system, such as Figma.
     */
    public final String sourceId() {
        return sourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasChildren() ? children() : null);
        hashCode = 31 * hashCode + Objects.hashCode(componentType());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentChild)) {
            return false;
        }
        ComponentChild other = (ComponentChild) obj;
        return hasChildren() == other.hasChildren() && Objects.equals(children(), other.children())
                && Objects.equals(componentType(), other.componentType()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events()) && Objects.equals(name(), other.name())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && Objects.equals(sourceId(), other.sourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentChild").add("Children", hasChildren() ? children() : null)
                .add("ComponentType", componentType()).add("Events", hasEvents() ? events() : null).add("Name", name())
                .add("Properties", hasProperties() ? properties() : null).add("SourceId", sourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "children":
            return Optional.ofNullable(clazz.cast(children()));
        case "componentType":
            return Optional.ofNullable(clazz.cast(componentType()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "sourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentChild, T> g) {
        return obj -> g.apply((ComponentChild) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentChild> {
        /**
         * <p>
         * The list of <code>ComponentChild</code> instances for this component.
         * </p>
         * 
         * @param children
         *        The list of <code>ComponentChild</code> instances for this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(Collection<ComponentChild> children);

        /**
         * <p>
         * The list of <code>ComponentChild</code> instances for this component.
         * </p>
         * 
         * @param children
         *        The list of <code>ComponentChild</code> instances for this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(ComponentChild... children);

        /**
         * <p>
         * The list of <code>ComponentChild</code> instances for this component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild.Builder#build()} is called
         * immediately and its result is passed to {@link #children(List<ComponentChild>)}.
         * 
         * @param children
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #children(java.util.Collection<ComponentChild>)
         */
        Builder children(Consumer<Builder>... children);

        /**
         * <p>
         * The type of the child component.
         * </p>
         * 
         * @param componentType
         *        The type of the child component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentType(String componentType);

        /**
         * <p>
         * Describes the events that can be raised on the child component. Use for the workflow feature in Amplify
         * Studio that allows you to bind events and actions to components.
         * </p>
         * 
         * @param events
         *        Describes the events that can be raised on the child component. Use for the workflow feature in
         *        Amplify Studio that allows you to bind events and actions to components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Map<String, ComponentEvent> events);

        /**
         * <p>
         * The name of the child component.
         * </p>
         * 
         * @param name
         *        The name of the child component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes the properties of the child component. You can't specify <code>tags</code> as a valid property for
         * <code>properties</code>.
         * </p>
         * 
         * @param properties
         *        Describes the properties of the child component. You can't specify <code>tags</code> as a valid
         *        property for <code>properties</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, ComponentProperty> properties);

        /**
         * <p>
         * The unique ID of the child component in its original source system, such as Figma.
         * </p>
         * 
         * @param sourceId
         *        The unique ID of the child component in its original source system, such as Figma.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);
    }

    static final class BuilderImpl implements Builder {
        private List<ComponentChild> children = DefaultSdkAutoConstructList.getInstance();

        private String componentType;

        private Map<String, ComponentEvent> events = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private Map<String, ComponentProperty> properties = DefaultSdkAutoConstructMap.getInstance();

        private String sourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentChild model) {
            children(model.children);
            componentType(model.componentType);
            events(model.events);
            name(model.name);
            properties(model.properties);
            sourceId(model.sourceId);
        }

        public final List<Builder> getChildren() {
            List<Builder> result = ComponentChildListCopier.copyToBuilder(this.children);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildren(Collection<BuilderImpl> children) {
            this.children = ComponentChildListCopier.copyFromBuilder(children);
        }

        @Override
        public final Builder children(Collection<ComponentChild> children) {
            this.children = ComponentChildListCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(ComponentChild... children) {
            children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<Builder>... children) {
            children(Stream.of(children).map(c -> ComponentChild.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getComponentType() {
            return componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final Map<String, ComponentEvent.Builder> getEvents() {
            Map<String, ComponentEvent.Builder> result = ComponentEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEvents(Map<String, ComponentEvent.BuilderImpl> events) {
            this.events = ComponentEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Map<String, ComponentEvent> events) {
            this.events = ComponentEventsCopier.copy(events);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, ComponentProperty.Builder> getProperties() {
            Map<String, ComponentProperty.Builder> result = ComponentPropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, ComponentProperty.BuilderImpl> properties) {
            this.properties = ComponentPropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, ComponentProperty> properties) {
            this.properties = ComponentPropertiesCopier.copy(properties);
            return this;
        }

        public final String getSourceId() {
            return sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @Override
        public ComponentChild build() {
            return new ComponentChild(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
