/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for a button UI element that is a part of a form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormButton implements SdkPojo, Serializable, ToCopyableBuilder<FormButton.Builder, FormButton> {
    private static final SdkField<String> CHILDREN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("children").getter(getter(FormButton::children)).setter(setter(Builder::children))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("children").build()).build();

    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excluded").getter(getter(FormButton::excluded)).setter(setter(Builder::excluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()).build();

    private static final SdkField<FieldPosition> POSITION_FIELD = SdkField.<FieldPosition> builder(MarshallingType.SDK_POJO)
            .memberName("position").getter(getter(FormButton::position)).setter(setter(Builder::position))
            .constructor(FieldPosition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHILDREN_FIELD,
            EXCLUDED_FIELD, POSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String children;

    private final Boolean excluded;

    private final FieldPosition position;

    private FormButton(BuilderImpl builder) {
        this.children = builder.children;
        this.excluded = builder.excluded;
        this.position = builder.position;
    }

    /**
     * <p>
     * Describes the button's properties.
     * </p>
     * 
     * @return Describes the button's properties.
     */
    public final String children() {
        return children;
    }

    /**
     * <p>
     * Specifies whether the button is visible on the form.
     * </p>
     * 
     * @return Specifies whether the button is visible on the form.
     */
    public final Boolean excluded() {
        return excluded;
    }

    /**
     * <p>
     * The position of the button.
     * </p>
     * 
     * @return The position of the button.
     */
    public final FieldPosition position() {
        return position;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(children());
        hashCode = 31 * hashCode + Objects.hashCode(excluded());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormButton)) {
            return false;
        }
        FormButton other = (FormButton) obj;
        return Objects.equals(children(), other.children()) && Objects.equals(excluded(), other.excluded())
                && Objects.equals(position(), other.position());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormButton").add("Children", children()).add("Excluded", excluded()).add("Position", position())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "children":
            return Optional.ofNullable(clazz.cast(children()));
        case "excluded":
            return Optional.ofNullable(clazz.cast(excluded()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormButton, T> g) {
        return obj -> g.apply((FormButton) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormButton> {
        /**
         * <p>
         * Describes the button's properties.
         * </p>
         * 
         * @param children
         *        Describes the button's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(String children);

        /**
         * <p>
         * Specifies whether the button is visible on the form.
         * </p>
         * 
         * @param excluded
         *        Specifies whether the button is visible on the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excluded(Boolean excluded);

        /**
         * <p>
         * The position of the button.
         * </p>
         * 
         * @param position
         *        The position of the button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(FieldPosition position);

        /**
         * <p>
         * The position of the button.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldPosition.Builder} avoiding the need
         * to create one manually via {@link FieldPosition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldPosition.Builder#build()} is called immediately and its
         * result is passed to {@link #position(FieldPosition)}.
         * 
         * @param position
         *        a consumer that will call methods on {@link FieldPosition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #position(FieldPosition)
         */
        default Builder position(Consumer<FieldPosition.Builder> position) {
            return position(FieldPosition.builder().applyMutation(position).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String children;

        private Boolean excluded;

        private FieldPosition position;

        private BuilderImpl() {
        }

        private BuilderImpl(FormButton model) {
            children(model.children);
            excluded(model.excluded);
            position(model.position);
        }

        public final String getChildren() {
            return children;
        }

        public final void setChildren(String children) {
            this.children = children;
        }

        @Override
        public final Builder children(String children) {
            this.children = children;
            return this;
        }

        public final Boolean getExcluded() {
            return excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final FieldPosition.Builder getPosition() {
            return position != null ? position.toBuilder() : null;
        }

        public final void setPosition(FieldPosition.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(FieldPosition position) {
            this.position = position;
            return this;
        }

        @Override
        public FormButton build() {
            return new FormButton(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
