/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFormRequest extends AmplifyUiBuilderRequest implements
        ToCopyableBuilder<UpdateFormRequest.Builder, UpdateFormRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(UpdateFormRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateFormRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(UpdateFormRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateFormRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<UpdateFormData> UPDATED_FORM_FIELD = SdkField
            .<UpdateFormData> builder(MarshallingType.SDK_POJO)
            .memberName("updatedForm")
            .getter(getter(UpdateFormRequest::updatedForm))
            .setter(setter(Builder::updatedForm))
            .constructor(UpdateFormData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedForm").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            CLIENT_TOKEN_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, UPDATED_FORM_FIELD));

    private final String appId;

    private final String clientToken;

    private final String environmentName;

    private final String id;

    private final UpdateFormData updatedForm;

    private UpdateFormRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.clientToken = builder.clientToken;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.updatedForm = builder.updatedForm;
    }

    /**
     * <p>
     * The unique ID for the Amplify app.
     * </p>
     * 
     * @return The unique ID for the Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The unique client token.
     * </p>
     * 
     * @return The unique client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the backend environment that is part of the Amplify app.
     * </p>
     * 
     * @return The name of the backend environment that is part of the Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The unique ID for the form.
     * </p>
     * 
     * @return The unique ID for the form.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The request accepts the following data in JSON format.
     * </p>
     * 
     * @return The request accepts the following data in JSON format.
     */
    public final UpdateFormData updatedForm() {
        return updatedForm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(updatedForm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFormRequest)) {
            return false;
        }
        UpdateFormRequest other = (UpdateFormRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(environmentName(), other.environmentName()) && Objects.equals(id(), other.id())
                && Objects.equals(updatedForm(), other.updatedForm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFormRequest").add("AppId", appId()).add("ClientToken", clientToken())
                .add("EnvironmentName", environmentName()).add("Id", id()).add("UpdatedForm", updatedForm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "updatedForm":
            return Optional.ofNullable(clazz.cast(updatedForm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFormRequest, T> g) {
        return obj -> g.apply((UpdateFormRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyUiBuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFormRequest> {
        /**
         * <p>
         * The unique ID for the Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The unique client token.
         * </p>
         * 
         * @param clientToken
         *        The unique client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the backend environment that is part of the Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name of the backend environment that is part of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The unique ID for the form.
         * </p>
         * 
         * @param id
         *        The unique ID for the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The request accepts the following data in JSON format.
         * </p>
         * 
         * @param updatedForm
         *        The request accepts the following data in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedForm(UpdateFormData updatedForm);

        /**
         * <p>
         * The request accepts the following data in JSON format.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateFormData.Builder} avoiding the need
         * to create one manually via {@link UpdateFormData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateFormData.Builder#build()} is called immediately and its
         * result is passed to {@link #updatedForm(UpdateFormData)}.
         * 
         * @param updatedForm
         *        a consumer that will call methods on {@link UpdateFormData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updatedForm(UpdateFormData)
         */
        default Builder updatedForm(Consumer<UpdateFormData.Builder> updatedForm) {
            return updatedForm(UpdateFormData.builder().applyMutation(updatedForm).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyUiBuilderRequest.BuilderImpl implements Builder {
        private String appId;

        private String clientToken;

        private String environmentName;

        private String id;

        private UpdateFormData updatedForm;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFormRequest model) {
            super(model);
            appId(model.appId);
            clientToken(model.clientToken);
            environmentName(model.environmentName);
            id(model.id);
            updatedForm(model.updatedForm);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final UpdateFormData.Builder getUpdatedForm() {
            return updatedForm != null ? updatedForm.toBuilder() : null;
        }

        public final void setUpdatedForm(UpdateFormData.BuilderImpl updatedForm) {
            this.updatedForm = updatedForm != null ? updatedForm.build() : null;
        }

        @Override
        public final Builder updatedForm(UpdateFormData updatedForm) {
            this.updatedForm = updatedForm;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFormRequest build() {
            return new UpdateFormRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
