/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Saves the data binding information for a theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThemeData implements SdkPojo, Serializable, ToCopyableBuilder<UpdateThemeData.Builder, UpdateThemeData> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateThemeData::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateThemeData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<ThemeValues>> VALUES_FIELD = SdkField
            .<List<ThemeValues>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(UpdateThemeData::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeValues> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeValues::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ThemeValues>> OVERRIDES_FIELD = SdkField
            .<List<ThemeValues>> builder(MarshallingType.LIST)
            .memberName("overrides")
            .getter(getter(UpdateThemeData::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeValues> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeValues::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            VALUES_FIELD, OVERRIDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final List<ThemeValues> values;

    private final List<ThemeValues> overrides;

    private UpdateThemeData(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.values = builder.values;
        this.overrides = builder.overrides;
    }

    /**
     * <p>
     * The unique ID of the theme to update.
     * </p>
     * 
     * @return The unique ID of the theme to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the theme to update.
     * </p>
     * 
     * @return The name of the theme to update.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that define the theme's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of key-value pairs that define the theme's properties.
     */
    public final List<ThemeValues> values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the properties that can be overriden to customize the theme.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return Describes the properties that can be overriden to customize the theme.
     */
    public final List<ThemeValues> overrides() {
        return overrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThemeData)) {
            return false;
        }
        UpdateThemeData other = (UpdateThemeData) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && hasOverrides() == other.hasOverrides()
                && Objects.equals(overrides(), other.overrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateThemeData").add("Id", id()).add("Name", name())
                .add("Values", hasValues() ? values() : null).add("Overrides", hasOverrides() ? overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThemeData, T> g) {
        return obj -> g.apply((UpdateThemeData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateThemeData> {
        /**
         * <p>
         * The unique ID of the theme to update.
         * </p>
         * 
         * @param id
         *        The unique ID of the theme to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the theme to update.
         * </p>
         * 
         * @param name
         *        The name of the theme to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of key-value pairs that define the theme's properties.
         * </p>
         * 
         * @param values
         *        A list of key-value pairs that define the theme's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<ThemeValues> values);

        /**
         * <p>
         * A list of key-value pairs that define the theme's properties.
         * </p>
         * 
         * @param values
         *        A list of key-value pairs that define the theme's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(ThemeValues... values);

        /**
         * <p>
         * A list of key-value pairs that define the theme's properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder#build()} is called
         * immediately and its result is passed to {@link #values(List<ThemeValues>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<ThemeValues>)
         */
        Builder values(Consumer<ThemeValues.Builder>... values);

        /**
         * <p>
         * Describes the properties that can be overriden to customize the theme.
         * </p>
         * 
         * @param overrides
         *        Describes the properties that can be overriden to customize the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Collection<ThemeValues> overrides);

        /**
         * <p>
         * Describes the properties that can be overriden to customize the theme.
         * </p>
         * 
         * @param overrides
         *        Describes the properties that can be overriden to customize the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(ThemeValues... overrides);

        /**
         * <p>
         * Describes the properties that can be overriden to customize the theme.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder#build()} is called
         * immediately and its result is passed to {@link #overrides(List<ThemeValues>)}.
         * 
         * @param overrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(java.util.Collection<ThemeValues>)
         */
        Builder overrides(Consumer<ThemeValues.Builder>... overrides);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private List<ThemeValues> values = DefaultSdkAutoConstructList.getInstance();

        private List<ThemeValues> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThemeData model) {
            id(model.id);
            name(model.name);
            values(model.values);
            overrides(model.overrides);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ThemeValues.Builder> getValues() {
            List<ThemeValues.Builder> result = ThemeValuesListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<ThemeValues.BuilderImpl> values) {
            this.values = ThemeValuesListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<ThemeValues> values) {
            this.values = ThemeValuesListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(ThemeValues... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<ThemeValues.Builder>... values) {
            values(Stream.of(values).map(c -> ThemeValues.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThemeValues.Builder> getOverrides() {
            List<ThemeValues.Builder> result = ThemeValuesListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<ThemeValues.BuilderImpl> overrides) {
            this.overrides = ThemeValuesListCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<ThemeValues> overrides) {
            this.overrides = ThemeValuesListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(ThemeValues... overrides) {
            overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<ThemeValues.Builder>... overrides) {
            overrides(Stream.of(overrides).map(c -> ThemeValues.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateThemeData build() {
            return new UpdateThemeData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
