/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the GraphQL configuration for an API for a code generation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GraphQLRenderConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GraphQLRenderConfig.Builder, GraphQLRenderConfig> {
    private static final SdkField<String> TYPES_FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typesFilePath").getter(getter(GraphQLRenderConfig::typesFilePath))
            .setter(setter(Builder::typesFilePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typesFilePath").build()).build();

    private static final SdkField<String> QUERIES_FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queriesFilePath").getter(getter(GraphQLRenderConfig::queriesFilePath))
            .setter(setter(Builder::queriesFilePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queriesFilePath").build()).build();

    private static final SdkField<String> MUTATIONS_FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mutationsFilePath").getter(getter(GraphQLRenderConfig::mutationsFilePath))
            .setter(setter(Builder::mutationsFilePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutationsFilePath").build()).build();

    private static final SdkField<String> SUBSCRIPTIONS_FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionsFilePath").getter(getter(GraphQLRenderConfig::subscriptionsFilePath))
            .setter(setter(Builder::subscriptionsFilePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionsFilePath").build())
            .build();

    private static final SdkField<String> FRAGMENTS_FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fragmentsFilePath").getter(getter(GraphQLRenderConfig::fragmentsFilePath))
            .setter(setter(Builder::fragmentsFilePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentsFilePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FILE_PATH_FIELD,
            QUERIES_FILE_PATH_FIELD, MUTATIONS_FILE_PATH_FIELD, SUBSCRIPTIONS_FILE_PATH_FIELD, FRAGMENTS_FILE_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String typesFilePath;

    private final String queriesFilePath;

    private final String mutationsFilePath;

    private final String subscriptionsFilePath;

    private final String fragmentsFilePath;

    private GraphQLRenderConfig(BuilderImpl builder) {
        this.typesFilePath = builder.typesFilePath;
        this.queriesFilePath = builder.queriesFilePath;
        this.mutationsFilePath = builder.mutationsFilePath;
        this.subscriptionsFilePath = builder.subscriptionsFilePath;
        this.fragmentsFilePath = builder.fragmentsFilePath;
    }

    /**
     * <p>
     * The path to the GraphQL types file, relative to the component output directory.
     * </p>
     * 
     * @return The path to the GraphQL types file, relative to the component output directory.
     */
    public final String typesFilePath() {
        return typesFilePath;
    }

    /**
     * <p>
     * The path to the GraphQL queries file, relative to the component output directory.
     * </p>
     * 
     * @return The path to the GraphQL queries file, relative to the component output directory.
     */
    public final String queriesFilePath() {
        return queriesFilePath;
    }

    /**
     * <p>
     * The path to the GraphQL mutations file, relative to the component output directory.
     * </p>
     * 
     * @return The path to the GraphQL mutations file, relative to the component output directory.
     */
    public final String mutationsFilePath() {
        return mutationsFilePath;
    }

    /**
     * <p>
     * The path to the GraphQL subscriptions file, relative to the component output directory.
     * </p>
     * 
     * @return The path to the GraphQL subscriptions file, relative to the component output directory.
     */
    public final String subscriptionsFilePath() {
        return subscriptionsFilePath;
    }

    /**
     * <p>
     * The path to the GraphQL fragments file, relative to the component output directory.
     * </p>
     * 
     * @return The path to the GraphQL fragments file, relative to the component output directory.
     */
    public final String fragmentsFilePath() {
        return fragmentsFilePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typesFilePath());
        hashCode = 31 * hashCode + Objects.hashCode(queriesFilePath());
        hashCode = 31 * hashCode + Objects.hashCode(mutationsFilePath());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionsFilePath());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentsFilePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphQLRenderConfig)) {
            return false;
        }
        GraphQLRenderConfig other = (GraphQLRenderConfig) obj;
        return Objects.equals(typesFilePath(), other.typesFilePath())
                && Objects.equals(queriesFilePath(), other.queriesFilePath())
                && Objects.equals(mutationsFilePath(), other.mutationsFilePath())
                && Objects.equals(subscriptionsFilePath(), other.subscriptionsFilePath())
                && Objects.equals(fragmentsFilePath(), other.fragmentsFilePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GraphQLRenderConfig").add("TypesFilePath", typesFilePath())
                .add("QueriesFilePath", queriesFilePath()).add("MutationsFilePath", mutationsFilePath())
                .add("SubscriptionsFilePath", subscriptionsFilePath()).add("FragmentsFilePath", fragmentsFilePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "typesFilePath":
            return Optional.ofNullable(clazz.cast(typesFilePath()));
        case "queriesFilePath":
            return Optional.ofNullable(clazz.cast(queriesFilePath()));
        case "mutationsFilePath":
            return Optional.ofNullable(clazz.cast(mutationsFilePath()));
        case "subscriptionsFilePath":
            return Optional.ofNullable(clazz.cast(subscriptionsFilePath()));
        case "fragmentsFilePath":
            return Optional.ofNullable(clazz.cast(fragmentsFilePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GraphQLRenderConfig, T> g) {
        return obj -> g.apply((GraphQLRenderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GraphQLRenderConfig> {
        /**
         * <p>
         * The path to the GraphQL types file, relative to the component output directory.
         * </p>
         * 
         * @param typesFilePath
         *        The path to the GraphQL types file, relative to the component output directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesFilePath(String typesFilePath);

        /**
         * <p>
         * The path to the GraphQL queries file, relative to the component output directory.
         * </p>
         * 
         * @param queriesFilePath
         *        The path to the GraphQL queries file, relative to the component output directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queriesFilePath(String queriesFilePath);

        /**
         * <p>
         * The path to the GraphQL mutations file, relative to the component output directory.
         * </p>
         * 
         * @param mutationsFilePath
         *        The path to the GraphQL mutations file, relative to the component output directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutationsFilePath(String mutationsFilePath);

        /**
         * <p>
         * The path to the GraphQL subscriptions file, relative to the component output directory.
         * </p>
         * 
         * @param subscriptionsFilePath
         *        The path to the GraphQL subscriptions file, relative to the component output directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionsFilePath(String subscriptionsFilePath);

        /**
         * <p>
         * The path to the GraphQL fragments file, relative to the component output directory.
         * </p>
         * 
         * @param fragmentsFilePath
         *        The path to the GraphQL fragments file, relative to the component output directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentsFilePath(String fragmentsFilePath);
    }

    static final class BuilderImpl implements Builder {
        private String typesFilePath;

        private String queriesFilePath;

        private String mutationsFilePath;

        private String subscriptionsFilePath;

        private String fragmentsFilePath;

        private BuilderImpl() {
        }

        private BuilderImpl(GraphQLRenderConfig model) {
            typesFilePath(model.typesFilePath);
            queriesFilePath(model.queriesFilePath);
            mutationsFilePath(model.mutationsFilePath);
            subscriptionsFilePath(model.subscriptionsFilePath);
            fragmentsFilePath(model.fragmentsFilePath);
        }

        public final String getTypesFilePath() {
            return typesFilePath;
        }

        public final void setTypesFilePath(String typesFilePath) {
            this.typesFilePath = typesFilePath;
        }

        @Override
        public final Builder typesFilePath(String typesFilePath) {
            this.typesFilePath = typesFilePath;
            return this;
        }

        public final String getQueriesFilePath() {
            return queriesFilePath;
        }

        public final void setQueriesFilePath(String queriesFilePath) {
            this.queriesFilePath = queriesFilePath;
        }

        @Override
        public final Builder queriesFilePath(String queriesFilePath) {
            this.queriesFilePath = queriesFilePath;
            return this;
        }

        public final String getMutationsFilePath() {
            return mutationsFilePath;
        }

        public final void setMutationsFilePath(String mutationsFilePath) {
            this.mutationsFilePath = mutationsFilePath;
        }

        @Override
        public final Builder mutationsFilePath(String mutationsFilePath) {
            this.mutationsFilePath = mutationsFilePath;
            return this;
        }

        public final String getSubscriptionsFilePath() {
            return subscriptionsFilePath;
        }

        public final void setSubscriptionsFilePath(String subscriptionsFilePath) {
            this.subscriptionsFilePath = subscriptionsFilePath;
        }

        @Override
        public final Builder subscriptionsFilePath(String subscriptionsFilePath) {
            this.subscriptionsFilePath = subscriptionsFilePath;
            return this;
        }

        public final String getFragmentsFilePath() {
            return fragmentsFilePath;
        }

        public final void setFragmentsFilePath(String fragmentsFilePath) {
            this.fragmentsFilePath = fragmentsFilePath;
        }

        @Override
        public final Builder fragmentsFilePath(String fragmentsFilePath) {
            this.fragmentsFilePath = fragmentsFilePath;
            return this;
        }

        @Override
        public GraphQLRenderConfig build() {
            return new GraphQLRenderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
