/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetUserAccessTasksRequest extends AppFabricRequest implements
        ToCopyableBuilder<BatchGetUserAccessTasksRequest.Builder, BatchGetUserAccessTasksRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appBundleIdentifier").getter(getter(BatchGetUserAccessTasksRequest::appBundleIdentifier))
            .setter(setter(Builder::appBundleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appBundleIdentifier").build())
            .build();

    private static final SdkField<List<String>> TASK_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("taskIdList")
            .getter(getter(BatchGetUserAccessTasksRequest::taskIdList))
            .setter(setter(Builder::taskIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD,
            TASK_ID_LIST_FIELD));

    private final String appBundleIdentifier;

    private final List<String> taskIdList;

    private BatchGetUserAccessTasksRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.taskIdList = builder.taskIdList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
     *         request.
     */
    public final String appBundleIdentifier() {
        return appBundleIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskIdList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTaskIdList() {
        return taskIdList != null && !(taskIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tasks IDs to use for the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskIdList} method.
     * </p>
     * 
     * @return The tasks IDs to use for the request.
     */
    public final List<String> taskIdList() {
        return taskIdList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskIdList() ? taskIdList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetUserAccessTasksRequest)) {
            return false;
        }
        BatchGetUserAccessTasksRequest other = (BatchGetUserAccessTasksRequest) obj;
        return Objects.equals(appBundleIdentifier(), other.appBundleIdentifier()) && hasTaskIdList() == other.hasTaskIdList()
                && Objects.equals(taskIdList(), other.taskIdList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetUserAccessTasksRequest").add("AppBundleIdentifier", appBundleIdentifier())
                .add("TaskIdList", hasTaskIdList() ? taskIdList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appBundleIdentifier":
            return Optional.ofNullable(clazz.cast(appBundleIdentifier()));
        case "taskIdList":
            return Optional.ofNullable(clazz.cast(taskIdList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetUserAccessTasksRequest, T> g) {
        return obj -> g.apply((BatchGetUserAccessTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetUserAccessTasksRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         * request.
         * </p>
         * 
         * @param appBundleIdentifier
         *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBundleIdentifier(String appBundleIdentifier);

        /**
         * <p>
         * The tasks IDs to use for the request.
         * </p>
         * 
         * @param taskIdList
         *        The tasks IDs to use for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIdList(Collection<String> taskIdList);

        /**
         * <p>
         * The tasks IDs to use for the request.
         * </p>
         * 
         * @param taskIdList
         *        The tasks IDs to use for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIdList(String... taskIdList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppFabricRequest.BuilderImpl implements Builder {
        private String appBundleIdentifier;

        private List<String> taskIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetUserAccessTasksRequest model) {
            super(model);
            appBundleIdentifier(model.appBundleIdentifier);
            taskIdList(model.taskIdList);
        }

        public final String getAppBundleIdentifier() {
            return appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final Collection<String> getTaskIdList() {
            if (taskIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return taskIdList;
        }

        public final void setTaskIdList(Collection<String> taskIdList) {
            this.taskIdList = TaskIdListCopier.copy(taskIdList);
        }

        @Override
        public final Builder taskIdList(Collection<String> taskIdList) {
            this.taskIdList = TaskIdListCopier.copy(taskIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIdList(String... taskIdList) {
            taskIdList(Arrays.asList(taskIdList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetUserAccessTasksRequest build() {
            return new BatchGetUserAccessTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
