/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregation settings that you can use to customize the output format of your flow data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationConfig.Builder, AggregationConfig> {
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationType").getter(getter(AggregationConfig::aggregationTypeAsString))
            .setter(setter(Builder::aggregationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aggregationType;

    private AggregationConfig(BuilderImpl builder) {
        this.aggregationType = builder.aggregationType;
    }

    /**
     * <p>
     * Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationType}
     * will return {@link AggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them
     *         unaggregated.
     * @see AggregationType
     */
    public final AggregationType aggregationType() {
        return AggregationType.fromValue(aggregationType);
    }

    /**
     * <p>
     * Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationType}
     * will return {@link AggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationTypeAsString}.
     * </p>
     * 
     * @return Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them
     *         unaggregated.
     * @see AggregationType
     */
    public final String aggregationTypeAsString() {
        return aggregationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationConfig)) {
            return false;
        }
        AggregationConfig other = (AggregationConfig) obj;
        return Objects.equals(aggregationTypeAsString(), other.aggregationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregationConfig").add("AggregationType", aggregationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregationType":
            return Optional.ofNullable(clazz.cast(aggregationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregationConfig, T> g) {
        return obj -> g.apply((AggregationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationConfig> {
        /**
         * <p>
         * Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
         * </p>
         * 
         * @param aggregationType
         *        Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them
         *        unaggregated.
         * @see AggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationType
         */
        Builder aggregationType(String aggregationType);

        /**
         * <p>
         * Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
         * </p>
         * 
         * @param aggregationType
         *        Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them
         *        unaggregated.
         * @see AggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationType
         */
        Builder aggregationType(AggregationType aggregationType);
    }

    static final class BuilderImpl implements Builder {
        private String aggregationType;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationConfig model) {
            aggregationType(model.aggregationType);
        }

        public final String getAggregationType() {
            return aggregationType;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        @Override
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType(aggregationType == null ? null : aggregationType.toString());
            return this;
        }

        @Override
        public AggregationConfig build() {
            return new AggregationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
