/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation to be performed on the provided source fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorOperator implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorOperator.Builder, ConnectorOperator> {
    private static final SdkField<String> AMPLITUDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Amplitude").getter(getter(ConnectorOperator::amplitudeAsString)).setter(setter(Builder::amplitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amplitude").build()).build();

    private static final SdkField<String> DATADOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Datadog")
            .getter(getter(ConnectorOperator::datadogAsString)).setter(setter(Builder::datadog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datadog").build()).build();

    private static final SdkField<String> DYNATRACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Dynatrace").getter(getter(ConnectorOperator::dynatraceAsString)).setter(setter(Builder::dynatrace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dynatrace").build()).build();

    private static final SdkField<String> GOOGLE_ANALYTICS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GoogleAnalytics").getter(getter(ConnectorOperator::googleAnalyticsAsString))
            .setter(setter(Builder::googleAnalytics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoogleAnalytics").build()).build();

    private static final SdkField<String> INFOR_NEXUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InforNexus").getter(getter(ConnectorOperator::inforNexusAsString)).setter(setter(Builder::inforNexus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InforNexus").build()).build();

    private static final SdkField<String> MARKETO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marketo")
            .getter(getter(ConnectorOperator::marketoAsString)).setter(setter(Builder::marketo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()).build();

    private static final SdkField<String> S3_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3")
            .getter(getter(ConnectorOperator::s3AsString)).setter(setter(Builder::s3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final SdkField<String> SALESFORCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Salesforce").getter(getter(ConnectorOperator::salesforceAsString)).setter(setter(Builder::salesforce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()).build();

    private static final SdkField<String> SERVICE_NOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceNow").getter(getter(ConnectorOperator::serviceNowAsString)).setter(setter(Builder::serviceNow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()).build();

    private static final SdkField<String> SINGULAR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Singular").getter(getter(ConnectorOperator::singularAsString)).setter(setter(Builder::singular))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Singular").build()).build();

    private static final SdkField<String> SLACK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Slack")
            .getter(getter(ConnectorOperator::slackAsString)).setter(setter(Builder::slack))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slack").build()).build();

    private static final SdkField<String> TRENDMICRO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Trendmicro").getter(getter(ConnectorOperator::trendmicroAsString)).setter(setter(Builder::trendmicro))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trendmicro").build()).build();

    private static final SdkField<String> VEEVA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Veeva")
            .getter(getter(ConnectorOperator::veevaAsString)).setter(setter(Builder::veeva))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Veeva").build()).build();

    private static final SdkField<String> ZENDESK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Zendesk")
            .getter(getter(ConnectorOperator::zendeskAsString)).setter(setter(Builder::zendesk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()).build();

    private static final SdkField<String> SAPO_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAPOData").getter(getter(ConnectorOperator::sapoDataAsString)).setter(setter(Builder::sapoData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAPOData").build()).build();

    private static final SdkField<String> CUSTOM_CONNECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomConnector").getter(getter(ConnectorOperator::customConnectorAsString))
            .setter(setter(Builder::customConnector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomConnector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMPLITUDE_FIELD,
            DATADOG_FIELD, DYNATRACE_FIELD, GOOGLE_ANALYTICS_FIELD, INFOR_NEXUS_FIELD, MARKETO_FIELD, S3_FIELD, SALESFORCE_FIELD,
            SERVICE_NOW_FIELD, SINGULAR_FIELD, SLACK_FIELD, TRENDMICRO_FIELD, VEEVA_FIELD, ZENDESK_FIELD, SAPO_DATA_FIELD,
            CUSTOM_CONNECTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String amplitude;

    private final String datadog;

    private final String dynatrace;

    private final String googleAnalytics;

    private final String inforNexus;

    private final String marketo;

    private final String s3;

    private final String salesforce;

    private final String serviceNow;

    private final String singular;

    private final String slack;

    private final String trendmicro;

    private final String veeva;

    private final String zendesk;

    private final String sapoData;

    private final String customConnector;

    private ConnectorOperator(BuilderImpl builder) {
        this.amplitude = builder.amplitude;
        this.datadog = builder.datadog;
        this.dynatrace = builder.dynatrace;
        this.googleAnalytics = builder.googleAnalytics;
        this.inforNexus = builder.inforNexus;
        this.marketo = builder.marketo;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.singular = builder.singular;
        this.slack = builder.slack;
        this.trendmicro = builder.trendmicro;
        this.veeva = builder.veeva;
        this.zendesk = builder.zendesk;
        this.sapoData = builder.sapoData;
        this.customConnector = builder.customConnector;
    }

    /**
     * <p>
     * The operation to be performed on the provided Amplitude source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amplitude} will
     * return {@link AmplitudeConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #amplitudeAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Amplitude source fields.
     * @see AmplitudeConnectorOperator
     */
    public final AmplitudeConnectorOperator amplitude() {
        return AmplitudeConnectorOperator.fromValue(amplitude);
    }

    /**
     * <p>
     * The operation to be performed on the provided Amplitude source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amplitude} will
     * return {@link AmplitudeConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #amplitudeAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Amplitude source fields.
     * @see AmplitudeConnectorOperator
     */
    public final String amplitudeAsString() {
        return amplitude;
    }

    /**
     * <p>
     * The operation to be performed on the provided Datadog source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datadog} will
     * return {@link DatadogConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #datadogAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Datadog source fields.
     * @see DatadogConnectorOperator
     */
    public final DatadogConnectorOperator datadog() {
        return DatadogConnectorOperator.fromValue(datadog);
    }

    /**
     * <p>
     * The operation to be performed on the provided Datadog source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datadog} will
     * return {@link DatadogConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #datadogAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Datadog source fields.
     * @see DatadogConnectorOperator
     */
    public final String datadogAsString() {
        return datadog;
    }

    /**
     * <p>
     * The operation to be performed on the provided Dynatrace source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynatrace} will
     * return {@link DynatraceConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynatraceAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Dynatrace source fields.
     * @see DynatraceConnectorOperator
     */
    public final DynatraceConnectorOperator dynatrace() {
        return DynatraceConnectorOperator.fromValue(dynatrace);
    }

    /**
     * <p>
     * The operation to be performed on the provided Dynatrace source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynatrace} will
     * return {@link DynatraceConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynatraceAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Dynatrace source fields.
     * @see DynatraceConnectorOperator
     */
    public final String dynatraceAsString() {
        return dynatrace;
    }

    /**
     * <p>
     * The operation to be performed on the provided Google Analytics source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #googleAnalytics}
     * will return {@link GoogleAnalyticsConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #googleAnalyticsAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Google Analytics source fields.
     * @see GoogleAnalyticsConnectorOperator
     */
    public final GoogleAnalyticsConnectorOperator googleAnalytics() {
        return GoogleAnalyticsConnectorOperator.fromValue(googleAnalytics);
    }

    /**
     * <p>
     * The operation to be performed on the provided Google Analytics source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #googleAnalytics}
     * will return {@link GoogleAnalyticsConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #googleAnalyticsAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Google Analytics source fields.
     * @see GoogleAnalyticsConnectorOperator
     */
    public final String googleAnalyticsAsString() {
        return googleAnalytics;
    }

    /**
     * <p>
     * The operation to be performed on the provided Infor Nexus source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inforNexus} will
     * return {@link InforNexusConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inforNexusAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Infor Nexus source fields.
     * @see InforNexusConnectorOperator
     */
    public final InforNexusConnectorOperator inforNexus() {
        return InforNexusConnectorOperator.fromValue(inforNexus);
    }

    /**
     * <p>
     * The operation to be performed on the provided Infor Nexus source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inforNexus} will
     * return {@link InforNexusConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inforNexusAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Infor Nexus source fields.
     * @see InforNexusConnectorOperator
     */
    public final String inforNexusAsString() {
        return inforNexus;
    }

    /**
     * <p>
     * The operation to be performed on the provided Marketo source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #marketo} will
     * return {@link MarketoConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #marketoAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Marketo source fields.
     * @see MarketoConnectorOperator
     */
    public final MarketoConnectorOperator marketo() {
        return MarketoConnectorOperator.fromValue(marketo);
    }

    /**
     * <p>
     * The operation to be performed on the provided Marketo source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #marketo} will
     * return {@link MarketoConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #marketoAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Marketo source fields.
     * @see MarketoConnectorOperator
     */
    public final String marketoAsString() {
        return marketo;
    }

    /**
     * <p>
     * The operation to be performed on the provided Amazon S3 source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3} will return
     * {@link S3ConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Amazon S3 source fields.
     * @see S3ConnectorOperator
     */
    public final S3ConnectorOperator s3() {
        return S3ConnectorOperator.fromValue(s3);
    }

    /**
     * <p>
     * The operation to be performed on the provided Amazon S3 source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3} will return
     * {@link S3ConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Amazon S3 source fields.
     * @see S3ConnectorOperator
     */
    public final String s3AsString() {
        return s3;
    }

    /**
     * <p>
     * The operation to be performed on the provided Salesforce source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #salesforce} will
     * return {@link SalesforceConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #salesforceAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Salesforce source fields.
     * @see SalesforceConnectorOperator
     */
    public final SalesforceConnectorOperator salesforce() {
        return SalesforceConnectorOperator.fromValue(salesforce);
    }

    /**
     * <p>
     * The operation to be performed on the provided Salesforce source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #salesforce} will
     * return {@link SalesforceConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #salesforceAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Salesforce source fields.
     * @see SalesforceConnectorOperator
     */
    public final String salesforceAsString() {
        return salesforce;
    }

    /**
     * <p>
     * The operation to be performed on the provided ServiceNow source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNow} will
     * return {@link ServiceNowConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceNowAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided ServiceNow source fields.
     * @see ServiceNowConnectorOperator
     */
    public final ServiceNowConnectorOperator serviceNow() {
        return ServiceNowConnectorOperator.fromValue(serviceNow);
    }

    /**
     * <p>
     * The operation to be performed on the provided ServiceNow source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNow} will
     * return {@link ServiceNowConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceNowAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided ServiceNow source fields.
     * @see ServiceNowConnectorOperator
     */
    public final String serviceNowAsString() {
        return serviceNow;
    }

    /**
     * <p>
     * The operation to be performed on the provided Singular source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #singular} will
     * return {@link SingularConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #singularAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Singular source fields.
     * @see SingularConnectorOperator
     */
    public final SingularConnectorOperator singular() {
        return SingularConnectorOperator.fromValue(singular);
    }

    /**
     * <p>
     * The operation to be performed on the provided Singular source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #singular} will
     * return {@link SingularConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #singularAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Singular source fields.
     * @see SingularConnectorOperator
     */
    public final String singularAsString() {
        return singular;
    }

    /**
     * <p>
     * The operation to be performed on the provided Slack source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slack} will return
     * {@link SlackConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slackAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Slack source fields.
     * @see SlackConnectorOperator
     */
    public final SlackConnectorOperator slack() {
        return SlackConnectorOperator.fromValue(slack);
    }

    /**
     * <p>
     * The operation to be performed on the provided Slack source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slack} will return
     * {@link SlackConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slackAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Slack source fields.
     * @see SlackConnectorOperator
     */
    public final String slackAsString() {
        return slack;
    }

    /**
     * <p>
     * The operation to be performed on the provided Trend Micro source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trendmicro} will
     * return {@link TrendmicroConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #trendmicroAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Trend Micro source fields.
     * @see TrendmicroConnectorOperator
     */
    public final TrendmicroConnectorOperator trendmicro() {
        return TrendmicroConnectorOperator.fromValue(trendmicro);
    }

    /**
     * <p>
     * The operation to be performed on the provided Trend Micro source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trendmicro} will
     * return {@link TrendmicroConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #trendmicroAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Trend Micro source fields.
     * @see TrendmicroConnectorOperator
     */
    public final String trendmicroAsString() {
        return trendmicro;
    }

    /**
     * <p>
     * The operation to be performed on the provided Veeva source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #veeva} will return
     * {@link VeevaConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #veevaAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Veeva source fields.
     * @see VeevaConnectorOperator
     */
    public final VeevaConnectorOperator veeva() {
        return VeevaConnectorOperator.fromValue(veeva);
    }

    /**
     * <p>
     * The operation to be performed on the provided Veeva source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #veeva} will return
     * {@link VeevaConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #veevaAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Veeva source fields.
     * @see VeevaConnectorOperator
     */
    public final String veevaAsString() {
        return veeva;
    }

    /**
     * <p>
     * The operation to be performed on the provided Zendesk source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #zendesk} will
     * return {@link ZendeskConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #zendeskAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Zendesk source fields.
     * @see ZendeskConnectorOperator
     */
    public final ZendeskConnectorOperator zendesk() {
        return ZendeskConnectorOperator.fromValue(zendesk);
    }

    /**
     * <p>
     * The operation to be performed on the provided Zendesk source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #zendesk} will
     * return {@link ZendeskConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #zendeskAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided Zendesk source fields.
     * @see ZendeskConnectorOperator
     */
    public final String zendeskAsString() {
        return zendesk;
    }

    /**
     * <p>
     * The operation to be performed on the provided SAPOData source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sapoData} will
     * return {@link SAPODataConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sapoDataAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided SAPOData source fields.
     * @see SAPODataConnectorOperator
     */
    public final SAPODataConnectorOperator sapoData() {
        return SAPODataConnectorOperator.fromValue(sapoData);
    }

    /**
     * <p>
     * The operation to be performed on the provided SAPOData source fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sapoData} will
     * return {@link SAPODataConnectorOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sapoDataAsString}.
     * </p>
     * 
     * @return The operation to be performed on the provided SAPOData source fields.
     * @see SAPODataConnectorOperator
     */
    public final String sapoDataAsString() {
        return sapoData;
    }

    /**
     * <p>
     * Operators supported by the custom connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customConnector}
     * will return {@link Operator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #customConnectorAsString}.
     * </p>
     * 
     * @return Operators supported by the custom connector.
     * @see Operator
     */
    public final Operator customConnector() {
        return Operator.fromValue(customConnector);
    }

    /**
     * <p>
     * Operators supported by the custom connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customConnector}
     * will return {@link Operator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #customConnectorAsString}.
     * </p>
     * 
     * @return Operators supported by the custom connector.
     * @see Operator
     */
    public final String customConnectorAsString() {
        return customConnector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amplitudeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datadogAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynatraceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(googleAnalyticsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inforNexusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marketoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3AsString());
        hashCode = 31 * hashCode + Objects.hashCode(salesforceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(singularAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trendmicroAsString());
        hashCode = 31 * hashCode + Objects.hashCode(veevaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(zendeskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sapoDataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customConnectorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorOperator)) {
            return false;
        }
        ConnectorOperator other = (ConnectorOperator) obj;
        return Objects.equals(amplitudeAsString(), other.amplitudeAsString())
                && Objects.equals(datadogAsString(), other.datadogAsString())
                && Objects.equals(dynatraceAsString(), other.dynatraceAsString())
                && Objects.equals(googleAnalyticsAsString(), other.googleAnalyticsAsString())
                && Objects.equals(inforNexusAsString(), other.inforNexusAsString())
                && Objects.equals(marketoAsString(), other.marketoAsString()) && Objects.equals(s3AsString(), other.s3AsString())
                && Objects.equals(salesforceAsString(), other.salesforceAsString())
                && Objects.equals(serviceNowAsString(), other.serviceNowAsString())
                && Objects.equals(singularAsString(), other.singularAsString())
                && Objects.equals(slackAsString(), other.slackAsString())
                && Objects.equals(trendmicroAsString(), other.trendmicroAsString())
                && Objects.equals(veevaAsString(), other.veevaAsString())
                && Objects.equals(zendeskAsString(), other.zendeskAsString())
                && Objects.equals(sapoDataAsString(), other.sapoDataAsString())
                && Objects.equals(customConnectorAsString(), other.customConnectorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorOperator").add("Amplitude", amplitudeAsString()).add("Datadog", datadogAsString())
                .add("Dynatrace", dynatraceAsString()).add("GoogleAnalytics", googleAnalyticsAsString())
                .add("InforNexus", inforNexusAsString()).add("Marketo", marketoAsString()).add("S3", s3AsString())
                .add("Salesforce", salesforceAsString()).add("ServiceNow", serviceNowAsString())
                .add("Singular", singularAsString()).add("Slack", slackAsString()).add("Trendmicro", trendmicroAsString())
                .add("Veeva", veevaAsString()).add("Zendesk", zendeskAsString()).add("SAPOData", sapoDataAsString())
                .add("CustomConnector", customConnectorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amplitude":
            return Optional.ofNullable(clazz.cast(amplitudeAsString()));
        case "Datadog":
            return Optional.ofNullable(clazz.cast(datadogAsString()));
        case "Dynatrace":
            return Optional.ofNullable(clazz.cast(dynatraceAsString()));
        case "GoogleAnalytics":
            return Optional.ofNullable(clazz.cast(googleAnalyticsAsString()));
        case "InforNexus":
            return Optional.ofNullable(clazz.cast(inforNexusAsString()));
        case "Marketo":
            return Optional.ofNullable(clazz.cast(marketoAsString()));
        case "S3":
            return Optional.ofNullable(clazz.cast(s3AsString()));
        case "Salesforce":
            return Optional.ofNullable(clazz.cast(salesforceAsString()));
        case "ServiceNow":
            return Optional.ofNullable(clazz.cast(serviceNowAsString()));
        case "Singular":
            return Optional.ofNullable(clazz.cast(singularAsString()));
        case "Slack":
            return Optional.ofNullable(clazz.cast(slackAsString()));
        case "Trendmicro":
            return Optional.ofNullable(clazz.cast(trendmicroAsString()));
        case "Veeva":
            return Optional.ofNullable(clazz.cast(veevaAsString()));
        case "Zendesk":
            return Optional.ofNullable(clazz.cast(zendeskAsString()));
        case "SAPOData":
            return Optional.ofNullable(clazz.cast(sapoDataAsString()));
        case "CustomConnector":
            return Optional.ofNullable(clazz.cast(customConnectorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorOperator, T> g) {
        return obj -> g.apply((ConnectorOperator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorOperator> {
        /**
         * <p>
         * The operation to be performed on the provided Amplitude source fields.
         * </p>
         * 
         * @param amplitude
         *        The operation to be performed on the provided Amplitude source fields.
         * @see AmplitudeConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmplitudeConnectorOperator
         */
        Builder amplitude(String amplitude);

        /**
         * <p>
         * The operation to be performed on the provided Amplitude source fields.
         * </p>
         * 
         * @param amplitude
         *        The operation to be performed on the provided Amplitude source fields.
         * @see AmplitudeConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmplitudeConnectorOperator
         */
        Builder amplitude(AmplitudeConnectorOperator amplitude);

        /**
         * <p>
         * The operation to be performed on the provided Datadog source fields.
         * </p>
         * 
         * @param datadog
         *        The operation to be performed on the provided Datadog source fields.
         * @see DatadogConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatadogConnectorOperator
         */
        Builder datadog(String datadog);

        /**
         * <p>
         * The operation to be performed on the provided Datadog source fields.
         * </p>
         * 
         * @param datadog
         *        The operation to be performed on the provided Datadog source fields.
         * @see DatadogConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatadogConnectorOperator
         */
        Builder datadog(DatadogConnectorOperator datadog);

        /**
         * <p>
         * The operation to be performed on the provided Dynatrace source fields.
         * </p>
         * 
         * @param dynatrace
         *        The operation to be performed on the provided Dynatrace source fields.
         * @see DynatraceConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynatraceConnectorOperator
         */
        Builder dynatrace(String dynatrace);

        /**
         * <p>
         * The operation to be performed on the provided Dynatrace source fields.
         * </p>
         * 
         * @param dynatrace
         *        The operation to be performed on the provided Dynatrace source fields.
         * @see DynatraceConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynatraceConnectorOperator
         */
        Builder dynatrace(DynatraceConnectorOperator dynatrace);

        /**
         * <p>
         * The operation to be performed on the provided Google Analytics source fields.
         * </p>
         * 
         * @param googleAnalytics
         *        The operation to be performed on the provided Google Analytics source fields.
         * @see GoogleAnalyticsConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GoogleAnalyticsConnectorOperator
         */
        Builder googleAnalytics(String googleAnalytics);

        /**
         * <p>
         * The operation to be performed on the provided Google Analytics source fields.
         * </p>
         * 
         * @param googleAnalytics
         *        The operation to be performed on the provided Google Analytics source fields.
         * @see GoogleAnalyticsConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GoogleAnalyticsConnectorOperator
         */
        Builder googleAnalytics(GoogleAnalyticsConnectorOperator googleAnalytics);

        /**
         * <p>
         * The operation to be performed on the provided Infor Nexus source fields.
         * </p>
         * 
         * @param inforNexus
         *        The operation to be performed on the provided Infor Nexus source fields.
         * @see InforNexusConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InforNexusConnectorOperator
         */
        Builder inforNexus(String inforNexus);

        /**
         * <p>
         * The operation to be performed on the provided Infor Nexus source fields.
         * </p>
         * 
         * @param inforNexus
         *        The operation to be performed on the provided Infor Nexus source fields.
         * @see InforNexusConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InforNexusConnectorOperator
         */
        Builder inforNexus(InforNexusConnectorOperator inforNexus);

        /**
         * <p>
         * The operation to be performed on the provided Marketo source fields.
         * </p>
         * 
         * @param marketo
         *        The operation to be performed on the provided Marketo source fields.
         * @see MarketoConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketoConnectorOperator
         */
        Builder marketo(String marketo);

        /**
         * <p>
         * The operation to be performed on the provided Marketo source fields.
         * </p>
         * 
         * @param marketo
         *        The operation to be performed on the provided Marketo source fields.
         * @see MarketoConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketoConnectorOperator
         */
        Builder marketo(MarketoConnectorOperator marketo);

        /**
         * <p>
         * The operation to be performed on the provided Amazon S3 source fields.
         * </p>
         * 
         * @param s3
         *        The operation to be performed on the provided Amazon S3 source fields.
         * @see S3ConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3ConnectorOperator
         */
        Builder s3(String s3);

        /**
         * <p>
         * The operation to be performed on the provided Amazon S3 source fields.
         * </p>
         * 
         * @param s3
         *        The operation to be performed on the provided Amazon S3 source fields.
         * @see S3ConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3ConnectorOperator
         */
        Builder s3(S3ConnectorOperator s3);

        /**
         * <p>
         * The operation to be performed on the provided Salesforce source fields.
         * </p>
         * 
         * @param salesforce
         *        The operation to be performed on the provided Salesforce source fields.
         * @see SalesforceConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesforceConnectorOperator
         */
        Builder salesforce(String salesforce);

        /**
         * <p>
         * The operation to be performed on the provided Salesforce source fields.
         * </p>
         * 
         * @param salesforce
         *        The operation to be performed on the provided Salesforce source fields.
         * @see SalesforceConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesforceConnectorOperator
         */
        Builder salesforce(SalesforceConnectorOperator salesforce);

        /**
         * <p>
         * The operation to be performed on the provided ServiceNow source fields.
         * </p>
         * 
         * @param serviceNow
         *        The operation to be performed on the provided ServiceNow source fields.
         * @see ServiceNowConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNowConnectorOperator
         */
        Builder serviceNow(String serviceNow);

        /**
         * <p>
         * The operation to be performed on the provided ServiceNow source fields.
         * </p>
         * 
         * @param serviceNow
         *        The operation to be performed on the provided ServiceNow source fields.
         * @see ServiceNowConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNowConnectorOperator
         */
        Builder serviceNow(ServiceNowConnectorOperator serviceNow);

        /**
         * <p>
         * The operation to be performed on the provided Singular source fields.
         * </p>
         * 
         * @param singular
         *        The operation to be performed on the provided Singular source fields.
         * @see SingularConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SingularConnectorOperator
         */
        Builder singular(String singular);

        /**
         * <p>
         * The operation to be performed on the provided Singular source fields.
         * </p>
         * 
         * @param singular
         *        The operation to be performed on the provided Singular source fields.
         * @see SingularConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SingularConnectorOperator
         */
        Builder singular(SingularConnectorOperator singular);

        /**
         * <p>
         * The operation to be performed on the provided Slack source fields.
         * </p>
         * 
         * @param slack
         *        The operation to be performed on the provided Slack source fields.
         * @see SlackConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlackConnectorOperator
         */
        Builder slack(String slack);

        /**
         * <p>
         * The operation to be performed on the provided Slack source fields.
         * </p>
         * 
         * @param slack
         *        The operation to be performed on the provided Slack source fields.
         * @see SlackConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlackConnectorOperator
         */
        Builder slack(SlackConnectorOperator slack);

        /**
         * <p>
         * The operation to be performed on the provided Trend Micro source fields.
         * </p>
         * 
         * @param trendmicro
         *        The operation to be performed on the provided Trend Micro source fields.
         * @see TrendmicroConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrendmicroConnectorOperator
         */
        Builder trendmicro(String trendmicro);

        /**
         * <p>
         * The operation to be performed on the provided Trend Micro source fields.
         * </p>
         * 
         * @param trendmicro
         *        The operation to be performed on the provided Trend Micro source fields.
         * @see TrendmicroConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrendmicroConnectorOperator
         */
        Builder trendmicro(TrendmicroConnectorOperator trendmicro);

        /**
         * <p>
         * The operation to be performed on the provided Veeva source fields.
         * </p>
         * 
         * @param veeva
         *        The operation to be performed on the provided Veeva source fields.
         * @see VeevaConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VeevaConnectorOperator
         */
        Builder veeva(String veeva);

        /**
         * <p>
         * The operation to be performed on the provided Veeva source fields.
         * </p>
         * 
         * @param veeva
         *        The operation to be performed on the provided Veeva source fields.
         * @see VeevaConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VeevaConnectorOperator
         */
        Builder veeva(VeevaConnectorOperator veeva);

        /**
         * <p>
         * The operation to be performed on the provided Zendesk source fields.
         * </p>
         * 
         * @param zendesk
         *        The operation to be performed on the provided Zendesk source fields.
         * @see ZendeskConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZendeskConnectorOperator
         */
        Builder zendesk(String zendesk);

        /**
         * <p>
         * The operation to be performed on the provided Zendesk source fields.
         * </p>
         * 
         * @param zendesk
         *        The operation to be performed on the provided Zendesk source fields.
         * @see ZendeskConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZendeskConnectorOperator
         */
        Builder zendesk(ZendeskConnectorOperator zendesk);

        /**
         * <p>
         * The operation to be performed on the provided SAPOData source fields.
         * </p>
         * 
         * @param sapoData
         *        The operation to be performed on the provided SAPOData source fields.
         * @see SAPODataConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SAPODataConnectorOperator
         */
        Builder sapoData(String sapoData);

        /**
         * <p>
         * The operation to be performed on the provided SAPOData source fields.
         * </p>
         * 
         * @param sapoData
         *        The operation to be performed on the provided SAPOData source fields.
         * @see SAPODataConnectorOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SAPODataConnectorOperator
         */
        Builder sapoData(SAPODataConnectorOperator sapoData);

        /**
         * <p>
         * Operators supported by the custom connector.
         * </p>
         * 
         * @param customConnector
         *        Operators supported by the custom connector.
         * @see Operator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operator
         */
        Builder customConnector(String customConnector);

        /**
         * <p>
         * Operators supported by the custom connector.
         * </p>
         * 
         * @param customConnector
         *        Operators supported by the custom connector.
         * @see Operator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operator
         */
        Builder customConnector(Operator customConnector);
    }

    static final class BuilderImpl implements Builder {
        private String amplitude;

        private String datadog;

        private String dynatrace;

        private String googleAnalytics;

        private String inforNexus;

        private String marketo;

        private String s3;

        private String salesforce;

        private String serviceNow;

        private String singular;

        private String slack;

        private String trendmicro;

        private String veeva;

        private String zendesk;

        private String sapoData;

        private String customConnector;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorOperator model) {
            amplitude(model.amplitude);
            datadog(model.datadog);
            dynatrace(model.dynatrace);
            googleAnalytics(model.googleAnalytics);
            inforNexus(model.inforNexus);
            marketo(model.marketo);
            s3(model.s3);
            salesforce(model.salesforce);
            serviceNow(model.serviceNow);
            singular(model.singular);
            slack(model.slack);
            trendmicro(model.trendmicro);
            veeva(model.veeva);
            zendesk(model.zendesk);
            sapoData(model.sapoData);
            customConnector(model.customConnector);
        }

        public final String getAmplitude() {
            return amplitude;
        }

        public final void setAmplitude(String amplitude) {
            this.amplitude = amplitude;
        }

        @Override
        public final Builder amplitude(String amplitude) {
            this.amplitude = amplitude;
            return this;
        }

        @Override
        public final Builder amplitude(AmplitudeConnectorOperator amplitude) {
            this.amplitude(amplitude == null ? null : amplitude.toString());
            return this;
        }

        public final String getDatadog() {
            return datadog;
        }

        public final void setDatadog(String datadog) {
            this.datadog = datadog;
        }

        @Override
        public final Builder datadog(String datadog) {
            this.datadog = datadog;
            return this;
        }

        @Override
        public final Builder datadog(DatadogConnectorOperator datadog) {
            this.datadog(datadog == null ? null : datadog.toString());
            return this;
        }

        public final String getDynatrace() {
            return dynatrace;
        }

        public final void setDynatrace(String dynatrace) {
            this.dynatrace = dynatrace;
        }

        @Override
        public final Builder dynatrace(String dynatrace) {
            this.dynatrace = dynatrace;
            return this;
        }

        @Override
        public final Builder dynatrace(DynatraceConnectorOperator dynatrace) {
            this.dynatrace(dynatrace == null ? null : dynatrace.toString());
            return this;
        }

        public final String getGoogleAnalytics() {
            return googleAnalytics;
        }

        public final void setGoogleAnalytics(String googleAnalytics) {
            this.googleAnalytics = googleAnalytics;
        }

        @Override
        public final Builder googleAnalytics(String googleAnalytics) {
            this.googleAnalytics = googleAnalytics;
            return this;
        }

        @Override
        public final Builder googleAnalytics(GoogleAnalyticsConnectorOperator googleAnalytics) {
            this.googleAnalytics(googleAnalytics == null ? null : googleAnalytics.toString());
            return this;
        }

        public final String getInforNexus() {
            return inforNexus;
        }

        public final void setInforNexus(String inforNexus) {
            this.inforNexus = inforNexus;
        }

        @Override
        public final Builder inforNexus(String inforNexus) {
            this.inforNexus = inforNexus;
            return this;
        }

        @Override
        public final Builder inforNexus(InforNexusConnectorOperator inforNexus) {
            this.inforNexus(inforNexus == null ? null : inforNexus.toString());
            return this;
        }

        public final String getMarketo() {
            return marketo;
        }

        public final void setMarketo(String marketo) {
            this.marketo = marketo;
        }

        @Override
        public final Builder marketo(String marketo) {
            this.marketo = marketo;
            return this;
        }

        @Override
        public final Builder marketo(MarketoConnectorOperator marketo) {
            this.marketo(marketo == null ? null : marketo.toString());
            return this;
        }

        public final String getS3() {
            return s3;
        }

        public final void setS3(String s3) {
            this.s3 = s3;
        }

        @Override
        public final Builder s3(String s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public final Builder s3(S3ConnectorOperator s3) {
            this.s3(s3 == null ? null : s3.toString());
            return this;
        }

        public final String getSalesforce() {
            return salesforce;
        }

        public final void setSalesforce(String salesforce) {
            this.salesforce = salesforce;
        }

        @Override
        public final Builder salesforce(String salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        @Override
        public final Builder salesforce(SalesforceConnectorOperator salesforce) {
            this.salesforce(salesforce == null ? null : salesforce.toString());
            return this;
        }

        public final String getServiceNow() {
            return serviceNow;
        }

        public final void setServiceNow(String serviceNow) {
            this.serviceNow = serviceNow;
        }

        @Override
        public final Builder serviceNow(String serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        @Override
        public final Builder serviceNow(ServiceNowConnectorOperator serviceNow) {
            this.serviceNow(serviceNow == null ? null : serviceNow.toString());
            return this;
        }

        public final String getSingular() {
            return singular;
        }

        public final void setSingular(String singular) {
            this.singular = singular;
        }

        @Override
        public final Builder singular(String singular) {
            this.singular = singular;
            return this;
        }

        @Override
        public final Builder singular(SingularConnectorOperator singular) {
            this.singular(singular == null ? null : singular.toString());
            return this;
        }

        public final String getSlack() {
            return slack;
        }

        public final void setSlack(String slack) {
            this.slack = slack;
        }

        @Override
        public final Builder slack(String slack) {
            this.slack = slack;
            return this;
        }

        @Override
        public final Builder slack(SlackConnectorOperator slack) {
            this.slack(slack == null ? null : slack.toString());
            return this;
        }

        public final String getTrendmicro() {
            return trendmicro;
        }

        public final void setTrendmicro(String trendmicro) {
            this.trendmicro = trendmicro;
        }

        @Override
        public final Builder trendmicro(String trendmicro) {
            this.trendmicro = trendmicro;
            return this;
        }

        @Override
        public final Builder trendmicro(TrendmicroConnectorOperator trendmicro) {
            this.trendmicro(trendmicro == null ? null : trendmicro.toString());
            return this;
        }

        public final String getVeeva() {
            return veeva;
        }

        public final void setVeeva(String veeva) {
            this.veeva = veeva;
        }

        @Override
        public final Builder veeva(String veeva) {
            this.veeva = veeva;
            return this;
        }

        @Override
        public final Builder veeva(VeevaConnectorOperator veeva) {
            this.veeva(veeva == null ? null : veeva.toString());
            return this;
        }

        public final String getZendesk() {
            return zendesk;
        }

        public final void setZendesk(String zendesk) {
            this.zendesk = zendesk;
        }

        @Override
        public final Builder zendesk(String zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        @Override
        public final Builder zendesk(ZendeskConnectorOperator zendesk) {
            this.zendesk(zendesk == null ? null : zendesk.toString());
            return this;
        }

        public final String getSapoData() {
            return sapoData;
        }

        public final void setSapoData(String sapoData) {
            this.sapoData = sapoData;
        }

        @Override
        public final Builder sapoData(String sapoData) {
            this.sapoData = sapoData;
            return this;
        }

        @Override
        public final Builder sapoData(SAPODataConnectorOperator sapoData) {
            this.sapoData(sapoData == null ? null : sapoData.toString());
            return this;
        }

        public final String getCustomConnector() {
            return customConnector;
        }

        public final void setCustomConnector(String customConnector) {
            this.customConnector = customConnector;
        }

        @Override
        public final Builder customConnector(String customConnector) {
            this.customConnector = customConnector;
            return this;
        }

        @Override
        public final Builder customConnector(Operator customConnector) {
            this.customConnector(customConnector == null ? null : customConnector.toString());
            return this;
        }

        @Override
        public ConnectorOperator build() {
            return new ConnectorOperator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
