/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile properties required by each connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorProfileProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorProfileProperties.Builder, ConnectorProfileProperties> {
    private static final SdkField<AmplitudeConnectorProfileProperties> AMPLITUDE_FIELD = SdkField
            .<AmplitudeConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Amplitude")
            .getter(getter(ConnectorProfileProperties::amplitude)).setter(setter(Builder::amplitude))
            .constructor(AmplitudeConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amplitude").build()).build();

    private static final SdkField<DatadogConnectorProfileProperties> DATADOG_FIELD = SdkField
            .<DatadogConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Datadog")
            .getter(getter(ConnectorProfileProperties::datadog)).setter(setter(Builder::datadog))
            .constructor(DatadogConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datadog").build()).build();

    private static final SdkField<DynatraceConnectorProfileProperties> DYNATRACE_FIELD = SdkField
            .<DynatraceConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Dynatrace")
            .getter(getter(ConnectorProfileProperties::dynatrace)).setter(setter(Builder::dynatrace))
            .constructor(DynatraceConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dynatrace").build()).build();

    private static final SdkField<GoogleAnalyticsConnectorProfileProperties> GOOGLE_ANALYTICS_FIELD = SdkField
            .<GoogleAnalyticsConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("GoogleAnalytics")
            .getter(getter(ConnectorProfileProperties::googleAnalytics)).setter(setter(Builder::googleAnalytics))
            .constructor(GoogleAnalyticsConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoogleAnalytics").build()).build();

    private static final SdkField<HoneycodeConnectorProfileProperties> HONEYCODE_FIELD = SdkField
            .<HoneycodeConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Honeycode")
            .getter(getter(ConnectorProfileProperties::honeycode)).setter(setter(Builder::honeycode))
            .constructor(HoneycodeConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Honeycode").build()).build();

    private static final SdkField<InforNexusConnectorProfileProperties> INFOR_NEXUS_FIELD = SdkField
            .<InforNexusConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("InforNexus")
            .getter(getter(ConnectorProfileProperties::inforNexus)).setter(setter(Builder::inforNexus))
            .constructor(InforNexusConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InforNexus").build()).build();

    private static final SdkField<MarketoConnectorProfileProperties> MARKETO_FIELD = SdkField
            .<MarketoConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Marketo")
            .getter(getter(ConnectorProfileProperties::marketo)).setter(setter(Builder::marketo))
            .constructor(MarketoConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()).build();

    private static final SdkField<RedshiftConnectorProfileProperties> REDSHIFT_FIELD = SdkField
            .<RedshiftConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Redshift")
            .getter(getter(ConnectorProfileProperties::redshift)).setter(setter(Builder::redshift))
            .constructor(RedshiftConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redshift").build()).build();

    private static final SdkField<SalesforceConnectorProfileProperties> SALESFORCE_FIELD = SdkField
            .<SalesforceConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Salesforce")
            .getter(getter(ConnectorProfileProperties::salesforce)).setter(setter(Builder::salesforce))
            .constructor(SalesforceConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()).build();

    private static final SdkField<ServiceNowConnectorProfileProperties> SERVICE_NOW_FIELD = SdkField
            .<ServiceNowConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("ServiceNow")
            .getter(getter(ConnectorProfileProperties::serviceNow)).setter(setter(Builder::serviceNow))
            .constructor(ServiceNowConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()).build();

    private static final SdkField<SingularConnectorProfileProperties> SINGULAR_FIELD = SdkField
            .<SingularConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Singular")
            .getter(getter(ConnectorProfileProperties::singular)).setter(setter(Builder::singular))
            .constructor(SingularConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Singular").build()).build();

    private static final SdkField<SlackConnectorProfileProperties> SLACK_FIELD = SdkField
            .<SlackConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Slack")
            .getter(getter(ConnectorProfileProperties::slack)).setter(setter(Builder::slack))
            .constructor(SlackConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slack").build()).build();

    private static final SdkField<SnowflakeConnectorProfileProperties> SNOWFLAKE_FIELD = SdkField
            .<SnowflakeConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Snowflake")
            .getter(getter(ConnectorProfileProperties::snowflake)).setter(setter(Builder::snowflake))
            .constructor(SnowflakeConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snowflake").build()).build();

    private static final SdkField<TrendmicroConnectorProfileProperties> TRENDMICRO_FIELD = SdkField
            .<TrendmicroConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Trendmicro")
            .getter(getter(ConnectorProfileProperties::trendmicro)).setter(setter(Builder::trendmicro))
            .constructor(TrendmicroConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trendmicro").build()).build();

    private static final SdkField<VeevaConnectorProfileProperties> VEEVA_FIELD = SdkField
            .<VeevaConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Veeva")
            .getter(getter(ConnectorProfileProperties::veeva)).setter(setter(Builder::veeva))
            .constructor(VeevaConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Veeva").build()).build();

    private static final SdkField<ZendeskConnectorProfileProperties> ZENDESK_FIELD = SdkField
            .<ZendeskConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("Zendesk")
            .getter(getter(ConnectorProfileProperties::zendesk)).setter(setter(Builder::zendesk))
            .constructor(ZendeskConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()).build();

    private static final SdkField<SAPODataConnectorProfileProperties> SAPO_DATA_FIELD = SdkField
            .<SAPODataConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("SAPOData")
            .getter(getter(ConnectorProfileProperties::sapoData)).setter(setter(Builder::sapoData))
            .constructor(SAPODataConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAPOData").build()).build();

    private static final SdkField<CustomConnectorProfileProperties> CUSTOM_CONNECTOR_FIELD = SdkField
            .<CustomConnectorProfileProperties> builder(MarshallingType.SDK_POJO).memberName("CustomConnector")
            .getter(getter(ConnectorProfileProperties::customConnector)).setter(setter(Builder::customConnector))
            .constructor(CustomConnectorProfileProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomConnector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMPLITUDE_FIELD,
            DATADOG_FIELD, DYNATRACE_FIELD, GOOGLE_ANALYTICS_FIELD, HONEYCODE_FIELD, INFOR_NEXUS_FIELD, MARKETO_FIELD,
            REDSHIFT_FIELD, SALESFORCE_FIELD, SERVICE_NOW_FIELD, SINGULAR_FIELD, SLACK_FIELD, SNOWFLAKE_FIELD, TRENDMICRO_FIELD,
            VEEVA_FIELD, ZENDESK_FIELD, SAPO_DATA_FIELD, CUSTOM_CONNECTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final AmplitudeConnectorProfileProperties amplitude;

    private final DatadogConnectorProfileProperties datadog;

    private final DynatraceConnectorProfileProperties dynatrace;

    private final GoogleAnalyticsConnectorProfileProperties googleAnalytics;

    private final HoneycodeConnectorProfileProperties honeycode;

    private final InforNexusConnectorProfileProperties inforNexus;

    private final MarketoConnectorProfileProperties marketo;

    private final RedshiftConnectorProfileProperties redshift;

    private final SalesforceConnectorProfileProperties salesforce;

    private final ServiceNowConnectorProfileProperties serviceNow;

    private final SingularConnectorProfileProperties singular;

    private final SlackConnectorProfileProperties slack;

    private final SnowflakeConnectorProfileProperties snowflake;

    private final TrendmicroConnectorProfileProperties trendmicro;

    private final VeevaConnectorProfileProperties veeva;

    private final ZendeskConnectorProfileProperties zendesk;

    private final SAPODataConnectorProfileProperties sapoData;

    private final CustomConnectorProfileProperties customConnector;

    private ConnectorProfileProperties(BuilderImpl builder) {
        this.amplitude = builder.amplitude;
        this.datadog = builder.datadog;
        this.dynatrace = builder.dynatrace;
        this.googleAnalytics = builder.googleAnalytics;
        this.honeycode = builder.honeycode;
        this.inforNexus = builder.inforNexus;
        this.marketo = builder.marketo;
        this.redshift = builder.redshift;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.singular = builder.singular;
        this.slack = builder.slack;
        this.snowflake = builder.snowflake;
        this.trendmicro = builder.trendmicro;
        this.veeva = builder.veeva;
        this.zendesk = builder.zendesk;
        this.sapoData = builder.sapoData;
        this.customConnector = builder.customConnector;
    }

    /**
     * <p>
     * The connector-specific properties required by Amplitude.
     * </p>
     * 
     * @return The connector-specific properties required by Amplitude.
     */
    public final AmplitudeConnectorProfileProperties amplitude() {
        return amplitude;
    }

    /**
     * <p>
     * The connector-specific properties required by Datadog.
     * </p>
     * 
     * @return The connector-specific properties required by Datadog.
     */
    public final DatadogConnectorProfileProperties datadog() {
        return datadog;
    }

    /**
     * <p>
     * The connector-specific properties required by Dynatrace.
     * </p>
     * 
     * @return The connector-specific properties required by Dynatrace.
     */
    public final DynatraceConnectorProfileProperties dynatrace() {
        return dynatrace;
    }

    /**
     * <p>
     * The connector-specific properties required Google Analytics.
     * </p>
     * 
     * @return The connector-specific properties required Google Analytics.
     */
    public final GoogleAnalyticsConnectorProfileProperties googleAnalytics() {
        return googleAnalytics;
    }

    /**
     * <p>
     * The connector-specific properties required by Amazon Honeycode.
     * </p>
     * 
     * @return The connector-specific properties required by Amazon Honeycode.
     */
    public final HoneycodeConnectorProfileProperties honeycode() {
        return honeycode;
    }

    /**
     * <p>
     * The connector-specific properties required by Infor Nexus.
     * </p>
     * 
     * @return The connector-specific properties required by Infor Nexus.
     */
    public final InforNexusConnectorProfileProperties inforNexus() {
        return inforNexus;
    }

    /**
     * <p>
     * The connector-specific properties required by Marketo.
     * </p>
     * 
     * @return The connector-specific properties required by Marketo.
     */
    public final MarketoConnectorProfileProperties marketo() {
        return marketo;
    }

    /**
     * <p>
     * The connector-specific properties required by Amazon Redshift.
     * </p>
     * 
     * @return The connector-specific properties required by Amazon Redshift.
     */
    public final RedshiftConnectorProfileProperties redshift() {
        return redshift;
    }

    /**
     * <p>
     * The connector-specific properties required by Salesforce.
     * </p>
     * 
     * @return The connector-specific properties required by Salesforce.
     */
    public final SalesforceConnectorProfileProperties salesforce() {
        return salesforce;
    }

    /**
     * <p>
     * The connector-specific properties required by serviceNow.
     * </p>
     * 
     * @return The connector-specific properties required by serviceNow.
     */
    public final ServiceNowConnectorProfileProperties serviceNow() {
        return serviceNow;
    }

    /**
     * <p>
     * The connector-specific properties required by Singular.
     * </p>
     * 
     * @return The connector-specific properties required by Singular.
     */
    public final SingularConnectorProfileProperties singular() {
        return singular;
    }

    /**
     * <p>
     * The connector-specific properties required by Slack.
     * </p>
     * 
     * @return The connector-specific properties required by Slack.
     */
    public final SlackConnectorProfileProperties slack() {
        return slack;
    }

    /**
     * <p>
     * The connector-specific properties required by Snowflake.
     * </p>
     * 
     * @return The connector-specific properties required by Snowflake.
     */
    public final SnowflakeConnectorProfileProperties snowflake() {
        return snowflake;
    }

    /**
     * <p>
     * The connector-specific properties required by Trend Micro.
     * </p>
     * 
     * @return The connector-specific properties required by Trend Micro.
     */
    public final TrendmicroConnectorProfileProperties trendmicro() {
        return trendmicro;
    }

    /**
     * <p>
     * The connector-specific properties required by Veeva.
     * </p>
     * 
     * @return The connector-specific properties required by Veeva.
     */
    public final VeevaConnectorProfileProperties veeva() {
        return veeva;
    }

    /**
     * <p>
     * The connector-specific properties required by Zendesk.
     * </p>
     * 
     * @return The connector-specific properties required by Zendesk.
     */
    public final ZendeskConnectorProfileProperties zendesk() {
        return zendesk;
    }

    /**
     * Returns the value of the SAPOData property for this object.
     * 
     * @return The value of the SAPOData property for this object.
     */
    public final SAPODataConnectorProfileProperties sapoData() {
        return sapoData;
    }

    /**
     * <p>
     * The properties required by the custom connector.
     * </p>
     * 
     * @return The properties required by the custom connector.
     */
    public final CustomConnectorProfileProperties customConnector() {
        return customConnector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amplitude());
        hashCode = 31 * hashCode + Objects.hashCode(datadog());
        hashCode = 31 * hashCode + Objects.hashCode(dynatrace());
        hashCode = 31 * hashCode + Objects.hashCode(googleAnalytics());
        hashCode = 31 * hashCode + Objects.hashCode(honeycode());
        hashCode = 31 * hashCode + Objects.hashCode(inforNexus());
        hashCode = 31 * hashCode + Objects.hashCode(marketo());
        hashCode = 31 * hashCode + Objects.hashCode(redshift());
        hashCode = 31 * hashCode + Objects.hashCode(salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNow());
        hashCode = 31 * hashCode + Objects.hashCode(singular());
        hashCode = 31 * hashCode + Objects.hashCode(slack());
        hashCode = 31 * hashCode + Objects.hashCode(snowflake());
        hashCode = 31 * hashCode + Objects.hashCode(trendmicro());
        hashCode = 31 * hashCode + Objects.hashCode(veeva());
        hashCode = 31 * hashCode + Objects.hashCode(zendesk());
        hashCode = 31 * hashCode + Objects.hashCode(sapoData());
        hashCode = 31 * hashCode + Objects.hashCode(customConnector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorProfileProperties)) {
            return false;
        }
        ConnectorProfileProperties other = (ConnectorProfileProperties) obj;
        return Objects.equals(amplitude(), other.amplitude()) && Objects.equals(datadog(), other.datadog())
                && Objects.equals(dynatrace(), other.dynatrace()) && Objects.equals(googleAnalytics(), other.googleAnalytics())
                && Objects.equals(honeycode(), other.honeycode()) && Objects.equals(inforNexus(), other.inforNexus())
                && Objects.equals(marketo(), other.marketo()) && Objects.equals(redshift(), other.redshift())
                && Objects.equals(salesforce(), other.salesforce()) && Objects.equals(serviceNow(), other.serviceNow())
                && Objects.equals(singular(), other.singular()) && Objects.equals(slack(), other.slack())
                && Objects.equals(snowflake(), other.snowflake()) && Objects.equals(trendmicro(), other.trendmicro())
                && Objects.equals(veeva(), other.veeva()) && Objects.equals(zendesk(), other.zendesk())
                && Objects.equals(sapoData(), other.sapoData()) && Objects.equals(customConnector(), other.customConnector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorProfileProperties").add("Amplitude", amplitude()).add("Datadog", datadog())
                .add("Dynatrace", dynatrace()).add("GoogleAnalytics", googleAnalytics()).add("Honeycode", honeycode())
                .add("InforNexus", inforNexus()).add("Marketo", marketo()).add("Redshift", redshift())
                .add("Salesforce", salesforce()).add("ServiceNow", serviceNow()).add("Singular", singular())
                .add("Slack", slack()).add("Snowflake", snowflake()).add("Trendmicro", trendmicro()).add("Veeva", veeva())
                .add("Zendesk", zendesk()).add("SAPOData", sapoData()).add("CustomConnector", customConnector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amplitude":
            return Optional.ofNullable(clazz.cast(amplitude()));
        case "Datadog":
            return Optional.ofNullable(clazz.cast(datadog()));
        case "Dynatrace":
            return Optional.ofNullable(clazz.cast(dynatrace()));
        case "GoogleAnalytics":
            return Optional.ofNullable(clazz.cast(googleAnalytics()));
        case "Honeycode":
            return Optional.ofNullable(clazz.cast(honeycode()));
        case "InforNexus":
            return Optional.ofNullable(clazz.cast(inforNexus()));
        case "Marketo":
            return Optional.ofNullable(clazz.cast(marketo()));
        case "Redshift":
            return Optional.ofNullable(clazz.cast(redshift()));
        case "Salesforce":
            return Optional.ofNullable(clazz.cast(salesforce()));
        case "ServiceNow":
            return Optional.ofNullable(clazz.cast(serviceNow()));
        case "Singular":
            return Optional.ofNullable(clazz.cast(singular()));
        case "Slack":
            return Optional.ofNullable(clazz.cast(slack()));
        case "Snowflake":
            return Optional.ofNullable(clazz.cast(snowflake()));
        case "Trendmicro":
            return Optional.ofNullable(clazz.cast(trendmicro()));
        case "Veeva":
            return Optional.ofNullable(clazz.cast(veeva()));
        case "Zendesk":
            return Optional.ofNullable(clazz.cast(zendesk()));
        case "SAPOData":
            return Optional.ofNullable(clazz.cast(sapoData()));
        case "CustomConnector":
            return Optional.ofNullable(clazz.cast(customConnector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorProfileProperties, T> g) {
        return obj -> g.apply((ConnectorProfileProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorProfileProperties> {
        /**
         * <p>
         * The connector-specific properties required by Amplitude.
         * </p>
         * 
         * @param amplitude
         *        The connector-specific properties required by Amplitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amplitude(AmplitudeConnectorProfileProperties amplitude);

        /**
         * <p>
         * The connector-specific properties required by Amplitude.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmplitudeConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link AmplitudeConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmplitudeConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #amplitude(AmplitudeConnectorProfileProperties)}.
         * 
         * @param amplitude
         *        a consumer that will call methods on {@link AmplitudeConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amplitude(AmplitudeConnectorProfileProperties)
         */
        default Builder amplitude(Consumer<AmplitudeConnectorProfileProperties.Builder> amplitude) {
            return amplitude(AmplitudeConnectorProfileProperties.builder().applyMutation(amplitude).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Datadog.
         * </p>
         * 
         * @param datadog
         *        The connector-specific properties required by Datadog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datadog(DatadogConnectorProfileProperties datadog);

        /**
         * <p>
         * The connector-specific properties required by Datadog.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatadogConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link DatadogConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatadogConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #datadog(DatadogConnectorProfileProperties)}.
         * 
         * @param datadog
         *        a consumer that will call methods on {@link DatadogConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datadog(DatadogConnectorProfileProperties)
         */
        default Builder datadog(Consumer<DatadogConnectorProfileProperties.Builder> datadog) {
            return datadog(DatadogConnectorProfileProperties.builder().applyMutation(datadog).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Dynatrace.
         * </p>
         * 
         * @param dynatrace
         *        The connector-specific properties required by Dynatrace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynatrace(DynatraceConnectorProfileProperties dynatrace);

        /**
         * <p>
         * The connector-specific properties required by Dynatrace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DynatraceConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link DynatraceConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynatraceConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #dynatrace(DynatraceConnectorProfileProperties)}.
         * 
         * @param dynatrace
         *        a consumer that will call methods on {@link DynatraceConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynatrace(DynatraceConnectorProfileProperties)
         */
        default Builder dynatrace(Consumer<DynatraceConnectorProfileProperties.Builder> dynatrace) {
            return dynatrace(DynatraceConnectorProfileProperties.builder().applyMutation(dynatrace).build());
        }

        /**
         * <p>
         * The connector-specific properties required Google Analytics.
         * </p>
         * 
         * @param googleAnalytics
         *        The connector-specific properties required Google Analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder googleAnalytics(GoogleAnalyticsConnectorProfileProperties googleAnalytics);

        /**
         * <p>
         * The connector-specific properties required Google Analytics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GoogleAnalyticsConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link GoogleAnalyticsConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GoogleAnalyticsConnectorProfileProperties.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #googleAnalytics(GoogleAnalyticsConnectorProfileProperties)}.
         * 
         * @param googleAnalytics
         *        a consumer that will call methods on {@link GoogleAnalyticsConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #googleAnalytics(GoogleAnalyticsConnectorProfileProperties)
         */
        default Builder googleAnalytics(Consumer<GoogleAnalyticsConnectorProfileProperties.Builder> googleAnalytics) {
            return googleAnalytics(GoogleAnalyticsConnectorProfileProperties.builder().applyMutation(googleAnalytics).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Amazon Honeycode.
         * </p>
         * 
         * @param honeycode
         *        The connector-specific properties required by Amazon Honeycode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honeycode(HoneycodeConnectorProfileProperties honeycode);

        /**
         * <p>
         * The connector-specific properties required by Amazon Honeycode.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link HoneycodeConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link HoneycodeConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HoneycodeConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #honeycode(HoneycodeConnectorProfileProperties)}.
         * 
         * @param honeycode
         *        a consumer that will call methods on {@link HoneycodeConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #honeycode(HoneycodeConnectorProfileProperties)
         */
        default Builder honeycode(Consumer<HoneycodeConnectorProfileProperties.Builder> honeycode) {
            return honeycode(HoneycodeConnectorProfileProperties.builder().applyMutation(honeycode).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Infor Nexus.
         * </p>
         * 
         * @param inforNexus
         *        The connector-specific properties required by Infor Nexus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inforNexus(InforNexusConnectorProfileProperties inforNexus);

        /**
         * <p>
         * The connector-specific properties required by Infor Nexus.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InforNexusConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link InforNexusConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InforNexusConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #inforNexus(InforNexusConnectorProfileProperties)}.
         * 
         * @param inforNexus
         *        a consumer that will call methods on {@link InforNexusConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inforNexus(InforNexusConnectorProfileProperties)
         */
        default Builder inforNexus(Consumer<InforNexusConnectorProfileProperties.Builder> inforNexus) {
            return inforNexus(InforNexusConnectorProfileProperties.builder().applyMutation(inforNexus).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Marketo.
         * </p>
         * 
         * @param marketo
         *        The connector-specific properties required by Marketo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketo(MarketoConnectorProfileProperties marketo);

        /**
         * <p>
         * The connector-specific properties required by Marketo.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MarketoConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link MarketoConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MarketoConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #marketo(MarketoConnectorProfileProperties)}.
         * 
         * @param marketo
         *        a consumer that will call methods on {@link MarketoConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketo(MarketoConnectorProfileProperties)
         */
        default Builder marketo(Consumer<MarketoConnectorProfileProperties.Builder> marketo) {
            return marketo(MarketoConnectorProfileProperties.builder().applyMutation(marketo).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Amazon Redshift.
         * </p>
         * 
         * @param redshift
         *        The connector-specific properties required by Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshift(RedshiftConnectorProfileProperties redshift);

        /**
         * <p>
         * The connector-specific properties required by Amazon Redshift.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RedshiftConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link RedshiftConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #redshift(RedshiftConnectorProfileProperties)}.
         * 
         * @param redshift
         *        a consumer that will call methods on {@link RedshiftConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshift(RedshiftConnectorProfileProperties)
         */
        default Builder redshift(Consumer<RedshiftConnectorProfileProperties.Builder> redshift) {
            return redshift(RedshiftConnectorProfileProperties.builder().applyMutation(redshift).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Salesforce.
         * </p>
         * 
         * @param salesforce
         *        The connector-specific properties required by Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforce(SalesforceConnectorProfileProperties salesforce);

        /**
         * <p>
         * The connector-specific properties required by Salesforce.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SalesforceConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link SalesforceConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SalesforceConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #salesforce(SalesforceConnectorProfileProperties)}.
         * 
         * @param salesforce
         *        a consumer that will call methods on {@link SalesforceConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforce(SalesforceConnectorProfileProperties)
         */
        default Builder salesforce(Consumer<SalesforceConnectorProfileProperties.Builder> salesforce) {
            return salesforce(SalesforceConnectorProfileProperties.builder().applyMutation(salesforce).build());
        }

        /**
         * <p>
         * The connector-specific properties required by serviceNow.
         * </p>
         * 
         * @param serviceNow
         *        The connector-specific properties required by serviceNow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNow(ServiceNowConnectorProfileProperties serviceNow);

        /**
         * <p>
         * The connector-specific properties required by serviceNow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceNowConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link ServiceNowConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceNowConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceNow(ServiceNowConnectorProfileProperties)}.
         * 
         * @param serviceNow
         *        a consumer that will call methods on {@link ServiceNowConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNow(ServiceNowConnectorProfileProperties)
         */
        default Builder serviceNow(Consumer<ServiceNowConnectorProfileProperties.Builder> serviceNow) {
            return serviceNow(ServiceNowConnectorProfileProperties.builder().applyMutation(serviceNow).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Singular.
         * </p>
         * 
         * @param singular
         *        The connector-specific properties required by Singular.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singular(SingularConnectorProfileProperties singular);

        /**
         * <p>
         * The connector-specific properties required by Singular.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SingularConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link SingularConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingularConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #singular(SingularConnectorProfileProperties)}.
         * 
         * @param singular
         *        a consumer that will call methods on {@link SingularConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singular(SingularConnectorProfileProperties)
         */
        default Builder singular(Consumer<SingularConnectorProfileProperties.Builder> singular) {
            return singular(SingularConnectorProfileProperties.builder().applyMutation(singular).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Slack.
         * </p>
         * 
         * @param slack
         *        The connector-specific properties required by Slack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slack(SlackConnectorProfileProperties slack);

        /**
         * <p>
         * The connector-specific properties required by Slack.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlackConnectorProfileProperties.Builder}
         * avoiding the need to create one manually via {@link SlackConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlackConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #slack(SlackConnectorProfileProperties)}.
         * 
         * @param slack
         *        a consumer that will call methods on {@link SlackConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slack(SlackConnectorProfileProperties)
         */
        default Builder slack(Consumer<SlackConnectorProfileProperties.Builder> slack) {
            return slack(SlackConnectorProfileProperties.builder().applyMutation(slack).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Snowflake.
         * </p>
         * 
         * @param snowflake
         *        The connector-specific properties required by Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflake(SnowflakeConnectorProfileProperties snowflake);

        /**
         * <p>
         * The connector-specific properties required by Snowflake.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SnowflakeConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link SnowflakeConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #snowflake(SnowflakeConnectorProfileProperties)}.
         * 
         * @param snowflake
         *        a consumer that will call methods on {@link SnowflakeConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowflake(SnowflakeConnectorProfileProperties)
         */
        default Builder snowflake(Consumer<SnowflakeConnectorProfileProperties.Builder> snowflake) {
            return snowflake(SnowflakeConnectorProfileProperties.builder().applyMutation(snowflake).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Trend Micro.
         * </p>
         * 
         * @param trendmicro
         *        The connector-specific properties required by Trend Micro.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendmicro(TrendmicroConnectorProfileProperties trendmicro);

        /**
         * <p>
         * The connector-specific properties required by Trend Micro.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TrendmicroConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link TrendmicroConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrendmicroConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #trendmicro(TrendmicroConnectorProfileProperties)}.
         * 
         * @param trendmicro
         *        a consumer that will call methods on {@link TrendmicroConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trendmicro(TrendmicroConnectorProfileProperties)
         */
        default Builder trendmicro(Consumer<TrendmicroConnectorProfileProperties.Builder> trendmicro) {
            return trendmicro(TrendmicroConnectorProfileProperties.builder().applyMutation(trendmicro).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Veeva.
         * </p>
         * 
         * @param veeva
         *        The connector-specific properties required by Veeva.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder veeva(VeevaConnectorProfileProperties veeva);

        /**
         * <p>
         * The connector-specific properties required by Veeva.
         * </p>
         * This is a convenience method that creates an instance of the {@link VeevaConnectorProfileProperties.Builder}
         * avoiding the need to create one manually via {@link VeevaConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VeevaConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #veeva(VeevaConnectorProfileProperties)}.
         * 
         * @param veeva
         *        a consumer that will call methods on {@link VeevaConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #veeva(VeevaConnectorProfileProperties)
         */
        default Builder veeva(Consumer<VeevaConnectorProfileProperties.Builder> veeva) {
            return veeva(VeevaConnectorProfileProperties.builder().applyMutation(veeva).build());
        }

        /**
         * <p>
         * The connector-specific properties required by Zendesk.
         * </p>
         * 
         * @param zendesk
         *        The connector-specific properties required by Zendesk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zendesk(ZendeskConnectorProfileProperties zendesk);

        /**
         * <p>
         * The connector-specific properties required by Zendesk.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ZendeskConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link ZendeskConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZendeskConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #zendesk(ZendeskConnectorProfileProperties)}.
         * 
         * @param zendesk
         *        a consumer that will call methods on {@link ZendeskConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zendesk(ZendeskConnectorProfileProperties)
         */
        default Builder zendesk(Consumer<ZendeskConnectorProfileProperties.Builder> zendesk) {
            return zendesk(ZendeskConnectorProfileProperties.builder().applyMutation(zendesk).build());
        }

        /**
         * Sets the value of the SAPOData property for this object.
         *
         * @param sapoData
         *        The new value for the SAPOData property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sapoData(SAPODataConnectorProfileProperties sapoData);

        /**
         * Sets the value of the SAPOData property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link SAPODataConnectorProfileProperties.Builder} avoiding the need to create one manually via
         * {@link SAPODataConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SAPODataConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #sapoData(SAPODataConnectorProfileProperties)}.
         * 
         * @param sapoData
         *        a consumer that will call methods on {@link SAPODataConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sapoData(SAPODataConnectorProfileProperties)
         */
        default Builder sapoData(Consumer<SAPODataConnectorProfileProperties.Builder> sapoData) {
            return sapoData(SAPODataConnectorProfileProperties.builder().applyMutation(sapoData).build());
        }

        /**
         * <p>
         * The properties required by the custom connector.
         * </p>
         * 
         * @param customConnector
         *        The properties required by the custom connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customConnector(CustomConnectorProfileProperties customConnector);

        /**
         * <p>
         * The properties required by the custom connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomConnectorProfileProperties.Builder}
         * avoiding the need to create one manually via {@link CustomConnectorProfileProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomConnectorProfileProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #customConnector(CustomConnectorProfileProperties)}.
         * 
         * @param customConnector
         *        a consumer that will call methods on {@link CustomConnectorProfileProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customConnector(CustomConnectorProfileProperties)
         */
        default Builder customConnector(Consumer<CustomConnectorProfileProperties.Builder> customConnector) {
            return customConnector(CustomConnectorProfileProperties.builder().applyMutation(customConnector).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmplitudeConnectorProfileProperties amplitude;

        private DatadogConnectorProfileProperties datadog;

        private DynatraceConnectorProfileProperties dynatrace;

        private GoogleAnalyticsConnectorProfileProperties googleAnalytics;

        private HoneycodeConnectorProfileProperties honeycode;

        private InforNexusConnectorProfileProperties inforNexus;

        private MarketoConnectorProfileProperties marketo;

        private RedshiftConnectorProfileProperties redshift;

        private SalesforceConnectorProfileProperties salesforce;

        private ServiceNowConnectorProfileProperties serviceNow;

        private SingularConnectorProfileProperties singular;

        private SlackConnectorProfileProperties slack;

        private SnowflakeConnectorProfileProperties snowflake;

        private TrendmicroConnectorProfileProperties trendmicro;

        private VeevaConnectorProfileProperties veeva;

        private ZendeskConnectorProfileProperties zendesk;

        private SAPODataConnectorProfileProperties sapoData;

        private CustomConnectorProfileProperties customConnector;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorProfileProperties model) {
            amplitude(model.amplitude);
            datadog(model.datadog);
            dynatrace(model.dynatrace);
            googleAnalytics(model.googleAnalytics);
            honeycode(model.honeycode);
            inforNexus(model.inforNexus);
            marketo(model.marketo);
            redshift(model.redshift);
            salesforce(model.salesforce);
            serviceNow(model.serviceNow);
            singular(model.singular);
            slack(model.slack);
            snowflake(model.snowflake);
            trendmicro(model.trendmicro);
            veeva(model.veeva);
            zendesk(model.zendesk);
            sapoData(model.sapoData);
            customConnector(model.customConnector);
        }

        public final AmplitudeConnectorProfileProperties.Builder getAmplitude() {
            return amplitude != null ? amplitude.toBuilder() : null;
        }

        public final void setAmplitude(AmplitudeConnectorProfileProperties.BuilderImpl amplitude) {
            this.amplitude = amplitude != null ? amplitude.build() : null;
        }

        @Override
        public final Builder amplitude(AmplitudeConnectorProfileProperties amplitude) {
            this.amplitude = amplitude;
            return this;
        }

        public final DatadogConnectorProfileProperties.Builder getDatadog() {
            return datadog != null ? datadog.toBuilder() : null;
        }

        public final void setDatadog(DatadogConnectorProfileProperties.BuilderImpl datadog) {
            this.datadog = datadog != null ? datadog.build() : null;
        }

        @Override
        public final Builder datadog(DatadogConnectorProfileProperties datadog) {
            this.datadog = datadog;
            return this;
        }

        public final DynatraceConnectorProfileProperties.Builder getDynatrace() {
            return dynatrace != null ? dynatrace.toBuilder() : null;
        }

        public final void setDynatrace(DynatraceConnectorProfileProperties.BuilderImpl dynatrace) {
            this.dynatrace = dynatrace != null ? dynatrace.build() : null;
        }

        @Override
        public final Builder dynatrace(DynatraceConnectorProfileProperties dynatrace) {
            this.dynatrace = dynatrace;
            return this;
        }

        public final GoogleAnalyticsConnectorProfileProperties.Builder getGoogleAnalytics() {
            return googleAnalytics != null ? googleAnalytics.toBuilder() : null;
        }

        public final void setGoogleAnalytics(GoogleAnalyticsConnectorProfileProperties.BuilderImpl googleAnalytics) {
            this.googleAnalytics = googleAnalytics != null ? googleAnalytics.build() : null;
        }

        @Override
        public final Builder googleAnalytics(GoogleAnalyticsConnectorProfileProperties googleAnalytics) {
            this.googleAnalytics = googleAnalytics;
            return this;
        }

        public final HoneycodeConnectorProfileProperties.Builder getHoneycode() {
            return honeycode != null ? honeycode.toBuilder() : null;
        }

        public final void setHoneycode(HoneycodeConnectorProfileProperties.BuilderImpl honeycode) {
            this.honeycode = honeycode != null ? honeycode.build() : null;
        }

        @Override
        public final Builder honeycode(HoneycodeConnectorProfileProperties honeycode) {
            this.honeycode = honeycode;
            return this;
        }

        public final InforNexusConnectorProfileProperties.Builder getInforNexus() {
            return inforNexus != null ? inforNexus.toBuilder() : null;
        }

        public final void setInforNexus(InforNexusConnectorProfileProperties.BuilderImpl inforNexus) {
            this.inforNexus = inforNexus != null ? inforNexus.build() : null;
        }

        @Override
        public final Builder inforNexus(InforNexusConnectorProfileProperties inforNexus) {
            this.inforNexus = inforNexus;
            return this;
        }

        public final MarketoConnectorProfileProperties.Builder getMarketo() {
            return marketo != null ? marketo.toBuilder() : null;
        }

        public final void setMarketo(MarketoConnectorProfileProperties.BuilderImpl marketo) {
            this.marketo = marketo != null ? marketo.build() : null;
        }

        @Override
        public final Builder marketo(MarketoConnectorProfileProperties marketo) {
            this.marketo = marketo;
            return this;
        }

        public final RedshiftConnectorProfileProperties.Builder getRedshift() {
            return redshift != null ? redshift.toBuilder() : null;
        }

        public final void setRedshift(RedshiftConnectorProfileProperties.BuilderImpl redshift) {
            this.redshift = redshift != null ? redshift.build() : null;
        }

        @Override
        public final Builder redshift(RedshiftConnectorProfileProperties redshift) {
            this.redshift = redshift;
            return this;
        }

        public final SalesforceConnectorProfileProperties.Builder getSalesforce() {
            return salesforce != null ? salesforce.toBuilder() : null;
        }

        public final void setSalesforce(SalesforceConnectorProfileProperties.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        public final Builder salesforce(SalesforceConnectorProfileProperties salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final ServiceNowConnectorProfileProperties.Builder getServiceNow() {
            return serviceNow != null ? serviceNow.toBuilder() : null;
        }

        public final void setServiceNow(ServiceNowConnectorProfileProperties.BuilderImpl serviceNow) {
            this.serviceNow = serviceNow != null ? serviceNow.build() : null;
        }

        @Override
        public final Builder serviceNow(ServiceNowConnectorProfileProperties serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        public final SingularConnectorProfileProperties.Builder getSingular() {
            return singular != null ? singular.toBuilder() : null;
        }

        public final void setSingular(SingularConnectorProfileProperties.BuilderImpl singular) {
            this.singular = singular != null ? singular.build() : null;
        }

        @Override
        public final Builder singular(SingularConnectorProfileProperties singular) {
            this.singular = singular;
            return this;
        }

        public final SlackConnectorProfileProperties.Builder getSlack() {
            return slack != null ? slack.toBuilder() : null;
        }

        public final void setSlack(SlackConnectorProfileProperties.BuilderImpl slack) {
            this.slack = slack != null ? slack.build() : null;
        }

        @Override
        public final Builder slack(SlackConnectorProfileProperties slack) {
            this.slack = slack;
            return this;
        }

        public final SnowflakeConnectorProfileProperties.Builder getSnowflake() {
            return snowflake != null ? snowflake.toBuilder() : null;
        }

        public final void setSnowflake(SnowflakeConnectorProfileProperties.BuilderImpl snowflake) {
            this.snowflake = snowflake != null ? snowflake.build() : null;
        }

        @Override
        public final Builder snowflake(SnowflakeConnectorProfileProperties snowflake) {
            this.snowflake = snowflake;
            return this;
        }

        public final TrendmicroConnectorProfileProperties.Builder getTrendmicro() {
            return trendmicro != null ? trendmicro.toBuilder() : null;
        }

        public final void setTrendmicro(TrendmicroConnectorProfileProperties.BuilderImpl trendmicro) {
            this.trendmicro = trendmicro != null ? trendmicro.build() : null;
        }

        @Override
        public final Builder trendmicro(TrendmicroConnectorProfileProperties trendmicro) {
            this.trendmicro = trendmicro;
            return this;
        }

        public final VeevaConnectorProfileProperties.Builder getVeeva() {
            return veeva != null ? veeva.toBuilder() : null;
        }

        public final void setVeeva(VeevaConnectorProfileProperties.BuilderImpl veeva) {
            this.veeva = veeva != null ? veeva.build() : null;
        }

        @Override
        public final Builder veeva(VeevaConnectorProfileProperties veeva) {
            this.veeva = veeva;
            return this;
        }

        public final ZendeskConnectorProfileProperties.Builder getZendesk() {
            return zendesk != null ? zendesk.toBuilder() : null;
        }

        public final void setZendesk(ZendeskConnectorProfileProperties.BuilderImpl zendesk) {
            this.zendesk = zendesk != null ? zendesk.build() : null;
        }

        @Override
        public final Builder zendesk(ZendeskConnectorProfileProperties zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        public final SAPODataConnectorProfileProperties.Builder getSapoData() {
            return sapoData != null ? sapoData.toBuilder() : null;
        }

        public final void setSapoData(SAPODataConnectorProfileProperties.BuilderImpl sapoData) {
            this.sapoData = sapoData != null ? sapoData.build() : null;
        }

        @Override
        public final Builder sapoData(SAPODataConnectorProfileProperties sapoData) {
            this.sapoData = sapoData;
            return this;
        }

        public final CustomConnectorProfileProperties.Builder getCustomConnector() {
            return customConnector != null ? customConnector.toBuilder() : null;
        }

        public final void setCustomConnector(CustomConnectorProfileProperties.BuilderImpl customConnector) {
            this.customConnector = customConnector != null ? customConnector.build() : null;
        }

        @Override
        public final Builder customConnector(CustomConnectorProfileProperties customConnector) {
            this.customConnector = customConnector;
            return this;
        }

        @Override
        public ConnectorProfileProperties build() {
            return new ConnectorProfileProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
