/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.appflow.model.CancelFlowExecutionsRequest;
import software.amazon.awssdk.services.appflow.model.CancelFlowExecutionsResponse;
import software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.CreateConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.CreateFlowRequest;
import software.amazon.awssdk.services.appflow.model.CreateFlowResponse;
import software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.DeleteFlowRequest;
import software.amazon.awssdk.services.appflow.model.DeleteFlowResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorResponse;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse;
import software.amazon.awssdk.services.appflow.model.DescribeFlowRequest;
import software.amazon.awssdk.services.appflow.model.DescribeFlowResponse;
import software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest;
import software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesResponse;
import software.amazon.awssdk.services.appflow.model.ListConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.ListConnectorsResponse;
import software.amazon.awssdk.services.appflow.model.ListFlowsRequest;
import software.amazon.awssdk.services.appflow.model.ListFlowsResponse;
import software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appflow.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest;
import software.amazon.awssdk.services.appflow.model.RegisterConnectorResponse;
import software.amazon.awssdk.services.appflow.model.ResetConnectorMetadataCacheRequest;
import software.amazon.awssdk.services.appflow.model.ResetConnectorMetadataCacheResponse;
import software.amazon.awssdk.services.appflow.model.StartFlowRequest;
import software.amazon.awssdk.services.appflow.model.StartFlowResponse;
import software.amazon.awssdk.services.appflow.model.StopFlowRequest;
import software.amazon.awssdk.services.appflow.model.StopFlowResponse;
import software.amazon.awssdk.services.appflow.model.TagResourceRequest;
import software.amazon.awssdk.services.appflow.model.TagResourceResponse;
import software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest;
import software.amazon.awssdk.services.appflow.model.UnregisterConnectorResponse;
import software.amazon.awssdk.services.appflow.model.UntagResourceRequest;
import software.amazon.awssdk.services.appflow.model.UntagResourceResponse;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileResponse;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorRegistrationRequest;
import software.amazon.awssdk.services.appflow.model.UpdateConnectorRegistrationResponse;
import software.amazon.awssdk.services.appflow.model.UpdateFlowRequest;
import software.amazon.awssdk.services.appflow.model.UpdateFlowResponse;
import software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesPublisher;
import software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsPublisher;
import software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsPublisher;
import software.amazon.awssdk.services.appflow.paginators.ListConnectorsPublisher;
import software.amazon.awssdk.services.appflow.paginators.ListFlowsPublisher;

/**
 * Service client for accessing Amazon Appflow asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Welcome to the Amazon AppFlow API reference. This guide is for developers who need detailed information about the
 * Amazon AppFlow API operations, data types, and errors.
 * </p>
 * <p>
 * Amazon AppFlow is a fully managed integration service that enables you to securely transfer data between software as
 * a service (SaaS) applications like Salesforce, Marketo, Slack, and ServiceNow, and Amazon Web Services like Amazon S3
 * and Amazon Redshift.
 * </p>
 * <p>
 * Use the following links to get started on the Amazon AppFlow API:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/appflow/1.0/APIReference/API_Operations.html">Actions</a>: An alphabetical list
 * of all Amazon AppFlow API operations.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/appflow/1.0/APIReference/API_Types.html">Data types</a>: An alphabetical list of
 * all Amazon AppFlow data types.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/appflow/1.0/APIReference/CommonParameters.html">Common parameters</a>:
 * Parameters that all Query operations can use.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/appflow/1.0/APIReference/CommonErrors.html">Common errors</a>: Client and server
 * errors that all operations can return.
 * </p>
 * </li>
 * </ul>
 * <p>
 * If you're new to Amazon AppFlow, we recommend that you review the <a
 * href="https://docs.aws.amazon.com/appflow/latest/userguide/what-is-appflow.html">Amazon AppFlow User Guide</a>.
 * </p>
 * <p>
 * Amazon AppFlow API users can use vendor-specific mechanisms for OAuth, and include applicable OAuth attributes (such
 * as <code>auth-code</code> and <code>redirecturi</code>) with the connector-specific
 * <code>ConnectorProfileProperties</code> when creating a new connector profile using Amazon AppFlow API operations.
 * For example, Salesforce users can refer to the <a
 * href="https://help.salesforce.com/articleView?id=remoteaccess_authenticate.htm"> <i>Authorize Apps with OAuth</i>
 * </a> documentation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppflowAsyncClient extends AwsClient {
    String SERVICE_NAME = "appflow";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "appflow";

    /**
     * <p>
     * Cancels active runs for a flow.
     * </p>
     * <p>
     * You can cancel all of the active runs for a flow, or you can cancel specific runs by providing their IDs.
     * </p>
     * <p>
     * You can cancel a flow run only when the run is in progress. You can't cancel a run that has already completed or
     * failed. You also can't cancel a run that's scheduled to occur but hasn't started yet. To prevent a scheduled run,
     * you can deactivate the flow with the <code>StopFlow</code> action.
     * </p>
     * <p>
     * You cannot resume a run after you cancel it.
     * </p>
     * <p>
     * When you send your request, the status for each run becomes <code>CancelStarted</code>. When the cancellation
     * completes, the status becomes <code>Canceled</code>.
     * </p>
     * <note>
     * <p>
     * When you cancel a run, you still incur charges for any data that the run already processed before the
     * cancellation. If the run had already written some data to the flow destination, then that data remains in the
     * destination. If you configured the flow to use a batch API (such as the Salesforce Bulk API 2.0), then the run
     * will finish reading or writing its entire batch of data after the cancellation. For these operations, the data
     * processing charges for Amazon AppFlow apply. For the pricing information, see <a
     * href="http://aws.amazon.com/appflow/pricing/">Amazon AppFlow pricing</a>.
     * </p>
     * </note>
     *
     * @param cancelFlowExecutionsRequest
     * @return A Java Future containing the result of the CancelFlowExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ThrottlingException API calls have exceeded the maximum allowed API request rate per account and per
     *         Region.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.CancelFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CancelFlowExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelFlowExecutionsResponse> cancelFlowExecutions(
            CancelFlowExecutionsRequest cancelFlowExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels active runs for a flow.
     * </p>
     * <p>
     * You can cancel all of the active runs for a flow, or you can cancel specific runs by providing their IDs.
     * </p>
     * <p>
     * You can cancel a flow run only when the run is in progress. You can't cancel a run that has already completed or
     * failed. You also can't cancel a run that's scheduled to occur but hasn't started yet. To prevent a scheduled run,
     * you can deactivate the flow with the <code>StopFlow</code> action.
     * </p>
     * <p>
     * You cannot resume a run after you cancel it.
     * </p>
     * <p>
     * When you send your request, the status for each run becomes <code>CancelStarted</code>. When the cancellation
     * completes, the status becomes <code>Canceled</code>.
     * </p>
     * <note>
     * <p>
     * When you cancel a run, you still incur charges for any data that the run already processed before the
     * cancellation. If the run had already written some data to the flow destination, then that data remains in the
     * destination. If you configured the flow to use a batch API (such as the Salesforce Bulk API 2.0), then the run
     * will finish reading or writing its entire batch of data after the cancellation. For these operations, the data
     * processing charges for Amazon AppFlow apply. For the pricing information, see <a
     * href="http://aws.amazon.com/appflow/pricing/">Amazon AppFlow pricing</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelFlowExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link CancelFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param cancelFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.CancelFlowExecutionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelFlowExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ThrottlingException API calls have exceeded the maximum allowed API request rate per account and per
     *         Region.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.CancelFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CancelFlowExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelFlowExecutionsResponse> cancelFlowExecutions(
            Consumer<CancelFlowExecutionsRequest.Builder> cancelFlowExecutionsRequest) {
        return cancelFlowExecutions(CancelFlowExecutionsRequest.builder().applyMutation(cancelFlowExecutionsRequest).build());
    }

    /**
     * <p>
     * Creates a new connector profile associated with your Amazon Web Services account. There is a soft quota of 100
     * connector profiles per Amazon Web Services account. If you need more connector profiles than this quota allows,
     * you can submit a request to the Amazon AppFlow team through the Amazon AppFlow support channel. In each connector
     * profile that you create, you can provide the credentials and properties for only one connector.
     * </p>
     *
     * @param createConnectorProfileRequest
     * @return A Java Future containing the result of the CreateConnectorProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.CreateConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorProfileResponse> createConnectorProfile(
            CreateConnectorProfileRequest createConnectorProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new connector profile associated with your Amazon Web Services account. There is a soft quota of 100
     * connector profiles per Amazon Web Services account. If you need more connector profiles than this quota allows,
     * you can submit a request to the Amazon AppFlow team through the Amazon AppFlow support channel. In each connector
     * profile that you create, you can provide the credentials and properties for only one connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConnectorProfileRequest#builder()}
     * </p>
     *
     * @param createConnectorProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.CreateConnectorProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConnectorProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.CreateConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorProfileResponse> createConnectorProfile(
            Consumer<CreateConnectorProfileRequest.Builder> createConnectorProfileRequest) {
        return createConnectorProfile(CreateConnectorProfileRequest.builder().applyMutation(createConnectorProfileRequest)
                .build());
    }

    /**
     * <p>
     * Enables your application to create a new flow using Amazon AppFlow. You must create a connector profile before
     * calling this API. Please note that the Request Syntax below shows syntax for multiple destinations, however, you
     * can only transfer data to one item in this list at a time. Amazon AppFlow does not currently support flows to
     * multiple destinations at once.
     * </p>
     *
     * @param createFlowRequest
     * @return A Java Future containing the result of the CreateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFlowResponse> createFlow(CreateFlowRequest createFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables your application to create a new flow using Amazon AppFlow. You must create a connector profile before
     * calling this API. Please note that the Request Syntax below shows syntax for multiple destinations, however, you
     * can only transfer data to one item in this list at a time. Amazon AppFlow does not currently support flows to
     * multiple destinations at once.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFlowRequest#builder()}
     * </p>
     *
     * @param createFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.CreateFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFlowResponse> createFlow(Consumer<CreateFlowRequest.Builder> createFlowRequest) {
        return createFlow(CreateFlowRequest.builder().applyMutation(createFlowRequest).build());
    }

    /**
     * <p>
     * Enables you to delete an existing connector profile.
     * </p>
     *
     * @param deleteConnectorProfileRequest
     * @return A Java Future containing the result of the DeleteConnectorProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DeleteConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorProfileResponse> deleteConnectorProfile(
            DeleteConnectorProfileRequest deleteConnectorProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to delete an existing connector profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConnectorProfileRequest#builder()}
     * </p>
     *
     * @param deleteConnectorProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConnectorProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DeleteConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorProfileResponse> deleteConnectorProfile(
            Consumer<DeleteConnectorProfileRequest.Builder> deleteConnectorProfileRequest) {
        return deleteConnectorProfile(DeleteConnectorProfileRequest.builder().applyMutation(deleteConnectorProfileRequest)
                .build());
    }

    /**
     * <p>
     * Enables your application to delete an existing flow. Before deleting the flow, Amazon AppFlow validates the
     * request by checking the flow configuration and status. You can delete flows one at a time.
     * </p>
     *
     * @param deleteFlowRequest
     * @return A Java Future containing the result of the DeleteFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFlowResponse> deleteFlow(DeleteFlowRequest deleteFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables your application to delete an existing flow. Before deleting the flow, Amazon AppFlow validates the
     * request by checking the flow configuration and status. You can delete flows one at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFlowRequest#builder()}
     * </p>
     *
     * @param deleteFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DeleteFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFlowResponse> deleteFlow(Consumer<DeleteFlowRequest.Builder> deleteFlowRequest) {
        return deleteFlow(DeleteFlowRequest.builder().applyMutation(deleteFlowRequest).build());
    }

    /**
     * <p>
     * Describes the given custom connector registered in your Amazon Web Services account. This API can be used for
     * custom connectors that are registered in your account and also for Amazon authored connectors.
     * </p>
     *
     * @param describeConnectorRequest
     * @return A Java Future containing the result of the DescribeConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeConnectorResponse> describeConnector(DescribeConnectorRequest describeConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the given custom connector registered in your Amazon Web Services account. This API can be used for
     * custom connectors that are registered in your account and also for Amazon authored connectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeConnectorRequest#builder()}
     * </p>
     *
     * @param describeConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeConnectorResponse> describeConnector(
            Consumer<DescribeConnectorRequest.Builder> describeConnectorRequest) {
        return describeConnector(DescribeConnectorRequest.builder().applyMutation(describeConnectorRequest).build());
    }

    /**
     * <p>
     * Provides details regarding the entity used with the connector, with a description of the data model for each
     * field in that entity.
     * </p>
     *
     * @param describeConnectorEntityRequest
     * @return A Java Future containing the result of the DescribeConnectorEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectorEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorEntity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorEntityResponse> describeConnectorEntity(
            DescribeConnectorEntityRequest describeConnectorEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details regarding the entity used with the connector, with a description of the data model for each
     * field in that entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorEntityRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConnectorEntityRequest#builder()}
     * </p>
     *
     * @param describeConnectorEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DescribeConnectorEntityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConnectorEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectorEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorEntity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorEntityResponse> describeConnectorEntity(
            Consumer<DescribeConnectorEntityRequest.Builder> describeConnectorEntityRequest) {
        return describeConnectorEntity(DescribeConnectorEntityRequest.builder().applyMutation(describeConnectorEntityRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>connector-profile</code> details matching the provided <code>connector-profile</code>
     * names and <code>connector-types</code>. Both input lists are optional, and you can use them to filter the result.
     * </p>
     * <p>
     * If no names or <code>connector-types</code> are provided, returns all connector profiles in a paginated form. If
     * there is no match, this operation returns an empty list.
     * </p>
     *
     * @param describeConnectorProfilesRequest
     * @return A Java Future containing the result of the DescribeConnectorProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectorProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorProfilesResponse> describeConnectorProfiles(
            DescribeConnectorProfilesRequest describeConnectorProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>connector-profile</code> details matching the provided <code>connector-profile</code>
     * names and <code>connector-types</code>. Both input lists are optional, and you can use them to filter the result.
     * </p>
     * <p>
     * If no names or <code>connector-types</code> are provided, returns all connector profiles in a paginated form. If
     * there is no match, this operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConnectorProfilesRequest#builder()}
     * </p>
     *
     * @param describeConnectorProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConnectorProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectorProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorProfilesResponse> describeConnectorProfiles(
            Consumer<DescribeConnectorProfilesRequest.Builder> describeConnectorProfilesRequest) {
        return describeConnectorProfiles(DescribeConnectorProfilesRequest.builder()
                .applyMutation(describeConnectorProfilesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>connector-profile</code> details matching the provided <code>connector-profile</code>
     * names and <code>connector-types</code>. Both input lists are optional, and you can use them to filter the result.
     * </p>
     * <p>
     * If no names or <code>connector-types</code> are provided, returns all connector profiles in a paginated form. If
     * there is no match, this operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnectorProfiles(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesPublisher publisher = client.describeConnectorProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesPublisher publisher = client.describeConnectorProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnectorProfiles(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConnectorProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectorProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorProfilesPublisher describeConnectorProfilesPaginator(
            DescribeConnectorProfilesRequest describeConnectorProfilesRequest) {
        return new DescribeConnectorProfilesPublisher(this, describeConnectorProfilesRequest);
    }

    /**
     * <p>
     * Returns a list of <code>connector-profile</code> details matching the provided <code>connector-profile</code>
     * names and <code>connector-types</code>. Both input lists are optional, and you can use them to filter the result.
     * </p>
     * <p>
     * If no names or <code>connector-types</code> are provided, returns all connector profiles in a paginated form. If
     * there is no match, this operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnectorProfiles(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesPublisher publisher = client.describeConnectorProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorProfilesPublisher publisher = client.describeConnectorProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnectorProfiles(software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConnectorProfilesRequest#builder()}
     * </p>
     *
     * @param describeConnectorProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectorProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectorProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorProfilesPublisher describeConnectorProfilesPaginator(
            Consumer<DescribeConnectorProfilesRequest.Builder> describeConnectorProfilesRequest) {
        return describeConnectorProfilesPaginator(DescribeConnectorProfilesRequest.builder()
                .applyMutation(describeConnectorProfilesRequest).build());
    }

    /**
     * <p>
     * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector
     * type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be
     * returned in one page, the response contains a <code>nextToken</code> object, which can be be passed in to the
     * next call to the <code>DescribeConnectors</code> API operation to retrieve the next page.
     * </p>
     *
     * @param describeConnectorsRequest
     * @return A Java Future containing the result of the DescribeConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorsResponse> describeConnectors(DescribeConnectorsRequest describeConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector
     * type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be
     * returned in one page, the response contains a <code>nextToken</code> object, which can be be passed in to the
     * next call to the <code>DescribeConnectors</code> API operation to retrieve the next page.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectorsRequest#builder()}
     * </p>
     *
     * @param describeConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorsResponse> describeConnectors(
            Consumer<DescribeConnectorsRequest.Builder> describeConnectorsRequest) {
        return describeConnectors(DescribeConnectorsRequest.builder().applyMutation(describeConnectorsRequest).build());
    }

    /**
     * <p>
     * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector
     * type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be
     * returned in one page, the response contains a <code>nextToken</code> object, which can be be passed in to the
     * next call to the <code>DescribeConnectors</code> API operation to retrieve the next page.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnectors(software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsPublisher publisher = client.describeConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsPublisher publisher = client.describeConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnectors(software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConnectorsPublisher describeConnectorsPaginator(DescribeConnectorsRequest describeConnectorsRequest) {
        return new DescribeConnectorsPublisher(this, describeConnectorsRequest);
    }

    /**
     * <p>
     * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector
     * type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be
     * returned in one page, the response contains a <code>nextToken</code> object, which can be be passed in to the
     * next call to the <code>DescribeConnectors</code> API operation to retrieve the next page.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnectors(software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsPublisher publisher = client.describeConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeConnectorsPublisher publisher = client.describeConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnectors(software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectorsRequest#builder()}
     * </p>
     *
     * @param describeConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConnectorsPublisher describeConnectorsPaginator(
            Consumer<DescribeConnectorsRequest.Builder> describeConnectorsRequest) {
        return describeConnectorsPaginator(DescribeConnectorsRequest.builder().applyMutation(describeConnectorsRequest).build());
    }

    /**
     * <p>
     * Provides a description of the specified flow.
     * </p>
     *
     * @param describeFlowRequest
     * @return A Java Future containing the result of the DescribeFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFlowResponse> describeFlow(DescribeFlowRequest describeFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a description of the specified flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFlowRequest#builder()}
     * </p>
     *
     * @param describeFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DescribeFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFlowResponse> describeFlow(Consumer<DescribeFlowRequest.Builder> describeFlowRequest) {
        return describeFlow(DescribeFlowRequest.builder().applyMutation(describeFlowRequest).build());
    }

    /**
     * <p>
     * Fetches the execution history of the flow.
     * </p>
     *
     * @param describeFlowExecutionRecordsRequest
     * @return A Java Future containing the result of the DescribeFlowExecutionRecords operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeFlowExecutionRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFlowExecutionRecordsResponse> describeFlowExecutionRecords(
            DescribeFlowExecutionRecordsRequest describeFlowExecutionRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the execution history of the flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowExecutionRecordsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFlowExecutionRecordsRequest#builder()}
     * </p>
     *
     * @param describeFlowExecutionRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeFlowExecutionRecords operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeFlowExecutionRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFlowExecutionRecordsResponse> describeFlowExecutionRecords(
            Consumer<DescribeFlowExecutionRecordsRequest.Builder> describeFlowExecutionRecordsRequest) {
        return describeFlowExecutionRecords(DescribeFlowExecutionRecordsRequest.builder()
                .applyMutation(describeFlowExecutionRecordsRequest).build());
    }

    /**
     * <p>
     * Fetches the execution history of the flow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFlowExecutionRecords(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsPublisher publisher = client.describeFlowExecutionRecordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsPublisher publisher = client.describeFlowExecutionRecordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFlowExecutionRecords(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFlowExecutionRecordsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeFlowExecutionRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowExecutionRecordsPublisher describeFlowExecutionRecordsPaginator(
            DescribeFlowExecutionRecordsRequest describeFlowExecutionRecordsRequest) {
        return new DescribeFlowExecutionRecordsPublisher(this, describeFlowExecutionRecordsRequest);
    }

    /**
     * <p>
     * Fetches the execution history of the flow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFlowExecutionRecords(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsPublisher publisher = client.describeFlowExecutionRecordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.DescribeFlowExecutionRecordsPublisher publisher = client.describeFlowExecutionRecordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFlowExecutionRecords(software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowExecutionRecordsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFlowExecutionRecordsRequest#builder()}
     * </p>
     *
     * @param describeFlowExecutionRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.DescribeFlowExecutionRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/DescribeFlowExecutionRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowExecutionRecordsPublisher describeFlowExecutionRecordsPaginator(
            Consumer<DescribeFlowExecutionRecordsRequest.Builder> describeFlowExecutionRecordsRequest) {
        return describeFlowExecutionRecordsPaginator(DescribeFlowExecutionRecordsRequest.builder()
                .applyMutation(describeFlowExecutionRecordsRequest).build());
    }

    /**
     * <p>
     * Returns the list of available connector entities supported by Amazon AppFlow. For example, you can query
     * Salesforce for <i>Account</i> and <i>Opportunity</i> entities, or query ServiceNow for the <i>Incident</i>
     * entity.
     * </p>
     *
     * @param listConnectorEntitiesRequest
     * @return A Java Future containing the result of the ListConnectorEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListConnectorEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectorEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConnectorEntitiesResponse> listConnectorEntities(
            ListConnectorEntitiesRequest listConnectorEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of available connector entities supported by Amazon AppFlow. For example, you can query
     * Salesforce for <i>Account</i> and <i>Opportunity</i> entities, or query ServiceNow for the <i>Incident</i>
     * entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListConnectorEntitiesRequest#builder()}
     * </p>
     *
     * @param listConnectorEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConnectorEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListConnectorEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectorEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConnectorEntitiesResponse> listConnectorEntities(
            Consumer<ListConnectorEntitiesRequest.Builder> listConnectorEntitiesRequest) {
        return listConnectorEntities(ListConnectorEntitiesRequest.builder().applyMutation(listConnectorEntitiesRequest).build());
    }

    /**
     * <p>
     * Returns the list of all registered custom connectors in your Amazon Web Services account. This API lists only
     * custom connectors registered in this account, not the Amazon Web Services authored connectors.
     * </p>
     *
     * @param listConnectorsRequest
     * @return A Java Future containing the result of the ListConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConnectorsResponse> listConnectors(ListConnectorsRequest listConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of all registered custom connectors in your Amazon Web Services account. This API lists only
     * custom connectors registered in this account, not the Amazon Web Services authored connectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.ListConnectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConnectorsResponse> listConnectors(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest) {
        return listConnectors(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Returns the list of all registered custom connectors in your Amazon Web Services account. This API lists only
     * custom connectors registered in this account, not the Amazon Web Services authored connectors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listConnectors(software.amazon.awssdk.services.appflow.model.ListConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.ListConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.ListConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.appflow.model.ListConnectorsRequest)} operation.</b>
     * </p>
     *
     * @param listConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectorsPublisher listConnectorsPaginator(ListConnectorsRequest listConnectorsRequest) {
        return new ListConnectorsPublisher(this, listConnectorsRequest);
    }

    /**
     * <p>
     * Returns the list of all registered custom connectors in your Amazon Web Services account. This API lists only
     * custom connectors registered in this account, not the Amazon Web Services authored connectors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listConnectors(software.amazon.awssdk.services.appflow.model.ListConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.ListConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.ListConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.appflow.model.ListConnectorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.ListConnectorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectorsPublisher listConnectorsPaginator(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest) {
        return listConnectorsPaginator(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Lists all of the flows associated with your account.
     * </p>
     *
     * @param listFlowsRequest
     * @return A Java Future containing the result of the ListFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFlowsResponse> listFlows(ListFlowsRequest listFlowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the flows associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlowsRequest#builder()}
     * </p>
     *
     * @param listFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.ListFlowsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFlowsResponse> listFlows(Consumer<ListFlowsRequest.Builder> listFlowsRequest) {
        return listFlows(ListFlowsRequest.builder().applyMutation(listFlowsRequest).build());
    }

    /**
     * <p>
     * Lists all of the flows associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.appflow.model.ListFlowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.ListFlowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.ListFlowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.appflow.model.ListFlowsRequest)} operation.</b>
     * </p>
     *
     * @param listFlowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsPublisher listFlowsPaginator(ListFlowsRequest listFlowsRequest) {
        return new ListFlowsPublisher(this, listFlowsRequest);
    }

    /**
     * <p>
     * Lists all of the flows associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.appflow.model.ListFlowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appflow.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appflow.model.ListFlowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appflow.model.ListFlowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.appflow.model.ListFlowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlowsRequest#builder()}
     * </p>
     *
     * @param listFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.ListFlowsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsPublisher listFlowsPaginator(Consumer<ListFlowsRequest.Builder> listFlowsRequest) {
        return listFlowsPaginator(ListFlowsRequest.builder().applyMutation(listFlowsRequest).build());
    }

    /**
     * <p>
     * Retrieves the tags that are associated with a specified flow.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tags that are associated with a specified flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Registers a new custom connector with your Amazon Web Services account. Before you can register the connector,
     * you must deploy the associated AWS lambda function in your account.
     * </p>
     *
     * @param registerConnectorRequest
     * @return A Java Future containing the result of the RegisterConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ThrottlingException API calls have exceeded the maximum allowed API request rate per account and per
     *         Region.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.RegisterConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/RegisterConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterConnectorResponse> registerConnector(RegisterConnectorRequest registerConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a new custom connector with your Amazon Web Services account. Before you can register the connector,
     * you must deploy the associated AWS lambda function in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterConnectorRequest#builder()}
     * </p>
     *
     * @param registerConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ThrottlingException API calls have exceeded the maximum allowed API request rate per account and per
     *         Region.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.RegisterConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/RegisterConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterConnectorResponse> registerConnector(
            Consumer<RegisterConnectorRequest.Builder> registerConnectorRequest) {
        return registerConnector(RegisterConnectorRequest.builder().applyMutation(registerConnectorRequest).build());
    }

    /**
     * <p>
     * Resets metadata about your connector entities that Amazon AppFlow stored in its cache. Use this action when you
     * want Amazon AppFlow to return the latest information about the data that you have in a source application.
     * </p>
     * <p>
     * Amazon AppFlow returns metadata about your entities when you use the ListConnectorEntities or
     * DescribeConnectorEntities actions. Following these actions, Amazon AppFlow caches the metadata to reduce the
     * number of API requests that it must send to the source application. Amazon AppFlow automatically resets the cache
     * once every hour, but you can use this action when you want to get the latest metadata right away.
     * </p>
     *
     * @param resetConnectorMetadataCacheRequest
     * @return A Java Future containing the result of the ResetConnectorMetadataCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ResetConnectorMetadataCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ResetConnectorMetadataCache"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetConnectorMetadataCacheResponse> resetConnectorMetadataCache(
            ResetConnectorMetadataCacheRequest resetConnectorMetadataCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets metadata about your connector entities that Amazon AppFlow stored in its cache. Use this action when you
     * want Amazon AppFlow to return the latest information about the data that you have in a source application.
     * </p>
     * <p>
     * Amazon AppFlow returns metadata about your entities when you use the ListConnectorEntities or
     * DescribeConnectorEntities actions. Following these actions, Amazon AppFlow caches the metadata to reduce the
     * number of API requests that it must send to the source application. Amazon AppFlow automatically resets the cache
     * once every hour, but you can use this action when you want to get the latest metadata right away.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetConnectorMetadataCacheRequest.Builder}
     * avoiding the need to create one manually via {@link ResetConnectorMetadataCacheRequest#builder()}
     * </p>
     *
     * @param resetConnectorMetadataCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.ResetConnectorMetadataCacheRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ResetConnectorMetadataCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.ResetConnectorMetadataCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ResetConnectorMetadataCache"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetConnectorMetadataCacheResponse> resetConnectorMetadataCache(
            Consumer<ResetConnectorMetadataCacheRequest.Builder> resetConnectorMetadataCacheRequest) {
        return resetConnectorMetadataCache(ResetConnectorMetadataCacheRequest.builder()
                .applyMutation(resetConnectorMetadataCacheRequest).build());
    }

    /**
     * <p>
     * Activates an existing flow. For on-demand flows, this operation runs the flow immediately. For schedule and
     * event-triggered flows, this operation activates the flow.
     * </p>
     *
     * @param startFlowRequest
     * @return A Java Future containing the result of the StartFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartFlowResponse> startFlow(StartFlowRequest startFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an existing flow. For on-demand flows, this operation runs the flow immediately. For schedule and
     * event-triggered flows, this operation activates the flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFlowRequest.Builder} avoiding the need to
     * create one manually via {@link StartFlowRequest#builder()}
     * </p>
     *
     * @param startFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.StartFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartFlowResponse> startFlow(Consumer<StartFlowRequest.Builder> startFlowRequest) {
        return startFlow(StartFlowRequest.builder().applyMutation(startFlowRequest).build());
    }

    /**
     * <p>
     * Deactivates the existing flow. For on-demand flows, this operation returns an
     * <code>unsupportedOperationException</code> error message. For schedule and event-triggered flows, this operation
     * deactivates the flow.
     * </p>
     *
     * @param stopFlowRequest
     * @return A Java Future containing the result of the StopFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for the current flow.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopFlowResponse> stopFlow(StopFlowRequest stopFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates the existing flow. For on-demand flows, this operation returns an
     * <code>unsupportedOperationException</code> error message. For schedule and event-triggered flows, this operation
     * deactivates the flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFlowRequest.Builder} avoiding the need to
     * create one manually via {@link StopFlowRequest#builder()}
     * </p>
     *
     * @param stopFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.StopFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported for the current flow.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopFlowResponse> stopFlow(Consumer<StopFlowRequest.Builder> stopFlowRequest) {
        return stopFlow(StopFlowRequest.builder().applyMutation(stopFlowRequest).build());
    }

    /**
     * <p>
     * Applies a tag to the specified flow.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a tag to the specified flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Unregisters the custom connector registered in your account that matches the connector label provided in the
     * request.
     * </p>
     *
     * @param unregisterConnectorRequest
     * @return A Java Future containing the result of the UnregisterConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UnregisterConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UnregisterConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UnregisterConnectorResponse> unregisterConnector(
            UnregisterConnectorRequest unregisterConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unregisters the custom connector registered in your account that matches the connector label provided in the
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnregisterConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link UnregisterConnectorRequest#builder()}
     * </p>
     *
     * @param unregisterConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.UnregisterConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UnregisterConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UnregisterConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UnregisterConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UnregisterConnectorResponse> unregisterConnector(
            Consumer<UnregisterConnectorRequest.Builder> unregisterConnectorRequest) {
        return unregisterConnector(UnregisterConnectorRequest.builder().applyMutation(unregisterConnectorRequest).build());
    }

    /**
     * <p>
     * Removes a tag from the specified flow.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from the specified flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a given connector profile associated with your account.
     * </p>
     *
     * @param updateConnectorProfileRequest
     * @return A Java Future containing the result of the UpdateConnectorProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UpdateConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorProfileResponse> updateConnectorProfile(
            UpdateConnectorProfileRequest updateConnectorProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a given connector profile associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConnectorProfileRequest#builder()}
     * </p>
     *
     * @param updateConnectorProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateConnectorProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UpdateConnectorProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateConnectorProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorProfileResponse> updateConnectorProfile(
            Consumer<UpdateConnectorProfileRequest.Builder> updateConnectorProfileRequest) {
        return updateConnectorProfile(UpdateConnectorProfileRequest.builder().applyMutation(updateConnectorProfileRequest)
                .build());
    }

    /**
     * <p>
     * Updates a custom connector that you've previously registered. This operation updates the connector with one of
     * the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The latest version of the AWS Lambda function that's assigned to the connector
     * </p>
     * </li>
     * <li>
     * <p>
     * A new AWS Lambda function that you specify
     * </p>
     * </li>
     * </ul>
     *
     * @param updateConnectorRegistrationRequest
     * @return A Java Future containing the result of the UpdateConnectorRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ThrottlingException API calls have exceeded the maximum allowed API request rate per account and per
     *         Region.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UpdateConnectorRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateConnectorRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorRegistrationResponse> updateConnectorRegistration(
            UpdateConnectorRegistrationRequest updateConnectorRegistrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a custom connector that you've previously registered. This operation updates the connector with one of
     * the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The latest version of the AWS Lambda function that's assigned to the connector
     * </p>
     * </li>
     * <li>
     * <p>
     * A new AWS Lambda function that you specify
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorRegistrationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConnectorRegistrationRequest#builder()}
     * </p>
     *
     * @param updateConnectorRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.UpdateConnectorRegistrationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateConnectorRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ThrottlingException API calls have exceeded the maximum allowed API request rate per account and per
     *         Region.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UpdateConnectorRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateConnectorRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorRegistrationResponse> updateConnectorRegistration(
            Consumer<UpdateConnectorRegistrationRequest.Builder> updateConnectorRegistrationRequest) {
        return updateConnectorRegistration(UpdateConnectorRegistrationRequest.builder()
                .applyMutation(updateConnectorRegistrationRequest).build());
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     *
     * @param updateFlowRequest
     * @return A Java Future containing the result of the UpdateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFlowResponse> updateFlow(UpdateFlowRequest updateFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFlowRequest#builder()}
     * </p>
     *
     * @param updateFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appflow.model.UpdateFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource specified in the request (such as the source or destination
     *         connector profile) is not found.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota (such as the number of flows)
     *         to be exceeded.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a flow with the
     *         given name already exists within the account. Check for conflicting resource names and try again.</li>
     *         <li>ConnectorAuthenticationException An error occurred when authenticating with the connector endpoint.</li>
     *         <li>ConnectorServerException An error occurred when retrieving data from the connector endpoint.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException AppFlow/Requester has invalid or missing permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppflowException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppflowAsyncClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFlowResponse> updateFlow(Consumer<UpdateFlowRequest.Builder> updateFlowRequest) {
        return updateFlow(UpdateFlowRequest.builder().applyMutation(updateFlowRequest).build());
    }

    @Override
    default AppflowServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AppflowAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppflowAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppflowAsyncClient}.
     */
    static AppflowAsyncClientBuilder builder() {
        return new DefaultAppflowAsyncClientBuilder();
    }
}
