/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the end result of the flow run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionResult implements SdkPojo, Serializable, ToCopyableBuilder<ExecutionResult.Builder, ExecutionResult> {
    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("errorInfo").getter(getter(ExecutionResult::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final SdkField<Long> BYTES_PROCESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("bytesProcessed").getter(getter(ExecutionResult::bytesProcessed)).setter(setter(Builder::bytesProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesProcessed").build()).build();

    private static final SdkField<Long> BYTES_WRITTEN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("bytesWritten").getter(getter(ExecutionResult::bytesWritten)).setter(setter(Builder::bytesWritten))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesWritten").build()).build();

    private static final SdkField<Long> RECORDS_PROCESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("recordsProcessed").getter(getter(ExecutionResult::recordsProcessed))
            .setter(setter(Builder::recordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsProcessed").build()).build();

    private static final SdkField<Long> NUM_PARALLEL_PROCESSES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numParallelProcesses").getter(getter(ExecutionResult::numParallelProcesses))
            .setter(setter(Builder::numParallelProcesses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numParallelProcesses").build())
            .build();

    private static final SdkField<Long> MAX_PAGE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("maxPageSize").getter(getter(ExecutionResult::maxPageSize)).setter(setter(Builder::maxPageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_INFO_FIELD,
            BYTES_PROCESSED_FIELD, BYTES_WRITTEN_FIELD, RECORDS_PROCESSED_FIELD, NUM_PARALLEL_PROCESSES_FIELD,
            MAX_PAGE_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ErrorInfo errorInfo;

    private final Long bytesProcessed;

    private final Long bytesWritten;

    private final Long recordsProcessed;

    private final Long numParallelProcesses;

    private final Long maxPageSize;

    private ExecutionResult(BuilderImpl builder) {
        this.errorInfo = builder.errorInfo;
        this.bytesProcessed = builder.bytesProcessed;
        this.bytesWritten = builder.bytesWritten;
        this.recordsProcessed = builder.recordsProcessed;
        this.numParallelProcesses = builder.numParallelProcesses;
        this.maxPageSize = builder.maxPageSize;
    }

    /**
     * <p>
     * Provides any error message information related to the flow run.
     * </p>
     * 
     * @return Provides any error message information related to the flow run.
     */
    public final ErrorInfo errorInfo() {
        return errorInfo;
    }

    /**
     * <p>
     * The total number of bytes processed by the flow run.
     * </p>
     * 
     * @return The total number of bytes processed by the flow run.
     */
    public final Long bytesProcessed() {
        return bytesProcessed;
    }

    /**
     * <p>
     * The total number of bytes written as a result of the flow run.
     * </p>
     * 
     * @return The total number of bytes written as a result of the flow run.
     */
    public final Long bytesWritten() {
        return bytesWritten;
    }

    /**
     * <p>
     * The number of records processed in the flow run.
     * </p>
     * 
     * @return The number of records processed in the flow run.
     */
    public final Long recordsProcessed() {
        return recordsProcessed;
    }

    /**
     * <p>
     * The number of processes that Amazon AppFlow ran at the same time when it retrieved your data.
     * </p>
     * 
     * @return The number of processes that Amazon AppFlow ran at the same time when it retrieved your data.
     */
    public final Long numParallelProcesses() {
        return numParallelProcesses;
    }

    /**
     * <p>
     * The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP
     * application.
     * </p>
     * 
     * @return The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP
     *         application.
     */
    public final Long maxPageSize() {
        return maxPageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(bytesProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(bytesWritten());
        hashCode = 31 * hashCode + Objects.hashCode(recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(numParallelProcesses());
        hashCode = 31 * hashCode + Objects.hashCode(maxPageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionResult)) {
            return false;
        }
        ExecutionResult other = (ExecutionResult) obj;
        return Objects.equals(errorInfo(), other.errorInfo()) && Objects.equals(bytesProcessed(), other.bytesProcessed())
                && Objects.equals(bytesWritten(), other.bytesWritten())
                && Objects.equals(recordsProcessed(), other.recordsProcessed())
                && Objects.equals(numParallelProcesses(), other.numParallelProcesses())
                && Objects.equals(maxPageSize(), other.maxPageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionResult").add("ErrorInfo", errorInfo()).add("BytesProcessed", bytesProcessed())
                .add("BytesWritten", bytesWritten()).add("RecordsProcessed", recordsProcessed())
                .add("NumParallelProcesses", numParallelProcesses()).add("MaxPageSize", maxPageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "bytesProcessed":
            return Optional.ofNullable(clazz.cast(bytesProcessed()));
        case "bytesWritten":
            return Optional.ofNullable(clazz.cast(bytesWritten()));
        case "recordsProcessed":
            return Optional.ofNullable(clazz.cast(recordsProcessed()));
        case "numParallelProcesses":
            return Optional.ofNullable(clazz.cast(numParallelProcesses()));
        case "maxPageSize":
            return Optional.ofNullable(clazz.cast(maxPageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionResult, T> g) {
        return obj -> g.apply((ExecutionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionResult> {
        /**
         * <p>
         * Provides any error message information related to the flow run.
         * </p>
         * 
         * @param errorInfo
         *        Provides any error message information related to the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo errorInfo);

        /**
         * <p>
         * Provides any error message information related to the flow run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to
         * create one manually via {@link ErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #errorInfo(ErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(ErrorInfo)
         */
        default Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return errorInfo(ErrorInfo.builder().applyMutation(errorInfo).build());
        }

        /**
         * <p>
         * The total number of bytes processed by the flow run.
         * </p>
         * 
         * @param bytesProcessed
         *        The total number of bytes processed by the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesProcessed(Long bytesProcessed);

        /**
         * <p>
         * The total number of bytes written as a result of the flow run.
         * </p>
         * 
         * @param bytesWritten
         *        The total number of bytes written as a result of the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesWritten(Long bytesWritten);

        /**
         * <p>
         * The number of records processed in the flow run.
         * </p>
         * 
         * @param recordsProcessed
         *        The number of records processed in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsProcessed(Long recordsProcessed);

        /**
         * <p>
         * The number of processes that Amazon AppFlow ran at the same time when it retrieved your data.
         * </p>
         * 
         * @param numParallelProcesses
         *        The number of processes that Amazon AppFlow ran at the same time when it retrieved your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numParallelProcesses(Long numParallelProcesses);

        /**
         * <p>
         * The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP
         * application.
         * </p>
         * 
         * @param maxPageSize
         *        The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPageSize(Long maxPageSize);
    }

    static final class BuilderImpl implements Builder {
        private ErrorInfo errorInfo;

        private Long bytesProcessed;

        private Long bytesWritten;

        private Long recordsProcessed;

        private Long numParallelProcesses;

        private Long maxPageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionResult model) {
            errorInfo(model.errorInfo);
            bytesProcessed(model.bytesProcessed);
            bytesWritten(model.bytesWritten);
            recordsProcessed(model.recordsProcessed);
            numParallelProcesses(model.numParallelProcesses);
            maxPageSize(model.maxPageSize);
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Long getBytesProcessed() {
            return bytesProcessed;
        }

        public final void setBytesProcessed(Long bytesProcessed) {
            this.bytesProcessed = bytesProcessed;
        }

        @Override
        public final Builder bytesProcessed(Long bytesProcessed) {
            this.bytesProcessed = bytesProcessed;
            return this;
        }

        public final Long getBytesWritten() {
            return bytesWritten;
        }

        public final void setBytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
        }

        @Override
        public final Builder bytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
            return this;
        }

        public final Long getRecordsProcessed() {
            return recordsProcessed;
        }

        public final void setRecordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        @Override
        public final Builder recordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final Long getNumParallelProcesses() {
            return numParallelProcesses;
        }

        public final void setNumParallelProcesses(Long numParallelProcesses) {
            this.numParallelProcesses = numParallelProcesses;
        }

        @Override
        public final Builder numParallelProcesses(Long numParallelProcesses) {
            this.numParallelProcesses = numParallelProcesses;
            return this;
        }

        public final Long getMaxPageSize() {
            return maxPageSize;
        }

        public final void setMaxPageSize(Long maxPageSize) {
            this.maxPageSize = maxPageSize;
        }

        @Override
        public final Builder maxPageSize(Long maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this;
        }

        @Override
        public ExecutionResult build() {
            return new ExecutionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
