/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the metadata catalog, metadata table, and data partitions that Amazon AppFlow used for the associated flow
 * run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataCatalogDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataCatalogDetail.Builder, MetadataCatalogDetail> {
    private static final SdkField<String> CATALOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("catalogType").getter(getter(MetadataCatalogDetail::catalogTypeAsString))
            .setter(setter(Builder::catalogType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogType").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(MetadataCatalogDetail::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<RegistrationOutput> TABLE_REGISTRATION_OUTPUT_FIELD = SdkField
            .<RegistrationOutput> builder(MarshallingType.SDK_POJO).memberName("tableRegistrationOutput")
            .getter(getter(MetadataCatalogDetail::tableRegistrationOutput)).setter(setter(Builder::tableRegistrationOutput))
            .constructor(RegistrationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableRegistrationOutput").build())
            .build();

    private static final SdkField<RegistrationOutput> PARTITION_REGISTRATION_OUTPUT_FIELD = SdkField
            .<RegistrationOutput> builder(MarshallingType.SDK_POJO)
            .memberName("partitionRegistrationOutput")
            .getter(getter(MetadataCatalogDetail::partitionRegistrationOutput))
            .setter(setter(Builder::partitionRegistrationOutput))
            .constructor(RegistrationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionRegistrationOutput")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_TYPE_FIELD,
            TABLE_NAME_FIELD, TABLE_REGISTRATION_OUTPUT_FIELD, PARTITION_REGISTRATION_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogType;

    private final String tableName;

    private final RegistrationOutput tableRegistrationOutput;

    private final RegistrationOutput partitionRegistrationOutput;

    private MetadataCatalogDetail(BuilderImpl builder) {
        this.catalogType = builder.catalogType;
        this.tableName = builder.tableName;
        this.tableRegistrationOutput = builder.tableRegistrationOutput;
        this.partitionRegistrationOutput = builder.partitionRegistrationOutput;
    }

    /**
     * <p>
     * The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter returns the
     * following value:
     * </p>
     * <dl>
     * <dt>GLUE</dt>
     * <dd>
     * <p>
     * The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a component.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #catalogType} will
     * return {@link CatalogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #catalogTypeAsString}.
     * </p>
     * 
     * @return The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter returns
     *         the following value:</p>
     *         <dl>
     *         <dt>GLUE</dt>
     *         <dd>
     *         <p>
     *         The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a
     *         component.
     *         </p>
     *         </dd>
     * @see CatalogType
     */
    public final CatalogType catalogType() {
        return CatalogType.fromValue(catalogType);
    }

    /**
     * <p>
     * The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter returns the
     * following value:
     * </p>
     * <dl>
     * <dt>GLUE</dt>
     * <dd>
     * <p>
     * The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a component.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #catalogType} will
     * return {@link CatalogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #catalogTypeAsString}.
     * </p>
     * 
     * @return The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter returns
     *         the following value:</p>
     *         <dl>
     *         <dt>GLUE</dt>
     *         <dd>
     *         <p>
     *         The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a
     *         component.
     *         </p>
     *         </dd>
     * @see CatalogType
     */
    public final String catalogTypeAsString() {
        return catalogType;
    }

    /**
     * <p>
     * The name of the table that stores the metadata for the associated flow run. The table stores metadata that
     * represents the data that the flow transferred. Amazon AppFlow stores the table in the metadata catalog.
     * </p>
     * 
     * @return The name of the table that stores the metadata for the associated flow run. The table stores metadata
     *         that represents the data that the flow transferred. Amazon AppFlow stores the table in the metadata
     *         catalog.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Describes the status of the attempt from Amazon AppFlow to register the metadata table with the metadata catalog.
     * Amazon AppFlow creates or updates this table for the associated flow run.
     * </p>
     * 
     * @return Describes the status of the attempt from Amazon AppFlow to register the metadata table with the metadata
     *         catalog. Amazon AppFlow creates or updates this table for the associated flow run.
     */
    public final RegistrationOutput tableRegistrationOutput() {
        return tableRegistrationOutput;
    }

    /**
     * <p>
     * Describes the status of the attempt from Amazon AppFlow to register the data partitions with the metadata
     * catalog. The data partitions organize the flow output into a hierarchical path, such as a folder path in an S3
     * bucket. Amazon AppFlow creates the partitions (if they don't already exist) based on your flow configuration.
     * </p>
     * 
     * @return Describes the status of the attempt from Amazon AppFlow to register the data partitions with the metadata
     *         catalog. The data partitions organize the flow output into a hierarchical path, such as a folder path in
     *         an S3 bucket. Amazon AppFlow creates the partitions (if they don't already exist) based on your flow
     *         configuration.
     */
    public final RegistrationOutput partitionRegistrationOutput() {
        return partitionRegistrationOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(tableRegistrationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(partitionRegistrationOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataCatalogDetail)) {
            return false;
        }
        MetadataCatalogDetail other = (MetadataCatalogDetail) obj;
        return Objects.equals(catalogTypeAsString(), other.catalogTypeAsString())
                && Objects.equals(tableName(), other.tableName())
                && Objects.equals(tableRegistrationOutput(), other.tableRegistrationOutput())
                && Objects.equals(partitionRegistrationOutput(), other.partitionRegistrationOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataCatalogDetail").add("CatalogType", catalogTypeAsString()).add("TableName", tableName())
                .add("TableRegistrationOutput", tableRegistrationOutput())
                .add("PartitionRegistrationOutput", partitionRegistrationOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalogType":
            return Optional.ofNullable(clazz.cast(catalogTypeAsString()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "tableRegistrationOutput":
            return Optional.ofNullable(clazz.cast(tableRegistrationOutput()));
        case "partitionRegistrationOutput":
            return Optional.ofNullable(clazz.cast(partitionRegistrationOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetadataCatalogDetail, T> g) {
        return obj -> g.apply((MetadataCatalogDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataCatalogDetail> {
        /**
         * <p>
         * The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter returns the
         * following value:
         * </p>
         * <dl>
         * <dt>GLUE</dt>
         * <dd>
         * <p>
         * The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a
         * component.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param catalogType
         *        The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter
         *        returns the following value:</p>
         *        <dl>
         *        <dt>GLUE</dt>
         *        <dd>
         *        <p>
         *        The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a
         *        component.
         *        </p>
         *        </dd>
         * @see CatalogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CatalogType
         */
        Builder catalogType(String catalogType);

        /**
         * <p>
         * The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter returns the
         * following value:
         * </p>
         * <dl>
         * <dt>GLUE</dt>
         * <dd>
         * <p>
         * The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a
         * component.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param catalogType
         *        The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter
         *        returns the following value:</p>
         *        <dl>
         *        <dt>GLUE</dt>
         *        <dd>
         *        <p>
         *        The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a
         *        component.
         *        </p>
         *        </dd>
         * @see CatalogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CatalogType
         */
        Builder catalogType(CatalogType catalogType);

        /**
         * <p>
         * The name of the table that stores the metadata for the associated flow run. The table stores metadata that
         * represents the data that the flow transferred. Amazon AppFlow stores the table in the metadata catalog.
         * </p>
         * 
         * @param tableName
         *        The name of the table that stores the metadata for the associated flow run. The table stores metadata
         *        that represents the data that the flow transferred. Amazon AppFlow stores the table in the metadata
         *        catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Describes the status of the attempt from Amazon AppFlow to register the metadata table with the metadata
         * catalog. Amazon AppFlow creates or updates this table for the associated flow run.
         * </p>
         * 
         * @param tableRegistrationOutput
         *        Describes the status of the attempt from Amazon AppFlow to register the metadata table with the
         *        metadata catalog. Amazon AppFlow creates or updates this table for the associated flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableRegistrationOutput(RegistrationOutput tableRegistrationOutput);

        /**
         * <p>
         * Describes the status of the attempt from Amazon AppFlow to register the metadata table with the metadata
         * catalog. Amazon AppFlow creates or updates this table for the associated flow run.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistrationOutput.Builder} avoiding the
         * need to create one manually via {@link RegistrationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegistrationOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #tableRegistrationOutput(RegistrationOutput)}.
         * 
         * @param tableRegistrationOutput
         *        a consumer that will call methods on {@link RegistrationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableRegistrationOutput(RegistrationOutput)
         */
        default Builder tableRegistrationOutput(Consumer<RegistrationOutput.Builder> tableRegistrationOutput) {
            return tableRegistrationOutput(RegistrationOutput.builder().applyMutation(tableRegistrationOutput).build());
        }

        /**
         * <p>
         * Describes the status of the attempt from Amazon AppFlow to register the data partitions with the metadata
         * catalog. The data partitions organize the flow output into a hierarchical path, such as a folder path in an
         * S3 bucket. Amazon AppFlow creates the partitions (if they don't already exist) based on your flow
         * configuration.
         * </p>
         * 
         * @param partitionRegistrationOutput
         *        Describes the status of the attempt from Amazon AppFlow to register the data partitions with the
         *        metadata catalog. The data partitions organize the flow output into a hierarchical path, such as a
         *        folder path in an S3 bucket. Amazon AppFlow creates the partitions (if they don't already exist) based
         *        on your flow configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionRegistrationOutput(RegistrationOutput partitionRegistrationOutput);

        /**
         * <p>
         * Describes the status of the attempt from Amazon AppFlow to register the data partitions with the metadata
         * catalog. The data partitions organize the flow output into a hierarchical path, such as a folder path in an
         * S3 bucket. Amazon AppFlow creates the partitions (if they don't already exist) based on your flow
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistrationOutput.Builder} avoiding the
         * need to create one manually via {@link RegistrationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegistrationOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #partitionRegistrationOutput(RegistrationOutput)}.
         * 
         * @param partitionRegistrationOutput
         *        a consumer that will call methods on {@link RegistrationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionRegistrationOutput(RegistrationOutput)
         */
        default Builder partitionRegistrationOutput(Consumer<RegistrationOutput.Builder> partitionRegistrationOutput) {
            return partitionRegistrationOutput(RegistrationOutput.builder().applyMutation(partitionRegistrationOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String catalogType;

        private String tableName;

        private RegistrationOutput tableRegistrationOutput;

        private RegistrationOutput partitionRegistrationOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataCatalogDetail model) {
            catalogType(model.catalogType);
            tableName(model.tableName);
            tableRegistrationOutput(model.tableRegistrationOutput);
            partitionRegistrationOutput(model.partitionRegistrationOutput);
        }

        public final String getCatalogType() {
            return catalogType;
        }

        public final void setCatalogType(String catalogType) {
            this.catalogType = catalogType;
        }

        @Override
        public final Builder catalogType(String catalogType) {
            this.catalogType = catalogType;
            return this;
        }

        @Override
        public final Builder catalogType(CatalogType catalogType) {
            this.catalogType(catalogType == null ? null : catalogType.toString());
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final RegistrationOutput.Builder getTableRegistrationOutput() {
            return tableRegistrationOutput != null ? tableRegistrationOutput.toBuilder() : null;
        }

        public final void setTableRegistrationOutput(RegistrationOutput.BuilderImpl tableRegistrationOutput) {
            this.tableRegistrationOutput = tableRegistrationOutput != null ? tableRegistrationOutput.build() : null;
        }

        @Override
        public final Builder tableRegistrationOutput(RegistrationOutput tableRegistrationOutput) {
            this.tableRegistrationOutput = tableRegistrationOutput;
            return this;
        }

        public final RegistrationOutput.Builder getPartitionRegistrationOutput() {
            return partitionRegistrationOutput != null ? partitionRegistrationOutput.toBuilder() : null;
        }

        public final void setPartitionRegistrationOutput(RegistrationOutput.BuilderImpl partitionRegistrationOutput) {
            this.partitionRegistrationOutput = partitionRegistrationOutput != null ? partitionRegistrationOutput.build() : null;
        }

        @Override
        public final Builder partitionRegistrationOutput(RegistrationOutput partitionRegistrationOutput) {
            this.partitionRegistrationOutput = partitionRegistrationOutput;
            return this;
        }

        @Override
        public MetadataCatalogDetail build() {
            return new MetadataCatalogDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
