/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name of the data and how often it should be pulled from the source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleConfiguration.Builder, ScheduleConfiguration> {
    private static final SdkField<String> FIRST_EXECUTION_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstExecutionFrom").getter(getter(ScheduleConfiguration::firstExecutionFrom))
            .setter(setter(Builder::firstExecutionFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstExecutionFrom").build())
            .build();

    private static final SdkField<String> OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Object")
            .getter(getter(ScheduleConfiguration::object)).setter(setter(Builder::object))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Object").build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(ScheduleConfiguration::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_EXECUTION_FROM_FIELD,
            OBJECT_FIELD, SCHEDULE_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String firstExecutionFrom;

    private final String object;

    private final String scheduleExpression;

    private ScheduleConfiguration(BuilderImpl builder) {
        this.firstExecutionFrom = builder.firstExecutionFrom;
        this.object = builder.object;
        this.scheduleExpression = builder.scheduleExpression;
    }

    /**
     * <p>
     * The start date for objects to import in the first flow run as an Unix/epoch timestamp in milliseconds or in
     * ISO-8601 format.
     * </p>
     * 
     * @return The start date for objects to import in the first flow run as an Unix/epoch timestamp in milliseconds or
     *         in ISO-8601 format.
     */
    public final String firstExecutionFrom() {
        return firstExecutionFrom;
    }

    /**
     * <p>
     * The name of the object to pull from the data source.
     * </p>
     * 
     * @return The name of the object to pull from the data source.
     */
    public final String object() {
        return object;
    }

    /**
     * <p>
     * How often the data should be pulled from data source.
     * </p>
     * 
     * @return How often the data should be pulled from data source.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firstExecutionFrom());
        hashCode = 31 * hashCode + Objects.hashCode(object());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleConfiguration)) {
            return false;
        }
        ScheduleConfiguration other = (ScheduleConfiguration) obj;
        return Objects.equals(firstExecutionFrom(), other.firstExecutionFrom()) && Objects.equals(object(), other.object())
                && Objects.equals(scheduleExpression(), other.scheduleExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleConfiguration").add("FirstExecutionFrom", firstExecutionFrom()).add("Object", object())
                .add("ScheduleExpression", scheduleExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirstExecutionFrom":
            return Optional.ofNullable(clazz.cast(firstExecutionFrom()));
        case "Object":
            return Optional.ofNullable(clazz.cast(object()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleConfiguration, T> g) {
        return obj -> g.apply((ScheduleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleConfiguration> {
        /**
         * <p>
         * The start date for objects to import in the first flow run as an Unix/epoch timestamp in milliseconds or in
         * ISO-8601 format.
         * </p>
         * 
         * @param firstExecutionFrom
         *        The start date for objects to import in the first flow run as an Unix/epoch timestamp in milliseconds
         *        or in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstExecutionFrom(String firstExecutionFrom);

        /**
         * <p>
         * The name of the object to pull from the data source.
         * </p>
         * 
         * @param object
         *        The name of the object to pull from the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder object(String object);

        /**
         * <p>
         * How often the data should be pulled from data source.
         * </p>
         * 
         * @param scheduleExpression
         *        How often the data should be pulled from data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);
    }

    static final class BuilderImpl implements Builder {
        private String firstExecutionFrom;

        private String object;

        private String scheduleExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleConfiguration model) {
            firstExecutionFrom(model.firstExecutionFrom);
            object(model.object);
            scheduleExpression(model.scheduleExpression);
        }

        public final String getFirstExecutionFrom() {
            return firstExecutionFrom;
        }

        public final void setFirstExecutionFrom(String firstExecutionFrom) {
            this.firstExecutionFrom = firstExecutionFrom;
        }

        @Override
        public final Builder firstExecutionFrom(String firstExecutionFrom) {
            this.firstExecutionFrom = firstExecutionFrom;
            return this;
        }

        public final String getObject() {
            return object;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        @Override
        public ScheduleConfiguration build() {
            return new ScheduleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
