/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalableTargetsRequest extends ApplicationAutoScalingRequest implements
        ToCopyableBuilder<DescribeScalableTargetsRequest.Builder, DescribeScalableTargetsRequest> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceNamespace").getter(getter(DescribeScalableTargetsRequest::serviceNamespaceAsString))
            .setter(setter(Builder::serviceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()).build();

    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceIds")
            .getter(getter(DescribeScalableTargetsRequest::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalableDimension").getter(getter(DescribeScalableTargetsRequest::scalableDimensionAsString))
            .setter(setter(Builder::scalableDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeScalableTargetsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeScalableTargetsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD,
            RESOURCE_IDS_FIELD, SCALABLE_DIMENSION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String serviceNamespace;

    private final List<String> resourceIds;

    private final String scalableDimension;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeScalableTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceIds = builder.resourceIds;
        this.scalableDimension = builder.scalableDimension;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your own
     * application or service, use <code>custom-resource</code> instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNamespace}
     * will return {@link ServiceNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNamespaceAsString}.
     * </p>
     * 
     * @return The namespace of the Amazon Web Services service that provides the resource. For a resource provided by
     *         your own application or service, use <code>custom-resource</code> instead.
     * @see ServiceNamespace
     */
    public final ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(serviceNamespace);
    }

    /**
     * <p>
     * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your own
     * application or service, use <code>custom-resource</code> instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNamespace}
     * will return {@link ServiceNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNamespaceAsString}.
     * </p>
     * 
     * @return The namespace of the Amazon Web Services service that provides the resource. For a resource provided by
     *         your own application or service, use <code>custom-resource</code> instead.
     * @see ServiceNamespace
     */
    public final String serviceNamespaceAsString() {
        return serviceNamespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the resource associated with the scalable target. This string consists of the resource type and
     * unique identifier.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service
     * name. Example: <code>service/default/sample-webapp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet
     * request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and
     * instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name.
     * Example: <code>fleet/sample-fleet</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example:
     * <code>table/my-table</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index
     * name. Example: <code>table/my-table/index/my-table-index</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
     * Example: <code>cluster:my-db-cluster</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource
     * ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code>
     * from the CloudFormation template stack used to access the resources. The unique identifier is defined by the
     * service provider. More information is available in our <a
     * href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using
     * the endpoint ARN. Example:
     * <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the
     * endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the
     * function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
     * <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name.
     * Example: <code>keyspace/mykeyspace/table/mytable</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example:
     * <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique
     * identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
     * Example: <code>cluster:mycluster</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIds} method.
     * </p>
     * 
     * @return The identifier of the resource associated with the scalable target. This string consists of the resource
     *         type and unique identifier.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and
     *         service name. Example: <code>service/default/sample-webapp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot
     *         Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID
     *         and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet
     *         name. Example: <code>fleet/sample-fleet</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
     *         Example: <code>table/my-table</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is
     *         the index name. Example: <code>table/my-table/index/my-table-index</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
     *         name. Example: <code>cluster:my-db-cluster</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the
     *         resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Custom resources are not supported with a resource type. This parameter must specify the
     *         <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique
     *         identifier is defined by the service provider. More information is available in our <a
     *         href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Comprehend document classification endpoint - The resource type and unique identifier are
     *         specified using the endpoint ARN. Example:
     *         <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified
     *         using the endpoint ARN. Example:
     *         <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is
     *         the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
     *         <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table
     *         name. Example: <code>keyspace/mykeyspace/table/mytable</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
     *         Example:
     *         <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique
     *         identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
     *         name. Example: <code>cluster:mycluster</code>.
     *         </p>
     *         </li>
     */
    public final List<String> resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * The scalable dimension associated with the scalable target. This string consists of the service namespace,
     * resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource ID.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for
     * Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint
     * variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
     * your own application or service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend document classification endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend entity recognizer endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK
     * cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache
     * replication group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
     * ElastiCache replication group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalableDimension}
     * will return {@link ScalableDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalableDimensionAsString}.
     * </p>
     * 
     * @return The scalable dimension associated with the scalable target. This string consists of the service
     *         namespace, resource type, and scaling property. If you specify a scalable dimension, you must also
     *         specify a resource ID.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
     *         Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model
     *         endpoint variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
     *         provided by your own application or service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
     *         units for an Amazon Comprehend document classification endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units
     *         for an Amazon Comprehend entity recognizer endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an
     *         Amazon MSK cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon
     *         ElastiCache replication group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
     *         ElastiCache replication group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB
     *         cluster.
     *         </p>
     *         </li>
     * @see ScalableDimension
     */
    public final ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(scalableDimension);
    }

    /**
     * <p>
     * The scalable dimension associated with the scalable target. This string consists of the service namespace,
     * resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource ID.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for
     * Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model endpoint
     * variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
     * your own application or service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend document classification endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend entity recognizer endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK
     * cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache
     * replication group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
     * ElastiCache replication group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalableDimension}
     * will return {@link ScalableDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalableDimensionAsString}.
     * </p>
     * 
     * @return The scalable dimension associated with the scalable target. This string consists of the service
     *         namespace, resource type, and scaling property. If you specify a scalable dimension, you must also
     *         specify a resource ID.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
     *         Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model
     *         endpoint variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
     *         provided by your own application or service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
     *         units for an Amazon Comprehend document classification endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units
     *         for an Amazon Comprehend entity recognizer endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an
     *         Amazon MSK cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon
     *         ElastiCache replication group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
     *         ElastiCache replication group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB
     *         cluster.
     *         </p>
     *         </li>
     * @see ScalableDimension
     */
    public final String scalableDimensionAsString() {
        return scalableDimension;
    }

    /**
     * <p>
     * The maximum number of scalable targets. This value can be between 1 and 50. The default value is 50.
     * </p>
     * <p>
     * If this parameter is used, the operation returns up to <code>MaxResults</code> results at a time, along with a
     * <code>NextToken</code> value. To get the next set of results, include the <code>NextToken</code> value in a
     * subsequent call. If this parameter is not used, the operation returns up to 50 results and a
     * <code>NextToken</code> value, if applicable.
     * </p>
     * 
     * @return The maximum number of scalable targets. This value can be between 1 and 50. The default value is 50.</p>
     *         <p>
     *         If this parameter is used, the operation returns up to <code>MaxResults</code> results at a time, along
     *         with a <code>NextToken</code> value. To get the next set of results, include the <code>NextToken</code>
     *         value in a subsequent call. If this parameter is not used, the operation returns up to 50 results and a
     *         <code>NextToken</code> value, if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalableTargetsRequest)) {
            return false;
        }
        DescribeScalableTargetsRequest other = (DescribeScalableTargetsRequest) obj;
        return Objects.equals(serviceNamespaceAsString(), other.serviceNamespaceAsString())
                && hasResourceIds() == other.hasResourceIds() && Objects.equals(resourceIds(), other.resourceIds())
                && Objects.equals(scalableDimensionAsString(), other.scalableDimensionAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScalableTargetsRequest").add("ServiceNamespace", serviceNamespaceAsString())
                .add("ResourceIds", hasResourceIds() ? resourceIds() : null)
                .add("ScalableDimension", scalableDimensionAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceNamespace":
            return Optional.ofNullable(clazz.cast(serviceNamespaceAsString()));
        case "ResourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "ScalableDimension":
            return Optional.ofNullable(clazz.cast(scalableDimensionAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalableTargetsRequest, T> g) {
        return obj -> g.apply((DescribeScalableTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationAutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScalableTargetsRequest> {
        /**
         * <p>
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your
         * own application or service, use <code>custom-resource</code> instead.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the Amazon Web Services service that provides the resource. For a resource provided
         *        by your own application or service, use <code>custom-resource</code> instead.
         * @see ServiceNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNamespace
         */
        Builder serviceNamespace(String serviceNamespace);

        /**
         * <p>
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your
         * own application or service, use <code>custom-resource</code> instead.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the Amazon Web Services service that provides the resource. For a resource provided
         *        by your own application or service, use <code>custom-resource</code> instead.
         * @see ServiceNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNamespace
         */
        Builder serviceNamespace(ServiceNamespace serviceNamespace);

        /**
         * <p>
         * The identifier of the resource associated with the scalable target. This string consists of the resource type
         * and unique identifier.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and
         * service name. Example: <code>service/default/sample-webapp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet
         * request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and
         * instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name.
         * Example: <code>fleet/sample-fleet</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
         * Example: <code>table/my-table</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the
         * index name. Example: <code>table/my-table/index/my-table-index</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
         * Example: <code>cluster:my-db-cluster</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the
         * resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Custom resources are not supported with a resource type. This parameter must specify the
         * <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique
         * identifier is defined by the service provider. More information is available in our <a
         * href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified
         * using the endpoint ARN. Example:
         * <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using
         * the endpoint ARN. Example:
         * <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the
         * function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
         * <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name.
         * Example: <code>keyspace/mykeyspace/table/mytable</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example:
         * <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>
         * .
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique
         * identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
         * Example: <code>cluster:mycluster</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceIds
         *        The identifier of the resource associated with the scalable target. This string consists of the
         *        resource type and unique identifier.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name
         *        and service name. Example: <code>service/default/sample-webapp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the
         *        Spot Fleet request ID. Example:
         *        <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster
         *        ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet
         *        name. Example: <code>fleet/sample-fleet</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
         *        Example: <code>table/my-table</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is
         *        the index name. Example: <code>table/my-table/index/my-table-index</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
         *        name. Example: <code>cluster:my-db-cluster</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is
         *        the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Custom resources are not supported with a resource type. This parameter must specify the
         *        <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The
         *        unique identifier is defined by the service provider. More information is available in our <a
         *        href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Comprehend document classification endpoint - The resource type and unique identifier are
         *        specified using the endpoint ARN. Example:
         *        <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified
         *        using the endpoint ARN. Example:
         *        <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier
         *        is the function name with a function version or alias name suffix that is not <code>$LATEST</code>.
         *        Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the
         *        table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         *        Example:
         *        <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the
         *        unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
         *        name. Example: <code>cluster:mycluster</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * The identifier of the resource associated with the scalable target. This string consists of the resource type
         * and unique identifier.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and
         * service name. Example: <code>service/default/sample-webapp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet
         * request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and
         * instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name.
         * Example: <code>fleet/sample-fleet</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
         * Example: <code>table/my-table</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the
         * index name. Example: <code>table/my-table/index/my-table-index</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
         * Example: <code>cluster:my-db-cluster</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the
         * resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Custom resources are not supported with a resource type. This parameter must specify the
         * <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique
         * identifier is defined by the service provider. More information is available in our <a
         * href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified
         * using the endpoint ARN. Example:
         * <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using
         * the endpoint ARN. Example:
         * <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the
         * function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
         * <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name.
         * Example: <code>keyspace/mykeyspace/table/mytable</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example:
         * <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>
         * .
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique
         * identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
         * Example: <code>cluster:mycluster</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceIds
         *        The identifier of the resource associated with the scalable target. This string consists of the
         *        resource type and unique identifier.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name
         *        and service name. Example: <code>service/default/sample-webapp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the
         *        Spot Fleet request ID. Example:
         *        <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster
         *        ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet
         *        name. Example: <code>fleet/sample-fleet</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
         *        Example: <code>table/my-table</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is
         *        the index name. Example: <code>table/my-table/index/my-table-index</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
         *        name. Example: <code>cluster:my-db-cluster</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is
         *        the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Custom resources are not supported with a resource type. This parameter must specify the
         *        <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The
         *        unique identifier is defined by the service provider. More information is available in our <a
         *        href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Comprehend document classification endpoint - The resource type and unique identifier are
         *        specified using the endpoint ARN. Example:
         *        <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified
         *        using the endpoint ARN. Example:
         *        <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier
         *        is the function name with a function version or alias name suffix that is not <code>$LATEST</code>.
         *        Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the
         *        table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         *        Example:
         *        <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the
         *        unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
         *        name. Example: <code>cluster:mycluster</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);

        /**
         * <p>
         * The scalable dimension associated with the scalable target. This string consists of the service namespace,
         * resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource
         * ID.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
         * index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         * secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available
         * for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model
         * endpoint variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
         * your own application or service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units
         * for an Amazon Comprehend document classification endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for
         * an Amazon Comprehend entity recognizer endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon
         * MSK cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache
         * replication group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
         * ElastiCache replication group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalableDimension
         *        The scalable dimension associated with the scalable target. This string consists of the service
         *        namespace, resource type, and scaling property. If you specify a scalable dimension, you must also
         *        specify a resource ID.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance
         *        Group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
         *        Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker
         *        model endpoint variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
         *        provided by your own application or service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend document classification endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend entity recognizer endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda
         *        function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon
         *        Keyspaces table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an
         *        Amazon MSK cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon
         *        ElastiCache replication group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an
         *        Amazon ElastiCache replication group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB
         *        cluster.
         *        </p>
         *        </li>
         * @see ScalableDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalableDimension
         */
        Builder scalableDimension(String scalableDimension);

        /**
         * <p>
         * The scalable dimension associated with the scalable target. This string consists of the service namespace,
         * resource type, and scaling property. If you specify a scalable dimension, you must also specify a resource
         * ID.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
         * index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         * secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available
         * for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker model
         * endpoint variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
         * your own application or service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units
         * for an Amazon Comprehend document classification endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for
         * an Amazon Comprehend entity recognizer endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon
         * MSK cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache
         * replication group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
         * ElastiCache replication group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalableDimension
         *        The scalable dimension associated with the scalable target. This string consists of the service
         *        namespace, resource type, and scaling property. If you specify a scalable dimension, you must also
         *        specify a resource ID.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance
         *        Group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
         *        Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for an SageMaker
         *        model endpoint variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
         *        provided by your own application or service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend document classification endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend entity recognizer endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda
         *        function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon
         *        Keyspaces table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an
         *        Amazon MSK cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon
         *        ElastiCache replication group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an
         *        Amazon ElastiCache replication group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB
         *        cluster.
         *        </p>
         *        </li>
         * @see ScalableDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalableDimension
         */
        Builder scalableDimension(ScalableDimension scalableDimension);

        /**
         * <p>
         * The maximum number of scalable targets. This value can be between 1 and 50. The default value is 50.
         * </p>
         * <p>
         * If this parameter is used, the operation returns up to <code>MaxResults</code> results at a time, along with
         * a <code>NextToken</code> value. To get the next set of results, include the <code>NextToken</code> value in a
         * subsequent call. If this parameter is not used, the operation returns up to 50 results and a
         * <code>NextToken</code> value, if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of scalable targets. This value can be between 1 and 50. The default value is
         *        50.</p>
         *        <p>
         *        If this parameter is used, the operation returns up to <code>MaxResults</code> results at a time,
         *        along with a <code>NextToken</code> value. To get the next set of results, include the
         *        <code>NextToken</code> value in a subsequent call. If this parameter is not used, the operation
         *        returns up to 50 results and a <code>NextToken</code> value, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationAutoScalingRequest.BuilderImpl implements Builder {
        private String serviceNamespace;

        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private String scalableDimension;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalableTargetsRequest model) {
            super(model);
            serviceNamespace(model.serviceNamespace);
            resourceIds(model.resourceIds);
            scalableDimension(model.scalableDimension);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getServiceNamespace() {
            return serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsMaxLen1600Copier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsMaxLen1600Copier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final String getScalableDimension() {
            return scalableDimension;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalableTargetsRequest build() {
            return new DescribeScalableTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
