/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.internal;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingServiceClientConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.auth.scheme.ApplicationAutoScalingAuthSchemeProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApplicationAutoScalingServiceClientConfigurationBuilder
implements ApplicationAutoScalingServiceClientConfiguration.Builder {
    private final SdkClientConfiguration.Builder config;

    public ApplicationAutoScalingServiceClientConfigurationBuilder() {
        this(SdkClientConfiguration.builder());
    }

    public ApplicationAutoScalingServiceClientConfigurationBuilder(SdkClientConfiguration.Builder config) {
        this.config = config;
    }

    @Override
    public ApplicationAutoScalingServiceClientConfiguration.Builder overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.config.putAll(overrideConfiguration);
        return this;
    }

    @Override
    public ClientOverrideConfiguration overrideConfiguration() {
        return (ClientOverrideConfiguration)this.config.asOverrideConfigurationBuilder().build();
    }

    @Override
    public ApplicationAutoScalingServiceClientConfiguration.Builder endpointOverride(URI endpointOverride) {
        if (endpointOverride != null) {
            this.config.option((ClientOption)SdkClientOption.ENDPOINT, (Object)endpointOverride);
            this.config.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN, (Object)true);
        } else {
            this.config.option((ClientOption)SdkClientOption.ENDPOINT, null);
            this.config.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN, (Object)false);
        }
        return this;
    }

    @Override
    public URI endpointOverride() {
        if (Boolean.TRUE.equals(this.config.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            return (URI)this.config.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return null;
    }

    @Override
    public ApplicationAutoScalingServiceClientConfiguration.Builder endpointProvider(EndpointProvider endpointProvider) {
        this.config.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    @Override
    public EndpointProvider endpointProvider() {
        return (EndpointProvider)this.config.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
    }

    @Override
    public ApplicationAutoScalingServiceClientConfiguration.Builder region(Region region) {
        this.config.option((ClientOption)AwsClientOption.AWS_REGION, (Object)region);
        return this;
    }

    @Override
    public Region region() {
        return (Region)this.config.option((ClientOption)AwsClientOption.AWS_REGION);
    }

    @Override
    public ApplicationAutoScalingServiceClientConfiguration.Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
        this.config.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, credentialsProvider);
        return this;
    }

    @Override
    public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider() {
        return (IdentityProvider)this.config.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
    }

    @Override
    public ApplicationAutoScalingServiceClientConfiguration.Builder putAuthScheme(AuthScheme<?> authScheme) {
        ((Map)this.config.computeOptionIfAbsent((ClientOption)SdkClientOption.AUTH_SCHEMES, HashMap::new)).put(authScheme.schemeId(), authScheme);
        return this;
    }

    @Override
    public Map<String, AuthScheme<?>> authSchemes() {
        Map authSchemes = (Map)this.config.option((ClientOption)SdkClientOption.AUTH_SCHEMES);
        return Collections.unmodifiableMap(authSchemes == null ? Collections.emptyMap() : authSchemes);
    }

    @Override
    public ApplicationAutoScalingServiceClientConfiguration.Builder authSchemeProvider(ApplicationAutoScalingAuthSchemeProvider authSchemeProvider) {
        this.config.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)authSchemeProvider);
        return this;
    }

    @Override
    public ApplicationAutoScalingAuthSchemeProvider authSchemeProvider() {
        AuthSchemeProvider result = (AuthSchemeProvider)this.config.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER);
        if (result == null) {
            return null;
        }
        return (ApplicationAutoScalingAuthSchemeProvider)Validate.isInstanceOf(ApplicationAutoScalingAuthSchemeProvider.class, (Object)result, (String)("Expected an instance of " + ApplicationAutoScalingAuthSchemeProvider.class.getSimpleName()), (Object[])new Object[0]);
    }

    @Override
    public ApplicationAutoScalingServiceClientConfiguration build() {
        return new ApplicationAutoScalingServiceClientConfiguration(this);
    }
}

