/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inventory data for installed discovery agents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerAgentInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerAgentInfo.Builder, CustomerAgentInfo> {
    private static final SdkField<Integer> ACTIVE_AGENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("activeAgents").getter(getter(CustomerAgentInfo::activeAgents)).setter(setter(Builder::activeAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeAgents").build()).build();

    private static final SdkField<Integer> HEALTHY_AGENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthyAgents").getter(getter(CustomerAgentInfo::healthyAgents)).setter(setter(Builder::healthyAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyAgents").build()).build();

    private static final SdkField<Integer> BLACK_LISTED_AGENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("blackListedAgents").getter(getter(CustomerAgentInfo::blackListedAgents))
            .setter(setter(Builder::blackListedAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackListedAgents").build()).build();

    private static final SdkField<Integer> SHUTDOWN_AGENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shutdownAgents").getter(getter(CustomerAgentInfo::shutdownAgents))
            .setter(setter(Builder::shutdownAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shutdownAgents").build()).build();

    private static final SdkField<Integer> UNHEALTHY_AGENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unhealthyAgents").getter(getter(CustomerAgentInfo::unhealthyAgents))
            .setter(setter(Builder::unhealthyAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyAgents").build()).build();

    private static final SdkField<Integer> TOTAL_AGENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalAgents").getter(getter(CustomerAgentInfo::totalAgents)).setter(setter(Builder::totalAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalAgents").build()).build();

    private static final SdkField<Integer> UNKNOWN_AGENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unknownAgents").getter(getter(CustomerAgentInfo::unknownAgents)).setter(setter(Builder::unknownAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownAgents").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_AGENTS_FIELD,
            HEALTHY_AGENTS_FIELD, BLACK_LISTED_AGENTS_FIELD, SHUTDOWN_AGENTS_FIELD, UNHEALTHY_AGENTS_FIELD, TOTAL_AGENTS_FIELD,
            UNKNOWN_AGENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer activeAgents;

    private final Integer healthyAgents;

    private final Integer blackListedAgents;

    private final Integer shutdownAgents;

    private final Integer unhealthyAgents;

    private final Integer totalAgents;

    private final Integer unknownAgents;

    private CustomerAgentInfo(BuilderImpl builder) {
        this.activeAgents = builder.activeAgents;
        this.healthyAgents = builder.healthyAgents;
        this.blackListedAgents = builder.blackListedAgents;
        this.shutdownAgents = builder.shutdownAgents;
        this.unhealthyAgents = builder.unhealthyAgents;
        this.totalAgents = builder.totalAgents;
        this.unknownAgents = builder.unknownAgents;
    }

    /**
     * <p>
     * Number of active discovery agents.
     * </p>
     * 
     * @return Number of active discovery agents.
     */
    public final Integer activeAgents() {
        return activeAgents;
    }

    /**
     * <p>
     * Number of healthy discovery agents
     * </p>
     * 
     * @return Number of healthy discovery agents
     */
    public final Integer healthyAgents() {
        return healthyAgents;
    }

    /**
     * <p>
     * Number of blacklisted discovery agents.
     * </p>
     * 
     * @return Number of blacklisted discovery agents.
     */
    public final Integer blackListedAgents() {
        return blackListedAgents;
    }

    /**
     * <p>
     * Number of discovery agents with status SHUTDOWN.
     * </p>
     * 
     * @return Number of discovery agents with status SHUTDOWN.
     */
    public final Integer shutdownAgents() {
        return shutdownAgents;
    }

    /**
     * <p>
     * Number of unhealthy discovery agents.
     * </p>
     * 
     * @return Number of unhealthy discovery agents.
     */
    public final Integer unhealthyAgents() {
        return unhealthyAgents;
    }

    /**
     * <p>
     * Total number of discovery agents.
     * </p>
     * 
     * @return Total number of discovery agents.
     */
    public final Integer totalAgents() {
        return totalAgents;
    }

    /**
     * <p>
     * Number of unknown discovery agents.
     * </p>
     * 
     * @return Number of unknown discovery agents.
     */
    public final Integer unknownAgents() {
        return unknownAgents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeAgents());
        hashCode = 31 * hashCode + Objects.hashCode(healthyAgents());
        hashCode = 31 * hashCode + Objects.hashCode(blackListedAgents());
        hashCode = 31 * hashCode + Objects.hashCode(shutdownAgents());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyAgents());
        hashCode = 31 * hashCode + Objects.hashCode(totalAgents());
        hashCode = 31 * hashCode + Objects.hashCode(unknownAgents());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerAgentInfo)) {
            return false;
        }
        CustomerAgentInfo other = (CustomerAgentInfo) obj;
        return Objects.equals(activeAgents(), other.activeAgents()) && Objects.equals(healthyAgents(), other.healthyAgents())
                && Objects.equals(blackListedAgents(), other.blackListedAgents())
                && Objects.equals(shutdownAgents(), other.shutdownAgents())
                && Objects.equals(unhealthyAgents(), other.unhealthyAgents())
                && Objects.equals(totalAgents(), other.totalAgents()) && Objects.equals(unknownAgents(), other.unknownAgents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerAgentInfo").add("ActiveAgents", activeAgents()).add("HealthyAgents", healthyAgents())
                .add("BlackListedAgents", blackListedAgents()).add("ShutdownAgents", shutdownAgents())
                .add("UnhealthyAgents", unhealthyAgents()).add("TotalAgents", totalAgents())
                .add("UnknownAgents", unknownAgents()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeAgents":
            return Optional.ofNullable(clazz.cast(activeAgents()));
        case "healthyAgents":
            return Optional.ofNullable(clazz.cast(healthyAgents()));
        case "blackListedAgents":
            return Optional.ofNullable(clazz.cast(blackListedAgents()));
        case "shutdownAgents":
            return Optional.ofNullable(clazz.cast(shutdownAgents()));
        case "unhealthyAgents":
            return Optional.ofNullable(clazz.cast(unhealthyAgents()));
        case "totalAgents":
            return Optional.ofNullable(clazz.cast(totalAgents()));
        case "unknownAgents":
            return Optional.ofNullable(clazz.cast(unknownAgents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerAgentInfo, T> g) {
        return obj -> g.apply((CustomerAgentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerAgentInfo> {
        /**
         * <p>
         * Number of active discovery agents.
         * </p>
         * 
         * @param activeAgents
         *        Number of active discovery agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeAgents(Integer activeAgents);

        /**
         * <p>
         * Number of healthy discovery agents
         * </p>
         * 
         * @param healthyAgents
         *        Number of healthy discovery agents
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyAgents(Integer healthyAgents);

        /**
         * <p>
         * Number of blacklisted discovery agents.
         * </p>
         * 
         * @param blackListedAgents
         *        Number of blacklisted discovery agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blackListedAgents(Integer blackListedAgents);

        /**
         * <p>
         * Number of discovery agents with status SHUTDOWN.
         * </p>
         * 
         * @param shutdownAgents
         *        Number of discovery agents with status SHUTDOWN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdownAgents(Integer shutdownAgents);

        /**
         * <p>
         * Number of unhealthy discovery agents.
         * </p>
         * 
         * @param unhealthyAgents
         *        Number of unhealthy discovery agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyAgents(Integer unhealthyAgents);

        /**
         * <p>
         * Total number of discovery agents.
         * </p>
         * 
         * @param totalAgents
         *        Total number of discovery agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAgents(Integer totalAgents);

        /**
         * <p>
         * Number of unknown discovery agents.
         * </p>
         * 
         * @param unknownAgents
         *        Number of unknown discovery agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownAgents(Integer unknownAgents);
    }

    static final class BuilderImpl implements Builder {
        private Integer activeAgents;

        private Integer healthyAgents;

        private Integer blackListedAgents;

        private Integer shutdownAgents;

        private Integer unhealthyAgents;

        private Integer totalAgents;

        private Integer unknownAgents;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerAgentInfo model) {
            activeAgents(model.activeAgents);
            healthyAgents(model.healthyAgents);
            blackListedAgents(model.blackListedAgents);
            shutdownAgents(model.shutdownAgents);
            unhealthyAgents(model.unhealthyAgents);
            totalAgents(model.totalAgents);
            unknownAgents(model.unknownAgents);
        }

        public final Integer getActiveAgents() {
            return activeAgents;
        }

        public final void setActiveAgents(Integer activeAgents) {
            this.activeAgents = activeAgents;
        }

        @Override
        public final Builder activeAgents(Integer activeAgents) {
            this.activeAgents = activeAgents;
            return this;
        }

        public final Integer getHealthyAgents() {
            return healthyAgents;
        }

        public final void setHealthyAgents(Integer healthyAgents) {
            this.healthyAgents = healthyAgents;
        }

        @Override
        public final Builder healthyAgents(Integer healthyAgents) {
            this.healthyAgents = healthyAgents;
            return this;
        }

        public final Integer getBlackListedAgents() {
            return blackListedAgents;
        }

        public final void setBlackListedAgents(Integer blackListedAgents) {
            this.blackListedAgents = blackListedAgents;
        }

        @Override
        public final Builder blackListedAgents(Integer blackListedAgents) {
            this.blackListedAgents = blackListedAgents;
            return this;
        }

        public final Integer getShutdownAgents() {
            return shutdownAgents;
        }

        public final void setShutdownAgents(Integer shutdownAgents) {
            this.shutdownAgents = shutdownAgents;
        }

        @Override
        public final Builder shutdownAgents(Integer shutdownAgents) {
            this.shutdownAgents = shutdownAgents;
            return this;
        }

        public final Integer getUnhealthyAgents() {
            return unhealthyAgents;
        }

        public final void setUnhealthyAgents(Integer unhealthyAgents) {
            this.unhealthyAgents = unhealthyAgents;
        }

        @Override
        public final Builder unhealthyAgents(Integer unhealthyAgents) {
            this.unhealthyAgents = unhealthyAgents;
            return this;
        }

        public final Integer getTotalAgents() {
            return totalAgents;
        }

        public final void setTotalAgents(Integer totalAgents) {
            this.totalAgents = totalAgents;
        }

        @Override
        public final Builder totalAgents(Integer totalAgents) {
            this.totalAgents = totalAgents;
            return this;
        }

        public final Integer getUnknownAgents() {
            return unknownAgents;
        }

        public final void setUnknownAgents(Integer unknownAgents) {
            this.unknownAgents = unknownAgents;
        }

        @Override
        public final Builder unknownAgents(Integer unknownAgents) {
            this.unknownAgents = unknownAgents;
            return this;
        }

        @Override
        public CustomerAgentInfo build() {
            return new CustomerAgentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
